/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.view;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mitre.jwt.encryption.service.JwtEncryptionAndDecryptionService;
import org.mitre.jwt.signer.service.JwtSigningAndValidationService;
import org.mitre.jwt.signer.service.impl.JWKSetCacheService;
import org.mitre.jwt.signer.service.impl.SymmetricCacheService;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.openid.connect.config.ConfigurationPropertiesBean;
import org.mitre.openid.connect.view.UserInfoView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="userInfoJwtView")
public class UserInfoJwtView
extends UserInfoView {
    private static Logger logger = LoggerFactory.getLogger(UserInfoJwtView.class);
    @Autowired
    private JwtSigningAndValidationService jwtService;
    @Autowired
    private ConfigurationPropertiesBean config;
    @Autowired
    private JWKSetCacheService encrypters;
    @Autowired
    private SymmetricCacheService symmetricCacheService;

    @Override
    protected void writeOut(JsonObject json, Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        try {
            ClientDetailsEntity client = (ClientDetailsEntity)model.get("client");
            StringWriter writer = new StringWriter();
            this.gson.toJson((JsonElement)json, (Appendable)writer);
            response.setContentType("application/jwt");
            JWTClaimsSet claims = JWTClaimsSet.parse((String)writer.toString());
            claims.setAudience((List)Lists.newArrayList((Object[])new String[]{client.getClientId()}));
            claims.setIssuer(this.config.getIssuer());
            claims.setIssueTime(new Date());
            claims.setJWTID(UUID.randomUUID().toString());
            if (!(client.getIdTokenEncryptedResponseAlg() == null || client.getIdTokenEncryptedResponseAlg().equals((Object)Algorithm.NONE) || client.getIdTokenEncryptedResponseEnc() == null || client.getIdTokenEncryptedResponseEnc().equals((Object)Algorithm.NONE) || Strings.isNullOrEmpty((String)client.getJwksUri()))) {
                JwtEncryptionAndDecryptionService encrypter = this.encrypters.getEncrypter(client.getJwksUri());
                if (encrypter != null) {
                    EncryptedJWT encrypted = new EncryptedJWT(new JWEHeader(client.getIdTokenEncryptedResponseAlg(), client.getIdTokenEncryptedResponseEnc()), (ReadOnlyJWTClaimsSet)claims);
                    encrypter.encryptJwt((JWEObject)encrypted);
                    PrintWriter out = response.getWriter();
                    ((Writer)out).write(encrypted.serialize());
                } else {
                    logger.error("Couldn't find encrypter for client: " + client.getClientId());
                }
            } else {
                JWSAlgorithm signingAlg = this.jwtService.getDefaultSigningAlgorithm();
                if (client.getUserInfoSignedResponseAlg() != null) {
                    signingAlg = client.getUserInfoSignedResponseAlg();
                }
                SignedJWT signed = new SignedJWT(new JWSHeader(signingAlg), (ReadOnlyJWTClaimsSet)claims);
                if (signingAlg.equals((Object)JWSAlgorithm.HS256) || signingAlg.equals((Object)JWSAlgorithm.HS384) || signingAlg.equals((Object)JWSAlgorithm.HS512)) {
                    JwtSigningAndValidationService signer = this.symmetricCacheService.getSymmetricValidtor(client);
                    signer.signJwt(signed);
                } else {
                    this.jwtService.signJwt(signed);
                }
                PrintWriter out = response.getWriter();
                ((Writer)out).write(signed.serialize());
            }
        }
        catch (IOException e) {
            logger.error("IO Exception in UserInfoJwtView", (Throwable)e);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

