/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.web;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Set;
import org.mitre.jose.JWEAlgorithmEmbed;
import org.mitre.jose.JWEEncryptionMethodEmbed;
import org.mitre.jose.JWSAlgorithmEmbed;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.openid.connect.model.UserInfo;
import org.mitre.openid.connect.service.UserInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/api/clients"})
@PreAuthorize(value="hasRole('ROLE_USER')")
public class ClientAPI {
    @Autowired
    private ClientDetailsEntityService clientService;
    @Autowired
    private UserInfoService userInfoService;
    private JsonParser parser = new JsonParser();
    private Gson gson = new GsonBuilder().serializeNulls().registerTypeAdapter(JWSAlgorithmEmbed.class, (Object)new JsonDeserializer<JWSAlgorithmEmbed>(){

        public JWSAlgorithmEmbed deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive()) {
                return JWSAlgorithmEmbed.getForAlgorithmName((String)json.getAsString());
            }
            return null;
        }
    }).registerTypeAdapter(JWEAlgorithmEmbed.class, (Object)new JsonDeserializer<JWEAlgorithmEmbed>(){

        public JWEAlgorithmEmbed deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive()) {
                return JWEAlgorithmEmbed.getForAlgorithmName((String)json.getAsString());
            }
            return null;
        }
    }).registerTypeAdapter(JWEEncryptionMethodEmbed.class, (Object)new JsonDeserializer<JWEEncryptionMethodEmbed>(){

        public JWEEncryptionMethodEmbed deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive()) {
                return JWEEncryptionMethodEmbed.getForAlgorithmName((String)json.getAsString());
            }
            return null;
        }
    }).setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").create();
    private static Logger logger = LoggerFactory.getLogger(ClientAPI.class);

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    public String apiGetAllClients(Model model, Authentication auth) {
        Collection clients = this.clientService.getAllClients();
        model.addAttribute("entity", (Object)clients);
        if (this.isAdmin(auth)) {
            return "clientEntityViewAdmins";
        }
        return "clientEntityViewUsers";
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String apiAddClient(@RequestBody String jsonString, Model m, Authentication auth) {
        UserInfo user;
        JsonObject json = null;
        ClientDetailsEntity client = null;
        try {
            json = this.parser.parse(jsonString).getAsJsonObject();
            client = (ClientDetailsEntity)this.gson.fromJson((JsonElement)json, ClientDetailsEntity.class);
        }
        catch (JsonSyntaxException e) {
            logger.error("apiAddClient failed due to JsonSyntaxException", (Throwable)e);
            m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
            m.addAttribute("errorMessage", (Object)"Could not save new client. The server encountered a JSON syntax exception. Contact a system administrator for assistance.");
            return "jsonErrorView";
        }
        catch (IllegalStateException e) {
            logger.error("apiAddClient failed due to IllegalStateException", (Throwable)e);
            m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
            m.addAttribute("errorMessage", (Object)"Could not save new client. The server encountered an IllegalStateException. Refresh and try again - if the problem persists, contact a system administrator for assistance.");
            return "jsonErrorView";
        }
        if (Strings.isNullOrEmpty((String)client.getClientId())) {
            client = this.clientService.generateClientId(client);
        }
        if (client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.SECRET_BASIC) || client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.SECRET_POST) || client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.SECRET_JWT)) {
            if (json.has("generateClientSecret") && json.get("generateClientSecret").getAsBoolean() || Strings.isNullOrEmpty((String)client.getClientSecret())) {
                client = this.clientService.generateClientSecret(client);
            }
        } else if (client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.PRIVATE_KEY)) {
            if (Strings.isNullOrEmpty((String)client.getJwksUri())) {
                logger.error("tried to create client with private key auth but no private key");
                m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
                m.addAttribute("errorMessage", (Object)"Can not create a client with private key authentication without registering a key via the JWS Set URI.");
                return "jsonErrorView";
            }
            client.setClientSecret(null);
        } else if (client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.NONE)) {
            client.setClientSecret(null);
        } else {
            logger.error("unknown auth method");
            m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
            m.addAttribute("errorMessage", (Object)"Unknown auth method requested");
            return "jsonErrorView";
        }
        if ((client.getContacts() == null || client.getContacts().isEmpty()) && (user = this.userInfoService.getByUsername(auth.getName())) != null && user.getEmail() != null) {
            client.setContacts((Set)Sets.newHashSet((Object[])new String[]{user.getEmail()}));
        }
        client.setDynamicallyRegistered(false);
        ClientDetailsEntity newClient = this.clientService.saveNewClient(client);
        m.addAttribute("entity", (Object)newClient);
        if (this.isAdmin(auth)) {
            return "clientEntityViewAdmins";
        }
        return "clientEntityViewUsers";
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT}, consumes={"application/json"}, produces={"application/json"})
    public String apiUpdateClient(@PathVariable(value="id") Long id, @RequestBody String jsonString, Model m, Authentication auth) {
        UserInfo user;
        JsonObject json = null;
        ClientDetailsEntity client = null;
        try {
            json = this.parser.parse(jsonString).getAsJsonObject();
            client = (ClientDetailsEntity)this.gson.fromJson((JsonElement)json, ClientDetailsEntity.class);
        }
        catch (JsonSyntaxException e) {
            logger.error("apiUpdateClient failed due to JsonSyntaxException", (Throwable)e);
            m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
            m.addAttribute("errorMessage", (Object)"Could not update client. The server encountered a JSON syntax exception. Contact a system administrator for assistance.");
            return "jsonErrorView";
        }
        catch (IllegalStateException e) {
            logger.error("apiUpdateClient failed due to IllegalStateException", (Throwable)e);
            m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
            m.addAttribute("errorMessage", (Object)"Could not update client. The server encountered an IllegalStateException. Refresh and try again - if the problem persists, contact a system administrator for assistance.");
            return "jsonErrorView";
        }
        ClientDetailsEntity oldClient = this.clientService.getClientById(id);
        if (oldClient == null) {
            logger.error("apiUpdateClient failed; client with id " + id + " could not be found.");
            m.addAttribute("code", (Object)HttpStatus.NOT_FOUND);
            m.addAttribute("errorMessage", (Object)("Could not update client. The requested client with id " + id + "could not be found."));
            return "jsonErrorView";
        }
        if (Strings.isNullOrEmpty((String)client.getClientId())) {
            client = this.clientService.generateClientId(client);
        }
        if (client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.SECRET_BASIC) || client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.SECRET_POST) || client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.SECRET_JWT)) {
            if (json.has("generateClientSecret") && json.get("generateClientSecret").getAsBoolean() || Strings.isNullOrEmpty((String)client.getClientSecret())) {
                client = this.clientService.generateClientSecret(client);
            }
        } else if (client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.PRIVATE_KEY)) {
            if (Strings.isNullOrEmpty((String)client.getJwksUri())) {
                logger.error("tried to create client with private key auth but no private key");
                m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
                m.addAttribute("errorMessage", (Object)"Can not create a client with private key authentication without registering a key via the JWS Set URI.");
                return "jsonErrorView";
            }
            client.setClientSecret(null);
        } else if (client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.NONE)) {
            client.setClientSecret(null);
        } else {
            logger.error("unknown auth method");
            m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
            m.addAttribute("errorMessage", (Object)"Unknown auth method requested");
            return "jsonErrorView";
        }
        if ((client.getContacts() == null || client.getContacts().isEmpty()) && (user = this.userInfoService.getByUsername(auth.getName())) != null && user.getEmail() != null) {
            client.setContacts((Set)Sets.newHashSet((Object[])new String[]{user.getEmail()}));
        }
        ClientDetailsEntity newClient = this.clientService.updateClient(oldClient, client);
        m.addAttribute("entity", (Object)newClient);
        if (this.isAdmin(auth)) {
            return "clientEntityViewAdmins";
        }
        return "clientEntityViewUsers";
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public String apiDeleteClient(@PathVariable(value="id") Long id, ModelAndView modelAndView) {
        ClientDetailsEntity client = this.clientService.getClientById(id);
        if (client == null) {
            logger.error("apiDeleteClient failed; client with id " + id + " could not be found.");
            modelAndView.getModelMap().put((Object)"code", (Object)HttpStatus.NOT_FOUND);
            modelAndView.getModelMap().put((Object)"errorMessage", (Object)("Could not delete client. The requested client with id " + id + "could not be found."));
            return "jsonErrorView";
        }
        modelAndView.getModelMap().put((Object)"code", (Object)HttpStatus.OK);
        this.clientService.deleteClient(client);
        return "httpCodeView";
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    public String apiShowClient(@PathVariable(value="id") Long id, Model model, Authentication auth) {
        ClientDetailsEntity client = this.clientService.getClientById(id);
        if (client == null) {
            logger.error("apiShowClient failed; client with id " + id + " could not be found.");
            model.addAttribute("code", (Object)HttpStatus.NOT_FOUND);
            model.addAttribute("errorMessage", (Object)("The requested client with id " + id + " could not be found."));
            return "jsonErrorView";
        }
        model.addAttribute("entity", (Object)client);
        if (this.isAdmin(auth)) {
            return "clientEntityViewAdmins";
        }
        return "clientEntityViewUsers";
    }

    private boolean isAdmin(Authentication auth) {
        for (GrantedAuthority grantedAuthority : auth.getAuthorities()) {
            if (!grantedAuthority.getAuthority().equals("ROLE_ADMIN")) continue;
            return true;
        }
        return false;
    }
}

