/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.repository.impl;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.mitre.oauth2.model.AuthorizationCodeEntity;
import org.mitre.oauth2.repository.AuthorizationCodeRepository;
import org.mitre.util.jpa.JpaUtil;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class JpaAuthorizationCodeRepository
implements AuthorizationCodeRepository {
    @PersistenceContext
    EntityManager manager;

    @Transactional
    public AuthorizationCodeEntity save(AuthorizationCodeEntity authorizationCode) {
        return (AuthorizationCodeEntity)JpaUtil.saveOrUpdate((Object)authorizationCode.getId(), (EntityManager)this.manager, (Object)authorizationCode);
    }

    @Transactional
    public AuthorizationCodeEntity getByCode(String code) {
        TypedQuery query = this.manager.createNamedQuery("AuthorizationCodeEntity.getByValue", AuthorizationCodeEntity.class);
        query.setParameter("code", (Object)code);
        AuthorizationCodeEntity result = (AuthorizationCodeEntity)JpaUtil.getSingleResult((List)query.getResultList());
        return result;
    }

    public void remove(AuthorizationCodeEntity authorizationCodeEntity) {
        AuthorizationCodeEntity found = (AuthorizationCodeEntity)this.manager.find(AuthorizationCodeEntity.class, (Object)authorizationCodeEntity.getId());
        if (found != null) {
            this.manager.remove((Object)found);
        }
    }

    public Collection<AuthorizationCodeEntity> getExpiredCodes() {
        TypedQuery query = this.manager.createNamedQuery("AuthorizationCodeEntity.expirationByDate", AuthorizationCodeEntity.class);
        query.setParameter("date", (Object)new Date());
        return query.getResultList();
    }
}

