/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.service.impl;

import com.google.common.base.Strings;
import org.mitre.openid.connect.service.BlacklistedSiteService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.common.exceptions.InvalidRequestException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.endpoint.DefaultRedirectResolver;
import org.springframework.stereotype.Component;

@Component(value="blacklistAwareRedirectResolver")
public class BlacklistAwareRedirectResolver
extends DefaultRedirectResolver {
    @Autowired
    private BlacklistedSiteService blacklistService;
    private boolean strictMatch = false;

    public String resolveRedirect(String requestedRedirect, ClientDetails client) throws OAuth2Exception {
        String redirect = super.resolveRedirect(requestedRedirect, client);
        if (this.blacklistService.isBlacklisted(redirect)) {
            throw new InvalidRequestException("The supplied redirect_uri is not allowed on this server.");
        }
        return redirect;
    }

    protected boolean redirectMatches(String requestedRedirect, String redirectUri) {
        if (this.isStrictMatch()) {
            return Strings.nullToEmpty((String)requestedRedirect).equals(redirectUri);
        }
        return super.redirectMatches(requestedRedirect, redirectUri);
    }

    public boolean isStrictMatch() {
        return this.strictMatch;
    }

    public void setStrictMatch(boolean strictMatch) {
        this.strictMatch = strictMatch;
    }
}

