/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.service.impl;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.mitre.oauth2.model.SystemScope;
import org.mitre.oauth2.repository.SystemScopeRepository;
import org.mitre.oauth2.service.SystemScopeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="defaultSystemScopeService")
public class DefaultSystemScopeService
implements SystemScopeService {
    @Autowired
    private SystemScopeRepository repository;
    private Predicate<SystemScope> isDefault = new Predicate<SystemScope>(){

        public boolean apply(SystemScope input) {
            return input != null && input.isDefaultScope();
        }
    };
    private Predicate<SystemScope> isRestricted = new Predicate<SystemScope>(){

        public boolean apply(SystemScope input) {
            return input != null && input.isRestricted();
        }
    };
    private Predicate<SystemScope> isReserved = new Predicate<SystemScope>(){

        public boolean apply(SystemScope input) {
            return input != null && DefaultSystemScopeService.this.getReserved().contains(input);
        }
    };
    private Function<String, SystemScope> stringToSystemScope = new Function<String, SystemScope>(){

        public SystemScope apply(String input) {
            if (Strings.isNullOrEmpty((String)input)) {
                return null;
            }
            List parts = DefaultSystemScopeService.this.parseStructuredScopeValue(input);
            String base = (String)parts.get(0);
            SystemScope s = DefaultSystemScopeService.this.getByValue(base);
            if (s == null) {
                s = new SystemScope(base);
                if (parts.size() > 1) {
                    s.setStructured(true);
                }
            }
            if (s.isStructured() && parts.size() > 1) {
                s.setStructuredValue((String)parts.get(1));
            }
            return s;
        }
    };
    private Function<SystemScope, String> systemScopeToString = new Function<SystemScope, String>(){

        public String apply(SystemScope input) {
            if (input == null) {
                return null;
            }
            if (input.isStructured() && !Strings.isNullOrEmpty((String)input.getStructuredValue())) {
                return Joiner.on((String)":").join((Object)input.getValue(), (Object)input.getStructuredValue(), new Object[0]);
            }
            return input.getValue();
        }
    };

    public Set<SystemScope> getAll() {
        return this.repository.getAll();
    }

    public SystemScope getById(Long id) {
        return this.repository.getById(id);
    }

    public SystemScope getByValue(String value) {
        return this.repository.getByValue(value);
    }

    public void remove(SystemScope scope) {
        this.repository.remove(scope);
    }

    public SystemScope save(SystemScope scope) {
        if (!this.isReserved.apply((Object)scope)) {
            return this.repository.save(scope);
        }
        return null;
    }

    public Set<SystemScope> fromStrings(Set<String> scope) {
        if (scope == null) {
            return null;
        }
        return new LinkedHashSet<SystemScope>(Collections2.filter((Collection)Collections2.transform(scope, this.stringToSystemScope), (Predicate)Predicates.notNull()));
    }

    public Set<String> toStrings(Set<SystemScope> scope) {
        if (scope == null) {
            return null;
        }
        return new LinkedHashSet<String>(Collections2.filter((Collection)Collections2.transform(scope, this.systemScopeToString), (Predicate)Predicates.notNull()));
    }

    private List<String> parseStructuredScopeValue(String value) {
        return Lists.newArrayList((Iterable)Splitter.on((String)":").split((CharSequence)value));
    }

    public boolean scopesMatch(Set<String> expected, Set<String> actual) {
        Set<SystemScope> ex = this.fromStrings(expected);
        Set<SystemScope> act = this.fromStrings(actual);
        for (SystemScope actScope : act) {
            if (ex.contains(actScope)) continue;
            if (actScope.isStructured() && !Strings.isNullOrEmpty((String)actScope.getStructuredValue())) {
                SystemScope base = this.getByValue(actScope.getValue());
                if (ex.contains(base)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public Set<SystemScope> getDefaults() {
        return Sets.filter(this.getAll(), this.isDefault);
    }

    public Set<SystemScope> getReserved() {
        return reservedScopes;
    }

    public Set<SystemScope> getRestricted() {
        return Sets.filter(this.getAll(), this.isRestricted);
    }

    public Set<SystemScope> getUnrestricted() {
        return Sets.filter(this.getAll(), (Predicate)Predicates.not(this.isRestricted));
    }

    public Set<SystemScope> removeRestrictedAndReservedScopes(Set<SystemScope> scopes) {
        return Sets.filter(scopes, (Predicate)Predicates.not((Predicate)Predicates.or(this.isRestricted, this.isReserved)));
    }

    public Set<SystemScope> removeReservedScopes(Set<SystemScope> scopes) {
        return Sets.filter(scopes, (Predicate)Predicates.not(this.isReserved));
    }
}

