/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.config;

import com.google.common.base.Splitter;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.core.io.Resource;

public class JsonMessageSource
extends AbstractMessageSource {
    private static final Logger logger = LoggerFactory.getLogger(JsonMessageSource.class);
    private Resource baseDirectory;
    private Locale fallbackLocale = new Locale("en");
    private Map<Locale, JsonObject> languageMaps = new HashMap<Locale, JsonObject>();

    protected MessageFormat resolveCode(String code, Locale locale) {
        JsonObject lang = this.getLanguageMap(locale);
        String value = this.getValue(code, lang);
        if (value == null) {
            lang = this.getLanguageMap(this.fallbackLocale);
            value = this.getValue(code, lang);
        }
        if (value == null) {
            value = code;
        }
        MessageFormat mf = new MessageFormat(value, locale);
        return mf;
    }

    private String getValue(String code, JsonObject lang) {
        if (lang == null) {
            return null;
        }
        JsonObject e = lang;
        Iterable parts = Splitter.on((char)'.').split((CharSequence)code);
        Iterator it = parts.iterator();
        String value = null;
        while (it.hasNext()) {
            JsonObject o;
            String p = (String)it.next();
            if (!e.isJsonObject() || !(o = e.getAsJsonObject()).has(p)) break;
            e = o.get(p);
            if (it.hasNext() || !e.isJsonPrimitive()) continue;
            value = e.getAsString();
        }
        return value;
    }

    private JsonObject getLanguageMap(Locale locale) {
        if (!this.languageMaps.containsKey(locale)) {
            try {
                String filename = locale.getLanguage() + File.separator + "messages.json";
                Resource r = this.getBaseDirectory().createRelative(filename);
                logger.info("No locale loaded, trying to load from " + r);
                JsonParser parser = new JsonParser();
                JsonObject obj = (JsonObject)parser.parse((Reader)new InputStreamReader(r.getInputStream(), "UTF-8"));
                this.languageMaps.put(locale, obj);
            }
            catch (JsonIOException | JsonSyntaxException | IOException e) {
                logger.error("Unable to load locale", e);
            }
        }
        return this.languageMaps.get(locale);
    }

    public Resource getBaseDirectory() {
        return this.baseDirectory;
    }

    public void setBaseDirectory(Resource baseDirectory) {
        this.baseDirectory = baseDirectory;
    }
}

