/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.filter;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public class MultiUrlRequestMatcher
implements RequestMatcher {
    private final Set<String> filterProcessesUrls;

    public MultiUrlRequestMatcher(Set<String> filterProcessesUrls) {
        for (String filterProcessesUrl : filterProcessesUrls) {
            Assert.hasLength((String)filterProcessesUrl, (String)"filterProcessesUrl must be specified");
            Assert.isTrue((boolean)UrlUtils.isValidRedirectUrl((String)filterProcessesUrl), (String)(filterProcessesUrl + " isn't a valid redirect URL"));
        }
        this.filterProcessesUrls = ImmutableSet.copyOf(filterProcessesUrls);
    }

    public boolean matches(HttpServletRequest request) {
        String uri = request.getRequestURI();
        int pathParamIndex = uri.indexOf(59);
        if (pathParamIndex > 0) {
            uri = uri.substring(0, pathParamIndex);
        }
        if ("".equals(request.getContextPath())) {
            for (String filterProcessesUrl : this.filterProcessesUrls) {
                if (!uri.endsWith(filterProcessesUrl)) continue;
                return true;
            }
            return false;
        }
        for (String filterProcessesUrl : this.filterProcessesUrls) {
            if (!uri.endsWith(request.getContextPath() + filterProcessesUrl)) continue;
            return true;
        }
        return false;
    }
}

