/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.repository.impl;

import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.mitre.openid.connect.model.ApprovedSite;
import org.mitre.openid.connect.repository.ApprovedSiteRepository;
import org.mitre.util.jpa.JpaUtil;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JpaApprovedSiteRepository
implements ApprovedSiteRepository {
    @PersistenceContext
    private EntityManager manager;

    @Transactional
    public Collection<ApprovedSite> getAll() {
        TypedQuery query = this.manager.createNamedQuery("ApprovedSite.getAll", ApprovedSite.class);
        return query.getResultList();
    }

    @Transactional
    public ApprovedSite getById(Long id) {
        return (ApprovedSite)this.manager.find(ApprovedSite.class, (Object)id);
    }

    @Transactional
    public void remove(ApprovedSite approvedSite) {
        ApprovedSite found = (ApprovedSite)this.manager.find(ApprovedSite.class, (Object)approvedSite.getId());
        if (found == null) {
            throw new IllegalArgumentException();
        }
        this.manager.remove((Object)found);
    }

    @Transactional
    public ApprovedSite save(ApprovedSite approvedSite) {
        return (ApprovedSite)JpaUtil.saveOrUpdate((Object)approvedSite.getId(), (EntityManager)this.manager, (Object)approvedSite);
    }

    public Collection<ApprovedSite> getByClientIdAndUserId(String clientId, String userId) {
        TypedQuery query = this.manager.createNamedQuery("ApprovedSite.getByClientIdAndUserId", ApprovedSite.class);
        query.setParameter("userId", (Object)userId);
        query.setParameter("clientId", (Object)clientId);
        return query.getResultList();
    }

    @Transactional
    public Collection<ApprovedSite> getByUserId(String userId) {
        TypedQuery query = this.manager.createNamedQuery("ApprovedSite.getByUserId", ApprovedSite.class);
        query.setParameter("userId", (Object)userId);
        return query.getResultList();
    }

    @Transactional
    public Collection<ApprovedSite> getByClientId(String clientId) {
        TypedQuery query = this.manager.createNamedQuery("ApprovedSite.getByClientId", ApprovedSite.class);
        query.setParameter("clientId", (Object)clientId);
        return query.getResultList();
    }
}

