/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.service.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.repository.OAuth2TokenRepository;
import org.mitre.openid.connect.model.ApprovedSite;
import org.mitre.openid.connect.repository.ApprovedSiteRepository;
import org.mitre.openid.connect.service.ApprovedSiteService;
import org.mitre.openid.connect.service.StatsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultApprovedSiteService")
public class DefaultApprovedSiteService
implements ApprovedSiteService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultApprovedSiteService.class);
    @Autowired
    private ApprovedSiteRepository approvedSiteRepository;
    @Autowired
    private OAuth2TokenRepository tokenRepository;
    @Autowired
    private StatsService statsService;
    private Predicate<ApprovedSite> isExpired = new Predicate<ApprovedSite>(){

        public boolean apply(ApprovedSite input) {
            return input != null && input.isExpired();
        }
    };

    public Collection<ApprovedSite> getAll() {
        return this.approvedSiteRepository.getAll();
    }

    @Transactional
    public ApprovedSite save(ApprovedSite approvedSite) {
        ApprovedSite a = this.approvedSiteRepository.save(approvedSite);
        this.statsService.resetCache();
        return a;
    }

    public ApprovedSite getById(Long id) {
        return this.approvedSiteRepository.getById(id);
    }

    @Transactional
    public void remove(ApprovedSite approvedSite) {
        Set accessTokens = approvedSite.getApprovedAccessTokens();
        for (OAuth2AccessTokenEntity token : accessTokens) {
            if (token.getRefreshToken() != null) {
                this.tokenRepository.removeRefreshToken(token.getRefreshToken());
            }
            this.tokenRepository.removeAccessToken(token);
        }
        this.approvedSiteRepository.remove(approvedSite);
        this.statsService.resetCache();
    }

    @Transactional
    public ApprovedSite createApprovedSite(String clientId, String userId, Date timeoutDate, Set<String> allowedScopes) {
        ApprovedSite as = this.approvedSiteRepository.save(new ApprovedSite());
        Date now = new Date();
        as.setCreationDate(now);
        as.setAccessDate(now);
        as.setClientId(clientId);
        as.setUserId(userId);
        as.setTimeoutDate(timeoutDate);
        as.setAllowedScopes(allowedScopes);
        return this.save(as);
    }

    public Collection<ApprovedSite> getByClientIdAndUserId(String clientId, String userId) {
        return this.approvedSiteRepository.getByClientIdAndUserId(clientId, userId);
    }

    public Collection<ApprovedSite> getByUserId(String userId) {
        return this.approvedSiteRepository.getByUserId(userId);
    }

    public Collection<ApprovedSite> getByClientId(String clientId) {
        return this.approvedSiteRepository.getByClientId(clientId);
    }

    public void clearApprovedSitesForClient(ClientDetails client) {
        Collection approvedSites = this.approvedSiteRepository.getByClientId(client.getClientId());
        if (approvedSites != null) {
            for (ApprovedSite approvedSite : approvedSites) {
                this.remove(approvedSite);
            }
        }
    }

    public void clearExpiredSites() {
        logger.info("Clearing expired approved sites");
        Collection<ApprovedSite> expiredSites = this.getExpired();
        logger.info("Found " + expiredSites.size() + " expired approved sites.");
        if (expiredSites != null) {
            for (ApprovedSite expired : expiredSites) {
                this.remove(expired);
            }
        }
    }

    private Collection<ApprovedSite> getExpired() {
        return Collections2.filter((Collection)this.approvedSiteRepository.getAll(), this.isExpired);
    }
}

