/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.web;

import java.security.Principal;
import java.util.Collection;
import org.mitre.oauth2.service.OAuth2TokenEntityService;
import org.mitre.openid.connect.model.ApprovedSite;
import org.mitre.openid.connect.service.ApprovedSiteService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/api/approved"})
@PreAuthorize(value="hasRole('ROLE_USER')")
public class ApprovedSiteAPI {
    public static final String URL = "api/approved";
    @Autowired
    private ApprovedSiteService approvedSiteService;
    @Autowired
    private OAuth2TokenEntityService tokenServices;
    private static final Logger logger = LoggerFactory.getLogger(ApprovedSiteAPI.class);

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    public String getAllApprovedSites(ModelMap m, Principal p) {
        Collection all = this.approvedSiteService.getByUserId(p.getName());
        m.put((Object)"entity", (Object)all);
        return "jsonApprovedSiteView";
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public String deleteApprovedSite(@PathVariable(value="id") Long id, ModelMap m, Principal p) {
        ApprovedSite approvedSite = this.approvedSiteService.getById(id);
        if (approvedSite == null) {
            logger.error("deleteApprovedSite failed; no approved site found for id: " + id);
            m.put((Object)"code", (Object)HttpStatus.NOT_FOUND);
            m.put((Object)"errorMessage", (Object)("Could not delete approved site. The requested approved site with id: " + id + " could not be found."));
            return "jsonErrorView";
        }
        if (!approvedSite.getUserId().equals(p.getName())) {
            logger.error("deleteApprovedSite failed; principal " + p.getName() + " does not own approved site" + id);
            m.put((Object)"code", (Object)HttpStatus.FORBIDDEN);
            m.put((Object)"errorMessage", (Object)"You do not have permission to delete this approved site. The approved site decision will not be deleted.");
            return "jsonErrorView";
        }
        m.put((Object)"code", (Object)HttpStatus.OK);
        this.approvedSiteService.remove(approvedSite);
        return "httpCodeView";
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getApprovedSite(@PathVariable(value="id") Long id, ModelMap m, Principal p) {
        ApprovedSite approvedSite = this.approvedSiteService.getById(id);
        if (approvedSite == null) {
            logger.error("getApprovedSite failed; no approved site found for id: " + id);
            m.put((Object)"code", (Object)HttpStatus.NOT_FOUND);
            m.put((Object)"errorMessage", (Object)("The requested approved site with id: " + id + " could not be found."));
            return "jsonErrorView";
        }
        if (!approvedSite.getUserId().equals(p.getName())) {
            logger.error("getApprovedSite failed; principal " + p.getName() + " does not own approved site" + id);
            m.put((Object)"code", (Object)HttpStatus.FORBIDDEN);
            m.put((Object)"errorMessage", (Object)"You do not have permission to view this approved site.");
            return "jsonErrorView";
        }
        m.put((Object)"entity", (Object)approvedSite);
        return "jsonApprovedSiteView";
    }
}

