/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.service.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.model.OAuth2RefreshTokenEntity;
import org.mitre.oauth2.service.IntrospectionResultAssembler;
import org.mitre.openid.connect.model.UserInfo;
import org.mitre.uma.model.Permission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.stereotype.Service;

@Service
public class DefaultIntrospectionResultAssembler
implements IntrospectionResultAssembler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultIntrospectionResultAssembler.class);

    public Map<String, Object> assembleFrom(OAuth2AccessTokenEntity accessToken, UserInfo userInfo, Set<String> authScopes) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        OAuth2Authentication authentication = accessToken.getAuthenticationHolder().getAuthentication();
        result.put("active", true);
        if (accessToken.getPermissions() != null && !accessToken.getPermissions().isEmpty()) {
            HashSet permissions = Sets.newHashSet();
            for (Permission perm : accessToken.getPermissions()) {
                LinkedHashMap o = Maps.newLinkedHashMap();
                o.put("resource_set_id", perm.getResourceSet().getId().toString());
                HashSet scopes = Sets.newHashSet((Iterable)perm.getScopes());
                o.put("scopes", scopes);
                permissions.add(o);
            }
            result.put("permissions", permissions);
        } else {
            Sets.SetView scopes = Sets.intersection(authScopes, (Set)accessToken.getScope());
            result.put("scope", Joiner.on((String)" ").join((Iterable)scopes));
        }
        if (accessToken.getExpiration() != null) {
            try {
                result.put("expires_at", dateFormat.valueToString(accessToken.getExpiration()));
                result.put("exp", accessToken.getExpiration().getTime() / 1000L);
            }
            catch (ParseException e) {
                logger.error("Parse exception in token introspection", (Throwable)e);
            }
        }
        if (userInfo != null) {
            result.put("sub", userInfo.getSub());
        } else {
            result.put("sub", authentication.getName());
        }
        result.put("user_id", authentication.getName());
        result.put("client_id", authentication.getOAuth2Request().getClientId());
        result.put("token_type", accessToken.getTokenType());
        return result;
    }

    public Map<String, Object> assembleFrom(OAuth2RefreshTokenEntity refreshToken, UserInfo userInfo, Set<String> authScopes) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        OAuth2Authentication authentication = refreshToken.getAuthenticationHolder().getAuthentication();
        result.put("active", true);
        Sets.SetView scopes = Sets.intersection(authScopes, (Set)authentication.getOAuth2Request().getScope());
        result.put("scope", Joiner.on((String)" ").join((Iterable)scopes));
        if (refreshToken.getExpiration() != null) {
            try {
                result.put("expires_at", dateFormat.valueToString(refreshToken.getExpiration()));
                result.put("exp", refreshToken.getExpiration().getTime() / 1000L);
            }
            catch (ParseException e) {
                logger.error("Parse exception in token introspection", (Throwable)e);
            }
        }
        if (userInfo != null) {
            result.put("sub", userInfo.getSub());
        } else {
            result.put("sub", authentication.getName());
        }
        result.put("user_id", authentication.getName());
        result.put("client_id", authentication.getOAuth2Request().getClientId());
        return result;
    }
}

