/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.service.impl;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jwt.JWTParser;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mitre.oauth2.model.AuthenticationHolderEntity;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.model.OAuth2RefreshTokenEntity;
import org.mitre.oauth2.model.SavedUserAuthentication;
import org.mitre.oauth2.model.SystemScope;
import org.mitre.oauth2.repository.AuthenticationHolderRepository;
import org.mitre.oauth2.repository.OAuth2ClientRepository;
import org.mitre.oauth2.repository.OAuth2TokenRepository;
import org.mitre.oauth2.repository.SystemScopeRepository;
import org.mitre.openid.connect.model.ApprovedSite;
import org.mitre.openid.connect.model.BlacklistedSite;
import org.mitre.openid.connect.model.WhitelistedSite;
import org.mitre.openid.connect.repository.ApprovedSiteRepository;
import org.mitre.openid.connect.repository.BlacklistedSiteRepository;
import org.mitre.openid.connect.repository.WhitelistedSiteRepository;
import org.mitre.openid.connect.service.MITREidDataService;
import org.mitre.openid.connect.service.impl.MITREidDataServiceSupport;
import org.mitre.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Service;

@Service
public class MITREidDataService_1_2
extends MITREidDataServiceSupport
implements MITREidDataService {
    private static final String DEFAULT_SCOPE = "defaultScope";
    private static final String STRUCTURED_PARAMETER = "structuredParameter";
    private static final String STRUCTURED = "structured";
    private static final String RESTRICTED = "restricted";
    private static final String ICON = "icon";
    private static final String DYNAMICALLY_REGISTERED = "dynamicallyRegistered";
    private static final String CLEAR_ACCESS_TOKENS_ON_REFRESH = "clearAccessTokensOnRefresh";
    private static final String REUSE_REFRESH_TOKEN = "reuseRefreshToken";
    private static final String ALLOW_INTROSPECTION = "allowIntrospection";
    private static final String DESCRIPTION = "description";
    private static final String REQUEST_URIS = "requestUris";
    private static final String POST_LOGOUT_REDIRECT_URI = "postLogoutRedirectUri";
    private static final String INTITATE_LOGIN_URI = "intitateLoginUri";
    private static final String DEFAULT_ACR_VALUES = "defaultACRValues";
    private static final String REQUIRE_AUTH_TIME = "requireAuthTime";
    private static final String DEFAULT_MAX_AGE = "defaultMaxAge";
    private static final String TOKEN_ENDPOINT_AUTH_SIGNING_ALG = "tokenEndpointAuthSigningAlg";
    private static final String USER_INFO_ENCRYPTED_RESPONSE_ENC = "userInfoEncryptedResponseEnc";
    private static final String USER_INFO_ENCRYPTED_RESPONSE_ALG = "userInfoEncryptedResponseAlg";
    private static final String USER_INFO_SIGNED_RESPONSE_ALG = "userInfoSignedResponseAlg";
    private static final String ID_TOKEN_ENCRYPTED_RESPONSE_ENC = "idTokenEncryptedResponseEnc";
    private static final String ID_TOKEN_ENCRYPTED_RESPONSE_ALG = "idTokenEncryptedResponseAlg";
    private static final String ID_TOKEN_SIGNED_RESPONSE_ALG = "idTokenSignedResponseAlg";
    private static final String REQUEST_OBJECT_SIGNING_ALG = "requestObjectSigningAlg";
    private static final String SUBJECT_TYPE = "subjectType";
    private static final String SECTOR_IDENTIFIER_URI = "sectorIdentifierUri";
    private static final String APPLICATION_TYPE = "applicationType";
    private static final String JWKS = "jwks";
    private static final String JWKS_URI = "jwksUri";
    private static final String POLICY_URI = "policyUri";
    private static final String GRANT_TYPES = "grantTypes";
    private static final String TOKEN_ENDPOINT_AUTH_METHOD = "tokenEndpointAuthMethod";
    private static final String TOS_URI = "tosUri";
    private static final String CONTACTS = "contacts";
    private static final String LOGO_URI = "logoUri";
    private static final String REDIRECT_URIS = "redirectUris";
    private static final String REFRESH_TOKEN_VALIDITY_SECONDS = "refreshTokenValiditySeconds";
    private static final String ACCESS_TOKEN_VALIDITY_SECONDS = "accessTokenValiditySeconds";
    private static final String SECRET = "secret";
    private static final String URI = "uri";
    private static final String CREATOR_USER_ID = "creatorUserId";
    private static final String APPROVED_ACCESS_TOKENS = "approvedAccessTokens";
    private static final String ALLOWED_SCOPES = "allowedScopes";
    private static final String USER_ID = "userId";
    private static final String TIMEOUT_DATE = "timeoutDate";
    private static final String CREATION_DATE = "creationDate";
    private static final String ACCESS_DATE = "accessDate";
    private static final String AUTHENTICATED = "authenticated";
    private static final String SOURCE_CLASS = "sourceClass";
    private static final String NAME = "name";
    private static final String SAVED_USER_AUTHENTICATION = "savedUserAuthentication";
    private static final String EXTENSIONS = "extensions";
    private static final String RESPONSE_TYPES = "responseTypes";
    private static final String REDIRECT_URI = "redirectUri";
    private static final String APPROVED = "approved";
    private static final String AUTHORITIES = "authorities";
    private static final String RESOURCE_IDS = "resourceIds";
    private static final String REQUEST_PARAMETERS = "requestParameters";
    private static final String TYPE = "type";
    private static final String SCOPE = "scope";
    private static final String ID_TOKEN_ID = "idTokenId";
    private static final String REFRESH_TOKEN_ID = "refreshTokenId";
    private static final String VALUE = "value";
    private static final String AUTHENTICATION_HOLDER_ID = "authenticationHolderId";
    private static final String CLIENT_ID = "clientId";
    private static final String EXPIRATION = "expiration";
    private static final String CLAIMS_REDIRECT_URIS = "claimsRedirectUris";
    private static final String ID = "id";
    private static final Logger logger = LoggerFactory.getLogger(MITREidDataService_1_2.class);
    @Autowired
    private OAuth2ClientRepository clientRepository;
    @Autowired
    private ApprovedSiteRepository approvedSiteRepository;
    @Autowired
    private WhitelistedSiteRepository wlSiteRepository;
    @Autowired
    private BlacklistedSiteRepository blSiteRepository;
    @Autowired
    private AuthenticationHolderRepository authHolderRepository;
    @Autowired
    private OAuth2TokenRepository tokenRepository;
    @Autowired
    private SystemScopeRepository sysScopeRepository;
    private Map<Long, String> refreshTokenToClientRefs = new HashMap<Long, String>();
    private Map<Long, Long> refreshTokenToAuthHolderRefs = new HashMap<Long, Long>();
    private Map<Long, Long> refreshTokenOldToNewIdMap = new HashMap<Long, Long>();
    private Map<Long, String> accessTokenToClientRefs = new HashMap<Long, String>();
    private Map<Long, Long> accessTokenToAuthHolderRefs = new HashMap<Long, Long>();
    private Map<Long, Long> accessTokenToRefreshTokenRefs = new HashMap<Long, Long>();
    private Map<Long, Long> accessTokenToIdTokenRefs = new HashMap<Long, Long>();
    private Map<Long, Long> accessTokenOldToNewIdMap = new HashMap<Long, Long>();
    private Map<Long, Long> authHolderOldToNewIdMap = new HashMap<Long, Long>();
    Map<Long, Long> grantOldToNewIdMap = new HashMap<Long, Long>();
    Map<Long, Set<Long>> grantToAccessTokensRefs = new HashMap<Long, Set<Long>>();
    Map<Long, Long> whitelistedSiteOldToNewIdMap = new HashMap<Long, Long>();

    public void exportData(JsonWriter writer) throws IOException {
        writer.name("mitreid-connect-1.2");
        writer.beginObject();
        writer.name("clients");
        writer.beginArray();
        this.writeClients(writer);
        writer.endArray();
        writer.name("grants");
        writer.beginArray();
        this.writeGrants(writer);
        writer.endArray();
        writer.name("whitelistedSites");
        writer.beginArray();
        this.writeWhitelistedSites(writer);
        writer.endArray();
        writer.name("blacklistedSites");
        writer.beginArray();
        this.writeBlacklistedSites(writer);
        writer.endArray();
        writer.name("authenticationHolders");
        writer.beginArray();
        this.writeAuthenticationHolders(writer);
        writer.endArray();
        writer.name("accessTokens");
        writer.beginArray();
        this.writeAccessTokens(writer);
        writer.endArray();
        writer.name("refreshTokens");
        writer.beginArray();
        this.writeRefreshTokens(writer);
        writer.endArray();
        writer.name("systemScopes");
        writer.beginArray();
        this.writeSystemScopes(writer);
        writer.endArray();
        writer.endObject();
    }

    private void writeRefreshTokens(JsonWriter writer) throws IOException {
        for (OAuth2RefreshTokenEntity token : this.tokenRepository.getAllRefreshTokens()) {
            writer.beginObject();
            writer.name(ID).value((Number)token.getId());
            writer.name(EXPIRATION).value(this.toUTCString(token.getExpiration()));
            writer.name(CLIENT_ID).value(token.getClient() != null ? token.getClient().getClientId() : null);
            writer.name(AUTHENTICATION_HOLDER_ID).value(token.getAuthenticationHolder() != null ? token.getAuthenticationHolder().getId() : null);
            writer.name(VALUE).value(token.getValue());
            writer.endObject();
            logger.debug("Wrote refresh token {}", (Object)token.getId());
        }
        logger.info("Done writing refresh tokens");
    }

    private void writeAccessTokens(JsonWriter writer) throws IOException {
        for (OAuth2AccessTokenEntity token : this.tokenRepository.getAllAccessTokens()) {
            writer.beginObject();
            writer.name(ID).value((Number)token.getId());
            writer.name(EXPIRATION).value(this.toUTCString(token.getExpiration()));
            writer.name(CLIENT_ID).value(token.getClient() != null ? token.getClient().getClientId() : null);
            writer.name(AUTHENTICATION_HOLDER_ID).value(token.getAuthenticationHolder() != null ? token.getAuthenticationHolder().getId() : null);
            writer.name(REFRESH_TOKEN_ID).value(token.getRefreshToken() != null ? token.getRefreshToken().getId() : null);
            writer.name(ID_TOKEN_ID).value(token.getIdToken() != null ? token.getIdToken().getId() : null);
            writer.name(SCOPE);
            writer.beginArray();
            for (String s : token.getScope()) {
                writer.value(s);
            }
            writer.endArray();
            writer.name(TYPE).value(token.getTokenType());
            writer.name(VALUE).value(token.getValue());
            writer.endObject();
            logger.debug("Wrote access token {}", (Object)token.getId());
        }
        logger.info("Done writing access tokens");
    }

    private void writeAuthenticationHolders(JsonWriter writer) throws IOException {
        for (AuthenticationHolderEntity holder : this.authHolderRepository.getAll()) {
            writer.beginObject();
            writer.name(ID).value((Number)holder.getId());
            writer.name(REQUEST_PARAMETERS);
            writer.beginObject();
            for (Map.Entry entry : holder.getRequestParameters().entrySet()) {
                writer.name((String)entry.getKey()).value((String)entry.getValue());
            }
            writer.endObject();
            writer.name(CLIENT_ID).value(holder.getClientId());
            Set scope = holder.getScope();
            writer.name(SCOPE);
            writer.beginArray();
            for (String string : scope) {
                writer.value(string);
            }
            writer.endArray();
            writer.name(RESOURCE_IDS);
            writer.beginArray();
            if (holder.getResourceIds() != null) {
                for (String string : holder.getResourceIds()) {
                    writer.value(string);
                }
            }
            writer.endArray();
            writer.name(AUTHORITIES);
            writer.beginArray();
            for (GrantedAuthority grantedAuthority : holder.getAuthorities()) {
                writer.value(grantedAuthority.getAuthority());
            }
            writer.endArray();
            writer.name(APPROVED).value(holder.isApproved());
            writer.name(REDIRECT_URI).value(holder.getRedirectUri());
            writer.name(RESPONSE_TYPES);
            writer.beginArray();
            for (String string : holder.getResponseTypes()) {
                writer.value(string);
            }
            writer.endArray();
            writer.name(EXTENSIONS);
            writer.beginObject();
            for (Map.Entry entry : holder.getExtensions().entrySet()) {
                if (entry.getValue() instanceof String) {
                    writer.name((String)entry.getKey()).value((String)entry.getValue());
                    continue;
                }
                logger.warn("Skipping non-string extension: " + entry);
            }
            writer.endObject();
            writer.name(SAVED_USER_AUTHENTICATION);
            if (holder.getUserAuth() != null) {
                writer.beginObject();
                writer.name(NAME).value(holder.getUserAuth().getName());
                writer.name(SOURCE_CLASS).value(holder.getUserAuth().getSourceClass());
                writer.name(AUTHENTICATED).value(holder.getUserAuth().isAuthenticated());
                writer.name(AUTHORITIES);
                writer.beginArray();
                for (GrantedAuthority grantedAuthority : holder.getUserAuth().getAuthorities()) {
                    writer.value(grantedAuthority.getAuthority());
                }
                writer.endArray();
                writer.endObject();
            } else {
                writer.nullValue();
            }
            writer.endObject();
            logger.debug("Wrote authentication holder {}", (Object)holder.getId());
        }
        logger.info("Done writing authentication holders");
    }

    private void writeGrants(JsonWriter writer) throws IOException {
        for (ApprovedSite site : this.approvedSiteRepository.getAll()) {
            writer.beginObject();
            writer.name(ID).value((Number)site.getId());
            writer.name(ACCESS_DATE).value(this.toUTCString(site.getAccessDate()));
            writer.name(CLIENT_ID).value(site.getClientId());
            writer.name(CREATION_DATE).value(this.toUTCString(site.getCreationDate()));
            writer.name(TIMEOUT_DATE).value(this.toUTCString(site.getTimeoutDate()));
            writer.name(USER_ID).value(site.getUserId());
            writer.name(ALLOWED_SCOPES);
            JsonUtils.writeNullSafeArray((JsonWriter)writer, (Set)site.getAllowedScopes());
            Set tokens = site.getApprovedAccessTokens();
            writer.name(APPROVED_ACCESS_TOKENS);
            writer.beginArray();
            for (OAuth2AccessTokenEntity token : tokens) {
                writer.value((Number)token.getId());
            }
            writer.endArray();
            writer.endObject();
            logger.debug("Wrote grant {}", (Object)site.getId());
        }
        logger.info("Done writing grants");
    }

    private void writeWhitelistedSites(JsonWriter writer) throws IOException {
        for (WhitelistedSite wlSite : this.wlSiteRepository.getAll()) {
            writer.beginObject();
            writer.name(ID).value((Number)wlSite.getId());
            writer.name(CLIENT_ID).value(wlSite.getClientId());
            writer.name(CREATOR_USER_ID).value(wlSite.getCreatorUserId());
            writer.name(ALLOWED_SCOPES);
            JsonUtils.writeNullSafeArray((JsonWriter)writer, (Set)wlSite.getAllowedScopes());
            writer.endObject();
            logger.debug("Wrote whitelisted site {}", (Object)wlSite.getId());
        }
        logger.info("Done writing whitelisted sites");
    }

    private void writeBlacklistedSites(JsonWriter writer) throws IOException {
        for (BlacklistedSite blSite : this.blSiteRepository.getAll()) {
            writer.beginObject();
            writer.name(ID).value((Number)blSite.getId());
            writer.name(URI).value(blSite.getUri());
            writer.endObject();
            logger.debug("Wrote blacklisted site {}", (Object)blSite.getId());
        }
        logger.info("Done writing blacklisted sites");
    }

    private void writeClients(JsonWriter writer) {
        for (ClientDetailsEntity client : this.clientRepository.getAllClients()) {
            try {
                writer.beginObject();
                writer.name(CLIENT_ID).value(client.getClientId());
                writer.name(RESOURCE_IDS);
                JsonUtils.writeNullSafeArray((JsonWriter)writer, (Set)client.getResourceIds());
                writer.name(SECRET).value(client.getClientSecret());
                writer.name(SCOPE);
                JsonUtils.writeNullSafeArray((JsonWriter)writer, (Set)client.getScope());
                writer.name(AUTHORITIES);
                writer.beginArray();
                for (GrantedAuthority authority : client.getAuthorities()) {
                    writer.value(authority.getAuthority());
                }
                writer.endArray();
                writer.name(ACCESS_TOKEN_VALIDITY_SECONDS).value((Number)client.getAccessTokenValiditySeconds());
                writer.name(REFRESH_TOKEN_VALIDITY_SECONDS).value((Number)client.getRefreshTokenValiditySeconds());
                writer.name(REDIRECT_URIS);
                JsonUtils.writeNullSafeArray((JsonWriter)writer, (Set)client.getRedirectUris());
                writer.name(CLAIMS_REDIRECT_URIS);
                JsonUtils.writeNullSafeArray((JsonWriter)writer, (Set)client.getClaimsRedirectUris());
                writer.name(NAME).value(client.getClientName());
                writer.name(URI).value(client.getClientUri());
                writer.name(LOGO_URI).value(client.getLogoUri());
                writer.name(CONTACTS);
                JsonUtils.writeNullSafeArray((JsonWriter)writer, (Set)client.getContacts());
                writer.name(TOS_URI).value(client.getTosUri());
                writer.name(TOKEN_ENDPOINT_AUTH_METHOD).value(client.getTokenEndpointAuthMethod() != null ? client.getTokenEndpointAuthMethod().getValue() : null);
                writer.name(GRANT_TYPES);
                writer.beginArray();
                for (String s : client.getGrantTypes()) {
                    writer.value(s);
                }
                writer.endArray();
                writer.name(RESPONSE_TYPES);
                writer.beginArray();
                for (String s : client.getResponseTypes()) {
                    writer.value(s);
                }
                writer.endArray();
                writer.name(POLICY_URI).value(client.getPolicyUri());
                writer.name(JWKS_URI).value(client.getJwksUri());
                writer.name(JWKS).value(client.getJwks() != null ? client.getJwks().toString() : null);
                writer.name(APPLICATION_TYPE).value(client.getApplicationType() != null ? client.getApplicationType().getValue() : null);
                writer.name(SECTOR_IDENTIFIER_URI).value(client.getSectorIdentifierUri());
                writer.name(SUBJECT_TYPE).value(client.getSubjectType() != null ? client.getSubjectType().getValue() : null);
                writer.name(REQUEST_OBJECT_SIGNING_ALG).value(client.getRequestObjectSigningAlg() != null ? client.getRequestObjectSigningAlg().getName() : null);
                writer.name(ID_TOKEN_SIGNED_RESPONSE_ALG).value(client.getIdTokenSignedResponseAlg() != null ? client.getIdTokenSignedResponseAlg().getName() : null);
                writer.name(ID_TOKEN_ENCRYPTED_RESPONSE_ALG).value(client.getIdTokenEncryptedResponseAlg() != null ? client.getIdTokenEncryptedResponseAlg().getName() : null);
                writer.name(ID_TOKEN_ENCRYPTED_RESPONSE_ENC).value(client.getIdTokenEncryptedResponseEnc() != null ? client.getIdTokenEncryptedResponseEnc().getName() : null);
                writer.name(USER_INFO_SIGNED_RESPONSE_ALG).value(client.getUserInfoSignedResponseAlg() != null ? client.getUserInfoSignedResponseAlg().getName() : null);
                writer.name(USER_INFO_ENCRYPTED_RESPONSE_ALG).value(client.getUserInfoEncryptedResponseAlg() != null ? client.getUserInfoEncryptedResponseAlg().getName() : null);
                writer.name(USER_INFO_ENCRYPTED_RESPONSE_ENC).value(client.getUserInfoEncryptedResponseEnc() != null ? client.getUserInfoEncryptedResponseEnc().getName() : null);
                writer.name(TOKEN_ENDPOINT_AUTH_SIGNING_ALG).value(client.getTokenEndpointAuthSigningAlg() != null ? client.getTokenEndpointAuthSigningAlg().getName() : null);
                writer.name(DEFAULT_MAX_AGE).value((Number)client.getDefaultMaxAge());
                Boolean requireAuthTime = null;
                try {
                    requireAuthTime = client.getRequireAuthTime();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (requireAuthTime != null) {
                    writer.name(REQUIRE_AUTH_TIME).value(requireAuthTime.booleanValue());
                }
                writer.name(DEFAULT_ACR_VALUES);
                JsonUtils.writeNullSafeArray((JsonWriter)writer, (Set)client.getDefaultACRvalues());
                writer.name(INTITATE_LOGIN_URI).value(client.getInitiateLoginUri());
                writer.name(POST_LOGOUT_REDIRECT_URI);
                JsonUtils.writeNullSafeArray((JsonWriter)writer, (Set)client.getPostLogoutRedirectUris());
                writer.name(REQUEST_URIS);
                JsonUtils.writeNullSafeArray((JsonWriter)writer, (Set)client.getRequestUris());
                writer.name(DESCRIPTION).value(client.getClientDescription());
                writer.name(ALLOW_INTROSPECTION).value(client.isAllowIntrospection());
                writer.name(REUSE_REFRESH_TOKEN).value(client.isReuseRefreshToken());
                writer.name(CLEAR_ACCESS_TOKENS_ON_REFRESH).value(client.isClearAccessTokensOnRefresh());
                writer.name(DYNAMICALLY_REGISTERED).value(client.isDynamicallyRegistered());
                writer.endObject();
                logger.debug("Wrote client {}", (Object)client.getId());
            }
            catch (IOException ex) {
                logger.error("Unable to write client {}", (Object)client.getId(), (Object)ex);
            }
        }
        logger.info("Done writing clients");
    }

    private void writeSystemScopes(JsonWriter writer) {
        for (SystemScope sysScope : this.sysScopeRepository.getAll()) {
            try {
                writer.beginObject();
                writer.name(ID).value((Number)sysScope.getId());
                writer.name(DESCRIPTION).value(sysScope.getDescription());
                writer.name(ICON).value(sysScope.getIcon());
                writer.name(VALUE).value(sysScope.getValue());
                writer.name(RESTRICTED).value(sysScope.isRestricted());
                writer.name(STRUCTURED).value(sysScope.isStructured());
                writer.name(STRUCTURED_PARAMETER).value(sysScope.getStructuredParamDescription());
                writer.name(DEFAULT_SCOPE).value(sysScope.isDefaultScope());
                writer.endObject();
                logger.debug("Wrote system scope {}", (Object)sysScope.getId());
            }
            catch (IOException ex) {
                logger.error("Unable to write system scope {}", (Object)sysScope.getId(), (Object)ex);
            }
        }
        logger.info("Done writing system scopes");
    }

    public void importData(JsonReader reader) throws IOException {
        logger.info("Reading configuration for 1.2");
        reader.beginObject();
        block4: while (reader.hasNext()) {
            JsonToken tok = reader.peek();
            switch (tok) {
                case NAME: {
                    String name = reader.nextName();
                    if (name.equals("clients")) {
                        this.readClients(reader);
                        continue block4;
                    }
                    if (name.equals("grants")) {
                        this.readGrants(reader);
                        continue block4;
                    }
                    if (name.equals("whitelistedSites")) {
                        this.readWhitelistedSites(reader);
                        continue block4;
                    }
                    if (name.equals("blacklistedSites")) {
                        this.readBlacklistedSites(reader);
                        continue block4;
                    }
                    if (name.equals("authenticationHolders")) {
                        this.readAuthenticationHolders(reader);
                        continue block4;
                    }
                    if (name.equals("accessTokens")) {
                        this.readAccessTokens(reader);
                        continue block4;
                    }
                    if (name.equals("refreshTokens")) {
                        this.readRefreshTokens(reader);
                        continue block4;
                    }
                    if (name.equals("systemScopes")) {
                        this.readSystemScopes(reader);
                        continue block4;
                    }
                    reader.skipValue();
                    continue block4;
                }
                case END_OBJECT: {
                    reader.endObject();
                    continue block4;
                }
            }
            logger.debug("Found unexpected entry");
            reader.skipValue();
        }
        this.fixObjectReferences();
    }

    private void readRefreshTokens(JsonReader reader) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            OAuth2RefreshTokenEntity token = new OAuth2RefreshTokenEntity();
            reader.beginObject();
            Long currentId = null;
            String clientId = null;
            Long authHolderId = null;
            block7: while (reader.hasNext()) {
                switch (reader.peek()) {
                    case END_OBJECT: {
                        continue block7;
                    }
                    case NAME: {
                        String name = reader.nextName();
                        if (reader.peek() == JsonToken.NULL) {
                            reader.skipValue();
                            continue block7;
                        }
                        if (name.equals(ID)) {
                            currentId = reader.nextLong();
                            continue block7;
                        }
                        if (name.equals(EXPIRATION)) {
                            Date date = this.utcToDate(reader.nextString());
                            token.setExpiration(date);
                            continue block7;
                        }
                        if (name.equals(VALUE)) {
                            String value = reader.nextString();
                            try {
                                token.setJwt(JWTParser.parse((String)value));
                            }
                            catch (ParseException ex) {
                                logger.error("Unable to set refresh token value to {}", (Object)value, (Object)ex);
                            }
                            continue block7;
                        }
                        if (name.equals(CLIENT_ID)) {
                            clientId = reader.nextString();
                            continue block7;
                        }
                        if (name.equals(AUTHENTICATION_HOLDER_ID)) {
                            authHolderId = reader.nextLong();
                            continue block7;
                        }
                        logger.debug("Found unexpected entry");
                        reader.skipValue();
                        continue block7;
                    }
                }
                logger.debug("Found unexpected entry");
                reader.skipValue();
            }
            reader.endObject();
            Long newId = this.tokenRepository.saveRefreshToken(token).getId();
            this.refreshTokenToClientRefs.put(currentId, clientId);
            this.refreshTokenToAuthHolderRefs.put(currentId, authHolderId);
            this.refreshTokenOldToNewIdMap.put(currentId, newId);
            logger.debug("Read refresh token {}", (Object)currentId);
        }
        reader.endArray();
        logger.info("Done reading refresh tokens");
    }

    private void readAccessTokens(JsonReader reader) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            OAuth2AccessTokenEntity token = new OAuth2AccessTokenEntity();
            reader.beginObject();
            Long currentId = null;
            String clientId = null;
            Long authHolderId = null;
            Long refreshTokenId = null;
            Long idTokenId = null;
            block7: while (reader.hasNext()) {
                switch (reader.peek()) {
                    case END_OBJECT: {
                        continue block7;
                    }
                    case NAME: {
                        String name = reader.nextName();
                        if (reader.peek() == JsonToken.NULL) {
                            reader.skipValue();
                            continue block7;
                        }
                        if (name.equals(ID)) {
                            currentId = reader.nextLong();
                            continue block7;
                        }
                        if (name.equals(EXPIRATION)) {
                            Date date = this.utcToDate(reader.nextString());
                            token.setExpiration(date);
                            continue block7;
                        }
                        if (name.equals(VALUE)) {
                            String value = reader.nextString();
                            try {
                                token.setJwt(JWTParser.parse((String)value));
                            }
                            catch (ParseException ex) {
                                logger.error("Unable to set refresh token value to {}", (Object)value, (Object)ex);
                            }
                            continue block7;
                        }
                        if (name.equals(CLIENT_ID)) {
                            clientId = reader.nextString();
                            continue block7;
                        }
                        if (name.equals(AUTHENTICATION_HOLDER_ID)) {
                            authHolderId = reader.nextLong();
                            continue block7;
                        }
                        if (name.equals(REFRESH_TOKEN_ID)) {
                            refreshTokenId = reader.nextLong();
                            continue block7;
                        }
                        if (name.equals(ID_TOKEN_ID)) {
                            idTokenId = reader.nextLong();
                            continue block7;
                        }
                        if (name.equals(SCOPE)) {
                            Set scope = JsonUtils.readSet((JsonReader)reader);
                            token.setScope(scope);
                            continue block7;
                        }
                        if (name.equals(TYPE)) {
                            token.setTokenType(reader.nextString());
                            continue block7;
                        }
                        logger.debug("Found unexpected entry");
                        reader.skipValue();
                        continue block7;
                    }
                }
                logger.debug("Found unexpected entry");
                reader.skipValue();
            }
            reader.endObject();
            Long newId = this.tokenRepository.saveAccessToken(token).getId();
            this.accessTokenToClientRefs.put(currentId, clientId);
            this.accessTokenToAuthHolderRefs.put(currentId, authHolderId);
            if (refreshTokenId != null) {
                this.accessTokenToRefreshTokenRefs.put(currentId, refreshTokenId);
            }
            if (idTokenId != null) {
                this.accessTokenToIdTokenRefs.put(currentId, idTokenId);
            }
            this.accessTokenOldToNewIdMap.put(currentId, newId);
            logger.debug("Read access token {}", (Object)currentId);
        }
        reader.endArray();
        logger.info("Done reading access tokens");
    }

    private void readAuthenticationHolders(JsonReader reader) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            AuthenticationHolderEntity ahe = new AuthenticationHolderEntity();
            reader.beginObject();
            Long currentId = null;
            block5: while (reader.hasNext()) {
                switch (reader.peek()) {
                    case END_OBJECT: {
                        continue block5;
                    }
                    case NAME: {
                        String name = reader.nextName();
                        if (reader.peek() == JsonToken.NULL) {
                            reader.skipValue();
                            continue block5;
                        }
                        if (name.equals(ID)) {
                            currentId = reader.nextLong();
                            continue block5;
                        }
                        if (name.equals(REQUEST_PARAMETERS)) {
                            ahe.setRequestParameters(JsonUtils.readMap((JsonReader)reader));
                            continue block5;
                        }
                        if (name.equals(CLIENT_ID)) {
                            ahe.setClientId(reader.nextString());
                            continue block5;
                        }
                        if (name.equals(SCOPE)) {
                            ahe.setScope(JsonUtils.readSet((JsonReader)reader));
                            continue block5;
                        }
                        if (name.equals(RESOURCE_IDS)) {
                            ahe.setResourceIds(JsonUtils.readSet((JsonReader)reader));
                            continue block5;
                        }
                        if (name.equals(AUTHORITIES)) {
                            Set authorityStrs = JsonUtils.readSet((JsonReader)reader);
                            HashSet<SimpleGrantedAuthority> authorities = new HashSet<SimpleGrantedAuthority>();
                            for (String s : authorityStrs) {
                                SimpleGrantedAuthority ga = new SimpleGrantedAuthority(s);
                                authorities.add(ga);
                            }
                            ahe.setAuthorities(authorities);
                            continue block5;
                        }
                        if (name.equals(APPROVED)) {
                            ahe.setApproved(reader.nextBoolean());
                            continue block5;
                        }
                        if (name.equals(REDIRECT_URI)) {
                            ahe.setRedirectUri(reader.nextString());
                            continue block5;
                        }
                        if (name.equals(RESPONSE_TYPES)) {
                            ahe.setResponseTypes(JsonUtils.readSet((JsonReader)reader));
                            continue block5;
                        }
                        if (name.equals(EXTENSIONS)) {
                            ahe.setExtensions(JsonUtils.readMap((JsonReader)reader));
                            continue block5;
                        }
                        if (name.equals(SAVED_USER_AUTHENTICATION)) {
                            ahe.setUserAuth(this.readSavedUserAuthentication(reader));
                            continue block5;
                        }
                        logger.debug("Found unexpected entry");
                        reader.skipValue();
                        continue block5;
                    }
                }
                logger.debug("Found unexpected entry");
                reader.skipValue();
            }
            reader.endObject();
            Long newId = this.authHolderRepository.save(ahe).getId();
            this.authHolderOldToNewIdMap.put(currentId, newId);
            logger.debug("Read authentication holder {}", currentId);
        }
        reader.endArray();
        logger.info("Done reading authentication holders");
    }

    private SavedUserAuthentication readSavedUserAuthentication(JsonReader reader) throws IOException {
        SavedUserAuthentication savedUserAuth = new SavedUserAuthentication();
        reader.beginObject();
        block4: while (reader.hasNext()) {
            switch (reader.peek()) {
                case END_OBJECT: {
                    continue block4;
                }
                case NAME: {
                    String name = reader.nextName();
                    if (reader.peek() == JsonToken.NULL) {
                        reader.skipValue();
                        continue block4;
                    }
                    if (name.equals(NAME)) {
                        savedUserAuth.setName(reader.nextString());
                        continue block4;
                    }
                    if (name.equals(SOURCE_CLASS)) {
                        savedUserAuth.setSourceClass(reader.nextString());
                        continue block4;
                    }
                    if (name.equals(AUTHENTICATED)) {
                        savedUserAuth.setAuthenticated(reader.nextBoolean());
                        continue block4;
                    }
                    if (name.equals(AUTHORITIES)) {
                        Set authorityStrs = JsonUtils.readSet((JsonReader)reader);
                        HashSet<SimpleGrantedAuthority> authorities = new HashSet<SimpleGrantedAuthority>();
                        for (String s : authorityStrs) {
                            SimpleGrantedAuthority ga = new SimpleGrantedAuthority(s);
                            authorities.add(ga);
                        }
                        savedUserAuth.setAuthorities(authorities);
                        continue block4;
                    }
                    logger.debug("Found unexpected entry");
                    reader.skipValue();
                    continue block4;
                }
            }
            logger.debug("Found unexpected entry");
            reader.skipValue();
        }
        reader.endObject();
        return savedUserAuth;
    }

    private void readGrants(JsonReader reader) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            ApprovedSite site = new ApprovedSite();
            Long currentId = null;
            Set tokenIds = null;
            reader.beginObject();
            block5: while (reader.hasNext()) {
                switch (reader.peek()) {
                    case END_OBJECT: {
                        continue block5;
                    }
                    case NAME: {
                        Date date;
                        String name = reader.nextName();
                        if (reader.peek() == JsonToken.NULL) {
                            reader.skipValue();
                            continue block5;
                        }
                        if (name.equals(ID)) {
                            currentId = reader.nextLong();
                            continue block5;
                        }
                        if (name.equals(ACCESS_DATE)) {
                            date = this.utcToDate(reader.nextString());
                            site.setAccessDate(date);
                            continue block5;
                        }
                        if (name.equals(CLIENT_ID)) {
                            site.setClientId(reader.nextString());
                            continue block5;
                        }
                        if (name.equals(CREATION_DATE)) {
                            date = this.utcToDate(reader.nextString());
                            site.setCreationDate(date);
                            continue block5;
                        }
                        if (name.equals(TIMEOUT_DATE)) {
                            date = this.utcToDate(reader.nextString());
                            site.setTimeoutDate(date);
                            continue block5;
                        }
                        if (name.equals(USER_ID)) {
                            site.setUserId(reader.nextString());
                            continue block5;
                        }
                        if (name.equals(ALLOWED_SCOPES)) {
                            Set allowedScopes = JsonUtils.readSet((JsonReader)reader);
                            site.setAllowedScopes(allowedScopes);
                            continue block5;
                        }
                        if (name.equals(APPROVED_ACCESS_TOKENS)) {
                            tokenIds = JsonUtils.readSet((JsonReader)reader);
                            continue block5;
                        }
                        logger.debug("Found unexpected entry");
                        reader.skipValue();
                        continue block5;
                    }
                }
                logger.debug("Found unexpected entry");
                reader.skipValue();
            }
            reader.endObject();
            Long newId = this.approvedSiteRepository.save(site).getId();
            this.grantOldToNewIdMap.put(currentId, newId);
            if (tokenIds != null) {
                this.grantToAccessTokensRefs.put(currentId, tokenIds);
            }
            logger.debug("Read grant {}", currentId);
        }
        reader.endArray();
        logger.info("Done reading grants");
    }

    private void readWhitelistedSites(JsonReader reader) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            WhitelistedSite wlSite = new WhitelistedSite();
            Long currentId = null;
            reader.beginObject();
            block5: while (reader.hasNext()) {
                switch (reader.peek()) {
                    case END_OBJECT: {
                        continue block5;
                    }
                    case NAME: {
                        String name = reader.nextName();
                        if (name.equals(ID)) {
                            currentId = reader.nextLong();
                            continue block5;
                        }
                        if (name.equals(CLIENT_ID)) {
                            wlSite.setClientId(reader.nextString());
                            continue block5;
                        }
                        if (name.equals(CREATOR_USER_ID)) {
                            wlSite.setCreatorUserId(reader.nextString());
                            continue block5;
                        }
                        if (name.equals(ALLOWED_SCOPES)) {
                            Set allowedScopes = JsonUtils.readSet((JsonReader)reader);
                            wlSite.setAllowedScopes(allowedScopes);
                            continue block5;
                        }
                        logger.debug("Found unexpected entry");
                        reader.skipValue();
                        continue block5;
                    }
                }
                logger.debug("Found unexpected entry");
                reader.skipValue();
            }
            reader.endObject();
            Long newId = this.wlSiteRepository.save(wlSite).getId();
            this.whitelistedSiteOldToNewIdMap.put(currentId, newId);
        }
        reader.endArray();
        logger.info("Done reading whitelisted sites");
    }

    private void readBlacklistedSites(JsonReader reader) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            BlacklistedSite blSite = new BlacklistedSite();
            reader.beginObject();
            block5: while (reader.hasNext()) {
                switch (reader.peek()) {
                    case END_OBJECT: {
                        continue block5;
                    }
                    case NAME: {
                        String name = reader.nextName();
                        if (name.equals(ID)) {
                            reader.skipValue();
                            continue block5;
                        }
                        if (name.equals(URI)) {
                            blSite.setUri(reader.nextString());
                            continue block5;
                        }
                        logger.debug("Found unexpected entry");
                        reader.skipValue();
                        continue block5;
                    }
                }
                logger.debug("Found unexpected entry");
                reader.skipValue();
            }
            reader.endObject();
            this.blSiteRepository.save(blSite);
        }
        reader.endArray();
        logger.info("Done reading blacklisted sites");
    }

    private void readClients(JsonReader reader) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            ClientDetailsEntity client = new ClientDetailsEntity();
            reader.beginObject();
            block7: while (reader.hasNext()) {
                switch (reader.peek()) {
                    case END_OBJECT: {
                        continue block7;
                    }
                    case NAME: {
                        JWSAlgorithm alg;
                        String name = reader.nextName();
                        if (reader.peek() == JsonToken.NULL) {
                            reader.skipValue();
                            continue block7;
                        }
                        if (name.equals(CLIENT_ID)) {
                            client.setClientId(reader.nextString());
                            continue block7;
                        }
                        if (name.equals(RESOURCE_IDS)) {
                            Set resourceIds = JsonUtils.readSet((JsonReader)reader);
                            client.setResourceIds(resourceIds);
                            continue block7;
                        }
                        if (name.equals(SECRET)) {
                            client.setClientSecret(reader.nextString());
                            continue block7;
                        }
                        if (name.equals(SCOPE)) {
                            Set scope = JsonUtils.readSet((JsonReader)reader);
                            client.setScope(scope);
                            continue block7;
                        }
                        if (name.equals(AUTHORITIES)) {
                            Set authorityStrs = JsonUtils.readSet((JsonReader)reader);
                            HashSet<SimpleGrantedAuthority> authorities = new HashSet<SimpleGrantedAuthority>();
                            for (String s : authorityStrs) {
                                SimpleGrantedAuthority ga = new SimpleGrantedAuthority(s);
                                authorities.add(ga);
                            }
                            client.setAuthorities(authorities);
                            continue block7;
                        }
                        if (name.equals(ACCESS_TOKEN_VALIDITY_SECONDS)) {
                            client.setAccessTokenValiditySeconds(Integer.valueOf(reader.nextInt()));
                            continue block7;
                        }
                        if (name.equals(REFRESH_TOKEN_VALIDITY_SECONDS)) {
                            client.setRefreshTokenValiditySeconds(Integer.valueOf(reader.nextInt()));
                            continue block7;
                        }
                        if (name.equals(REDIRECT_URIS)) {
                            Set redirectUris = JsonUtils.readSet((JsonReader)reader);
                            client.setRedirectUris(redirectUris);
                            continue block7;
                        }
                        if (name.equals(CLAIMS_REDIRECT_URIS)) {
                            Set claimsRedirectUris = JsonUtils.readSet((JsonReader)reader);
                            client.setClaimsRedirectUris(claimsRedirectUris);
                            continue block7;
                        }
                        if (name.equals(NAME)) {
                            client.setClientName(reader.nextString());
                            continue block7;
                        }
                        if (name.equals(URI)) {
                            client.setClientUri(reader.nextString());
                            continue block7;
                        }
                        if (name.equals(LOGO_URI)) {
                            client.setLogoUri(reader.nextString());
                            continue block7;
                        }
                        if (name.equals(CONTACTS)) {
                            Set contacts = JsonUtils.readSet((JsonReader)reader);
                            client.setContacts(contacts);
                            continue block7;
                        }
                        if (name.equals(TOS_URI)) {
                            client.setTosUri(reader.nextString());
                            continue block7;
                        }
                        if (name.equals(TOKEN_ENDPOINT_AUTH_METHOD)) {
                            ClientDetailsEntity.AuthMethod am = ClientDetailsEntity.AuthMethod.getByValue((String)reader.nextString());
                            client.setTokenEndpointAuthMethod(am);
                            continue block7;
                        }
                        if (name.equals(GRANT_TYPES)) {
                            Set grantTypes = JsonUtils.readSet((JsonReader)reader);
                            client.setGrantTypes(grantTypes);
                            continue block7;
                        }
                        if (name.equals(RESPONSE_TYPES)) {
                            Set responseTypes = JsonUtils.readSet((JsonReader)reader);
                            client.setResponseTypes(responseTypes);
                            continue block7;
                        }
                        if (name.equals(POLICY_URI)) {
                            client.setPolicyUri(reader.nextString());
                            continue block7;
                        }
                        if (name.equals(APPLICATION_TYPE)) {
                            ClientDetailsEntity.AppType appType = ClientDetailsEntity.AppType.getByValue((String)reader.nextString());
                            client.setApplicationType(appType);
                            continue block7;
                        }
                        if (name.equals(SECTOR_IDENTIFIER_URI)) {
                            client.setSectorIdentifierUri(reader.nextString());
                            continue block7;
                        }
                        if (name.equals(SUBJECT_TYPE)) {
                            ClientDetailsEntity.SubjectType st = ClientDetailsEntity.SubjectType.getByValue((String)reader.nextString());
                            client.setSubjectType(st);
                            continue block7;
                        }
                        if (name.equals(JWKS_URI)) {
                            client.setJwksUri(reader.nextString());
                            continue block7;
                        }
                        if (name.equals(JWKS)) {
                            try {
                                client.setJwks(JWKSet.parse((String)reader.nextString()));
                            }
                            catch (ParseException e) {
                                logger.error("Couldn't parse JWK Set", (Throwable)e);
                            }
                            continue block7;
                        }
                        if (name.equals(REQUEST_OBJECT_SIGNING_ALG)) {
                            alg = JWSAlgorithm.parse((String)reader.nextString());
                            client.setRequestObjectSigningAlg(alg);
                            continue block7;
                        }
                        if (name.equals(USER_INFO_ENCRYPTED_RESPONSE_ALG)) {
                            alg = JWEAlgorithm.parse((String)reader.nextString());
                            client.setUserInfoEncryptedResponseAlg((JWEAlgorithm)alg);
                            continue block7;
                        }
                        if (name.equals(USER_INFO_ENCRYPTED_RESPONSE_ENC)) {
                            alg = EncryptionMethod.parse((String)reader.nextString());
                            client.setUserInfoEncryptedResponseEnc((EncryptionMethod)alg);
                            continue block7;
                        }
                        if (name.equals(USER_INFO_SIGNED_RESPONSE_ALG)) {
                            alg = JWSAlgorithm.parse((String)reader.nextString());
                            client.setUserInfoSignedResponseAlg(alg);
                            continue block7;
                        }
                        if (name.equals(ID_TOKEN_SIGNED_RESPONSE_ALG)) {
                            alg = JWSAlgorithm.parse((String)reader.nextString());
                            client.setIdTokenSignedResponseAlg(alg);
                            continue block7;
                        }
                        if (name.equals(ID_TOKEN_ENCRYPTED_RESPONSE_ALG)) {
                            alg = JWEAlgorithm.parse((String)reader.nextString());
                            client.setIdTokenEncryptedResponseAlg((JWEAlgorithm)alg);
                            continue block7;
                        }
                        if (name.equals(ID_TOKEN_ENCRYPTED_RESPONSE_ENC)) {
                            alg = EncryptionMethod.parse((String)reader.nextString());
                            client.setIdTokenEncryptedResponseEnc((EncryptionMethod)alg);
                            continue block7;
                        }
                        if (name.equals(TOKEN_ENDPOINT_AUTH_SIGNING_ALG)) {
                            alg = JWSAlgorithm.parse((String)reader.nextString());
                            client.setTokenEndpointAuthSigningAlg(alg);
                            continue block7;
                        }
                        if (name.equals(DEFAULT_MAX_AGE)) {
                            client.setDefaultMaxAge(Integer.valueOf(reader.nextInt()));
                            continue block7;
                        }
                        if (name.equals(REQUIRE_AUTH_TIME)) {
                            client.setRequireAuthTime(Boolean.valueOf(reader.nextBoolean()));
                            continue block7;
                        }
                        if (name.equals(DEFAULT_ACR_VALUES)) {
                            Set defaultACRvalues = JsonUtils.readSet((JsonReader)reader);
                            client.setDefaultACRvalues(defaultACRvalues);
                            continue block7;
                        }
                        if (name.equals("initiateLoginUri")) {
                            client.setInitiateLoginUri(reader.nextString());
                            continue block7;
                        }
                        if (name.equals(POST_LOGOUT_REDIRECT_URI)) {
                            Set postLogoutUris = JsonUtils.readSet((JsonReader)reader);
                            client.setPostLogoutRedirectUris(postLogoutUris);
                            continue block7;
                        }
                        if (name.equals(REQUEST_URIS)) {
                            Set requestUris = JsonUtils.readSet((JsonReader)reader);
                            client.setRequestUris(requestUris);
                            continue block7;
                        }
                        if (name.equals(DESCRIPTION)) {
                            client.setClientDescription(reader.nextString());
                            continue block7;
                        }
                        if (name.equals(ALLOW_INTROSPECTION)) {
                            client.setAllowIntrospection(reader.nextBoolean());
                            continue block7;
                        }
                        if (name.equals(REUSE_REFRESH_TOKEN)) {
                            client.setReuseRefreshToken(reader.nextBoolean());
                            continue block7;
                        }
                        if (name.equals(CLEAR_ACCESS_TOKENS_ON_REFRESH)) {
                            client.setClearAccessTokensOnRefresh(reader.nextBoolean());
                            continue block7;
                        }
                        if (name.equals(DYNAMICALLY_REGISTERED)) {
                            client.setDynamicallyRegistered(reader.nextBoolean());
                            continue block7;
                        }
                        logger.debug("Found unexpected entry");
                        reader.skipValue();
                        continue block7;
                    }
                }
                logger.debug("Found unexpected entry");
                reader.skipValue();
            }
            reader.endObject();
            this.clientRepository.saveClient(client);
        }
        reader.endArray();
        logger.info("Done reading clients");
    }

    private void readSystemScopes(JsonReader reader) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            SystemScope scope = new SystemScope();
            reader.beginObject();
            block5: while (reader.hasNext()) {
                switch (reader.peek()) {
                    case END_OBJECT: {
                        continue block5;
                    }
                    case NAME: {
                        String name = reader.nextName();
                        if (reader.peek() == JsonToken.NULL) {
                            reader.skipValue();
                            continue block5;
                        }
                        if (name.equals(VALUE)) {
                            scope.setValue(reader.nextString());
                            continue block5;
                        }
                        if (name.equals(DESCRIPTION)) {
                            scope.setDescription(reader.nextString());
                            continue block5;
                        }
                        if (name.equals(RESTRICTED)) {
                            scope.setRestricted(reader.nextBoolean());
                            continue block5;
                        }
                        if (name.equals(DEFAULT_SCOPE)) {
                            scope.setDefaultScope(reader.nextBoolean());
                            continue block5;
                        }
                        if (name.equals(ICON)) {
                            scope.setIcon(reader.nextString());
                            continue block5;
                        }
                        if (name.equals(STRUCTURED)) {
                            scope.setStructured(reader.nextBoolean());
                            continue block5;
                        }
                        if (name.equals(STRUCTURED_PARAMETER)) {
                            scope.setStructuredParamDescription(reader.nextString());
                            continue block5;
                        }
                        logger.debug("found unexpected entry");
                        reader.skipValue();
                        continue block5;
                    }
                }
                logger.debug("Found unexpected entry");
                reader.skipValue();
            }
            reader.endObject();
            this.sysScopeRepository.save(scope);
        }
        reader.endArray();
        logger.info("Done reading system scopes");
    }

    private void fixObjectReferences() {
        OAuth2AccessTokenEntity accessToken;
        Long newAccessTokenId;
        AuthenticationHolderEntity authHolder;
        Long newAuthHolderId;
        Long oldAuthHolderId;
        ClientDetailsEntity client;
        String clientRef;
        logger.info("Fixing object references...");
        for (Long oldRefreshTokenId : this.refreshTokenToClientRefs.keySet()) {
            clientRef = this.refreshTokenToClientRefs.get(oldRefreshTokenId);
            client = this.clientRepository.getClientByClientId(clientRef);
            Long newRefreshTokenId = this.refreshTokenOldToNewIdMap.get(oldRefreshTokenId);
            OAuth2RefreshTokenEntity refreshToken = this.tokenRepository.getRefreshTokenById(newRefreshTokenId);
            refreshToken.setClient(client);
            this.tokenRepository.saveRefreshToken(refreshToken);
        }
        this.refreshTokenToClientRefs.clear();
        for (Long oldRefreshTokenId : this.refreshTokenToAuthHolderRefs.keySet()) {
            oldAuthHolderId = this.refreshTokenToAuthHolderRefs.get(oldRefreshTokenId);
            newAuthHolderId = this.authHolderOldToNewIdMap.get(oldAuthHolderId);
            authHolder = this.authHolderRepository.getById(newAuthHolderId);
            Long newRefreshTokenId = this.refreshTokenOldToNewIdMap.get(oldRefreshTokenId);
            OAuth2RefreshTokenEntity refreshToken = this.tokenRepository.getRefreshTokenById(newRefreshTokenId);
            refreshToken.setAuthenticationHolder(authHolder);
            this.tokenRepository.saveRefreshToken(refreshToken);
        }
        this.refreshTokenToAuthHolderRefs.clear();
        for (Long oldAccessTokenId : this.accessTokenToClientRefs.keySet()) {
            clientRef = this.accessTokenToClientRefs.get(oldAccessTokenId);
            client = this.clientRepository.getClientByClientId(clientRef);
            Long newAccessTokenId2 = this.accessTokenOldToNewIdMap.get(oldAccessTokenId);
            OAuth2AccessTokenEntity accessToken2 = this.tokenRepository.getAccessTokenById(newAccessTokenId2);
            accessToken2.setClient(client);
            this.tokenRepository.saveAccessToken(accessToken2);
        }
        this.accessTokenToClientRefs.clear();
        for (Long oldAccessTokenId : this.accessTokenToAuthHolderRefs.keySet()) {
            oldAuthHolderId = this.accessTokenToAuthHolderRefs.get(oldAccessTokenId);
            newAuthHolderId = this.authHolderOldToNewIdMap.get(oldAuthHolderId);
            authHolder = this.authHolderRepository.getById(newAuthHolderId);
            newAccessTokenId = this.accessTokenOldToNewIdMap.get(oldAccessTokenId);
            accessToken = this.tokenRepository.getAccessTokenById(newAccessTokenId);
            accessToken.setAuthenticationHolder(authHolder);
            this.tokenRepository.saveAccessToken(accessToken);
        }
        this.accessTokenToAuthHolderRefs.clear();
        for (Long oldAccessTokenId : this.accessTokenToRefreshTokenRefs.keySet()) {
            Long oldRefreshTokenId = this.accessTokenToRefreshTokenRefs.get(oldAccessTokenId);
            Long newRefreshTokenId = this.refreshTokenOldToNewIdMap.get(oldRefreshTokenId);
            OAuth2RefreshTokenEntity refreshToken = this.tokenRepository.getRefreshTokenById(newRefreshTokenId);
            newAccessTokenId = this.accessTokenOldToNewIdMap.get(oldAccessTokenId);
            accessToken = this.tokenRepository.getAccessTokenById(newAccessTokenId);
            accessToken.setRefreshToken(refreshToken);
            this.tokenRepository.saveAccessToken(accessToken);
        }
        this.accessTokenToRefreshTokenRefs.clear();
        this.refreshTokenOldToNewIdMap.clear();
        for (Long oldAccessTokenId : this.accessTokenToIdTokenRefs.keySet()) {
            Long oldIdTokenId = this.accessTokenToIdTokenRefs.get(oldAccessTokenId);
            Long newIdTokenId = this.accessTokenOldToNewIdMap.get(oldIdTokenId);
            OAuth2AccessTokenEntity idToken = this.tokenRepository.getAccessTokenById(newIdTokenId);
            newAccessTokenId = this.accessTokenOldToNewIdMap.get(oldAccessTokenId);
            accessToken = this.tokenRepository.getAccessTokenById(newAccessTokenId);
            accessToken.setIdToken(idToken);
            this.tokenRepository.saveAccessToken(accessToken);
        }
        this.accessTokenToIdTokenRefs.clear();
        for (Long oldGrantId : this.grantToAccessTokensRefs.keySet()) {
            Set<Long> oldAccessTokenIds = this.grantToAccessTokensRefs.get(oldGrantId);
            HashSet<OAuth2AccessTokenEntity> tokens = new HashSet<OAuth2AccessTokenEntity>();
            for (Long oldTokenId : oldAccessTokenIds) {
                Long newTokenId = this.accessTokenOldToNewIdMap.get(oldTokenId);
                tokens.add(this.tokenRepository.getAccessTokenById(newTokenId));
            }
            Long newGrantId = this.grantOldToNewIdMap.get(oldGrantId);
            ApprovedSite site = this.approvedSiteRepository.getById(newGrantId);
            site.setApprovedAccessTokens(tokens);
            this.approvedSiteRepository.save(site);
        }
        this.accessTokenOldToNewIdMap.clear();
        this.grantOldToNewIdMap.clear();
        logger.info("Done fixing object references.");
    }
}

