/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.web;

import com.google.common.base.Strings;
import com.google.gson.JsonSyntaxException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.mitre.jwt.signer.service.JWTSigningAndValidationService;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.model.RegisteredClient;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.oauth2.service.OAuth2TokenEntityService;
import org.mitre.oauth2.service.SystemScopeService;
import org.mitre.openid.connect.ClientDetailsEntityJsonProcessor;
import org.mitre.openid.connect.config.ConfigurationPropertiesBean;
import org.mitre.openid.connect.exception.ValidationException;
import org.mitre.openid.connect.service.BlacklistedSiteService;
import org.mitre.openid.connect.service.OIDCTokenService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.util.UriUtils;

@Controller
@RequestMapping(value={"resource"})
public class ProtectedResourceRegistrationEndpoint {
    public static final String URL = "resource";
    @Autowired
    private ClientDetailsEntityService clientService;
    @Autowired
    private OAuth2TokenEntityService tokenService;
    @Autowired
    private JWTSigningAndValidationService jwtService;
    @Autowired
    private SystemScopeService scopeService;
    @Autowired
    private BlacklistedSiteService blacklistService;
    @Autowired
    private ConfigurationPropertiesBean config;
    @Autowired
    private OIDCTokenService connectTokenService;
    private static final Logger logger = LoggerFactory.getLogger(ProtectedResourceRegistrationEndpoint.class);

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String registerNewProtectedResource(@RequestBody String jsonString, Model m) {
        ClientDetailsEntity newClient = null;
        try {
            newClient = ClientDetailsEntityJsonProcessor.parse((String)jsonString);
        }
        catch (JsonSyntaxException e) {
            logger.error("registerNewProtectedResource failed; submitted JSON is malformed");
            m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
            return "httpCodeView";
        }
        if (newClient != null) {
            newClient.setClientId(null);
            newClient.setClientSecret(null);
            try {
                newClient = this.validateScopes(newClient);
                newClient = this.validateAuth(newClient);
            }
            catch (ValidationException ve) {
                m.addAttribute("error", (Object)ve.getError());
                m.addAttribute("errorMessage", (Object)ve.getErrorDescription());
                m.addAttribute("code", (Object)ve.getStatus());
                return "jsonErrorView";
            }
            newClient.setGrantTypes(new HashSet());
            newClient.setResponseTypes(new HashSet());
            newClient.setRedirectUris(new HashSet());
            newClient.setAccessTokenValiditySeconds(Integer.valueOf(0));
            newClient.setIdTokenValiditySeconds(Integer.valueOf(0));
            newClient.setRefreshTokenValiditySeconds(Integer.valueOf(0));
            newClient.setDefaultACRvalues(new HashSet());
            newClient.setDefaultMaxAge(null);
            newClient.setIdTokenEncryptedResponseAlg(null);
            newClient.setIdTokenEncryptedResponseEnc(null);
            newClient.setIdTokenSignedResponseAlg(null);
            newClient.setInitiateLoginUri(null);
            newClient.setPostLogoutRedirectUris(null);
            newClient.setRequestObjectSigningAlg(null);
            newClient.setRequireAuthTime(null);
            newClient.setReuseRefreshToken(false);
            newClient.setSectorIdentifierUri(null);
            newClient.setSubjectType(null);
            newClient.setUserInfoEncryptedResponseAlg(null);
            newClient.setUserInfoEncryptedResponseEnc(null);
            newClient.setUserInfoSignedResponseAlg(null);
            newClient.setDynamicallyRegistered(true);
            newClient.setAllowIntrospection(true);
            try {
                ClientDetailsEntity savedClient = this.clientService.saveNewClient(newClient);
                OAuth2AccessTokenEntity token = this.connectTokenService.createResourceAccessToken(savedClient);
                this.tokenService.saveAccessToken(token);
                RegisteredClient registered = new RegisteredClient(savedClient, token.getValue(), this.config.getIssuer() + "resource/" + UriUtils.encodePathSegment((String)savedClient.getClientId(), (String)"UTF-8"));
                m.addAttribute("client", (Object)registered);
                m.addAttribute("code", (Object)HttpStatus.CREATED);
                return "clientInformationResponseView";
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Unsupported encoding", (Throwable)e);
                m.addAttribute("code", (Object)HttpStatus.INTERNAL_SERVER_ERROR);
                return "httpCodeView";
            }
            catch (IllegalArgumentException e) {
                logger.error("Couldn't save client", (Throwable)e);
                m.addAttribute("error", (Object)"invalid_client_metadata");
                m.addAttribute("errorMessage", (Object)"Unable to save client due to invalid or inconsistent metadata.");
                m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
                return "jsonErrorView";
            }
        }
        logger.error("registerNewClient failed; submitted JSON is malformed");
        m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
        return "httpCodeView";
    }

    private ClientDetailsEntity validateScopes(ClientDetailsEntity newClient) throws ValidationException {
        Set requestedScopes = this.scopeService.fromStrings(newClient.getScope());
        Set allowedScopes = this.scopeService.removeRestrictedAndReservedScopes(requestedScopes);
        if (allowedScopes == null || allowedScopes.isEmpty()) {
            allowedScopes = this.scopeService.getDefaults();
        }
        newClient.setScope(this.scopeService.toStrings(allowedScopes));
        return newClient;
    }

    @PreAuthorize(value="hasRole('ROLE_CLIENT') and #oauth2.hasScope('resource-token')")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    public String readResourceConfiguration(@PathVariable(value="id") String clientId, Model m, OAuth2Authentication auth) {
        ClientDetailsEntity client = this.clientService.loadClientByClientId(clientId);
        if (client != null && client.getClientId().equals(auth.getOAuth2Request().getClientId())) {
            try {
                OAuth2AccessTokenEntity token = this.fetchValidRegistrationToken(auth, client);
                RegisteredClient registered = new RegisteredClient(client, token.getValue(), this.config.getIssuer() + "resource/" + UriUtils.encodePathSegment((String)client.getClientId(), (String)"UTF-8"));
                m.addAttribute("client", (Object)registered);
                m.addAttribute("code", (Object)HttpStatus.OK);
                return "clientInformationResponseView";
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Unsupported encoding", (Throwable)e);
                m.addAttribute("code", (Object)HttpStatus.INTERNAL_SERVER_ERROR);
                return "httpCodeView";
            }
        }
        logger.error("readResourceConfiguration failed, client ID mismatch: " + clientId + " and " + auth.getOAuth2Request().getClientId() + " do not match.");
        m.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
        return "httpCodeView";
    }

    @PreAuthorize(value="hasRole('ROLE_CLIENT') and #oauth2.hasScope('resource-token')")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT}, produces={"application/json"}, consumes={"application/json"})
    public String updateProtectedResource(@PathVariable(value="id") String clientId, @RequestBody String jsonString, Model m, OAuth2Authentication auth) {
        ClientDetailsEntity newClient = null;
        try {
            newClient = ClientDetailsEntityJsonProcessor.parse((String)jsonString);
        }
        catch (JsonSyntaxException e) {
            logger.error("updateProtectedResource failed; submitted JSON is malformed");
            m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
            return "httpCodeView";
        }
        ClientDetailsEntity oldClient = this.clientService.loadClientByClientId(clientId);
        if (newClient != null && oldClient != null && oldClient.getClientId().equals(auth.getOAuth2Request().getClientId()) && oldClient.getClientId().equals(newClient.getClientId())) {
            newClient.setClientSecret(oldClient.getClientSecret());
            newClient.setCreatedAt(oldClient.getCreatedAt());
            newClient.setGrantTypes(new HashSet());
            newClient.setResponseTypes(new HashSet());
            newClient.setRedirectUris(new HashSet());
            newClient.setAccessTokenValiditySeconds(Integer.valueOf(0));
            newClient.setIdTokenValiditySeconds(Integer.valueOf(0));
            newClient.setRefreshTokenValiditySeconds(Integer.valueOf(0));
            newClient.setDefaultACRvalues(new HashSet());
            newClient.setDefaultMaxAge(null);
            newClient.setIdTokenEncryptedResponseAlg(null);
            newClient.setIdTokenEncryptedResponseEnc(null);
            newClient.setIdTokenSignedResponseAlg(null);
            newClient.setInitiateLoginUri(null);
            newClient.setPostLogoutRedirectUris(null);
            newClient.setRequestObjectSigningAlg(null);
            newClient.setRequireAuthTime(null);
            newClient.setReuseRefreshToken(false);
            newClient.setSectorIdentifierUri(null);
            newClient.setSubjectType(null);
            newClient.setUserInfoEncryptedResponseAlg(null);
            newClient.setUserInfoEncryptedResponseEnc(null);
            newClient.setUserInfoSignedResponseAlg(null);
            newClient.setDynamicallyRegistered(true);
            newClient.setAllowIntrospection(true);
            try {
                newClient = this.validateScopes(newClient);
                newClient = this.validateAuth(newClient);
            }
            catch (ValidationException ve) {
                m.addAttribute("error", (Object)ve.getError());
                m.addAttribute("errorMessage", (Object)ve.getErrorDescription());
                m.addAttribute("code", (Object)ve.getStatus());
                return "jsonErrorView";
            }
            try {
                ClientDetailsEntity savedClient = this.clientService.updateClient(oldClient, newClient);
                OAuth2AccessTokenEntity token = this.fetchValidRegistrationToken(auth, savedClient);
                RegisteredClient registered = new RegisteredClient(savedClient, token.getValue(), this.config.getIssuer() + "resource/" + UriUtils.encodePathSegment((String)savedClient.getClientId(), (String)"UTF-8"));
                m.addAttribute("client", (Object)registered);
                m.addAttribute("code", (Object)HttpStatus.OK);
                return "clientInformationResponseView";
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Unsupported encoding", (Throwable)e);
                m.addAttribute("code", (Object)HttpStatus.INTERNAL_SERVER_ERROR);
                return "httpCodeView";
            }
            catch (IllegalArgumentException e) {
                logger.error("Couldn't save client", (Throwable)e);
                m.addAttribute("error", (Object)"invalid_client_metadata");
                m.addAttribute("errorMessage", (Object)"Unable to save client due to invalid or inconsistent metadata.");
                m.addAttribute("code", (Object)HttpStatus.BAD_REQUEST);
                return "jsonErrorView";
            }
        }
        logger.error("updateProtectedResource failed, client ID mismatch: " + clientId + " and " + auth.getOAuth2Request().getClientId() + " do not match.");
        m.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
        return "httpCodeView";
    }

    @PreAuthorize(value="hasRole('ROLE_CLIENT') and #oauth2.hasScope('resource-token')")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    public String deleteResource(@PathVariable(value="id") String clientId, Model m, OAuth2Authentication auth) {
        ClientDetailsEntity client = this.clientService.loadClientByClientId(clientId);
        if (client != null && client.getClientId().equals(auth.getOAuth2Request().getClientId())) {
            this.clientService.deleteClient(client);
            m.addAttribute("code", (Object)HttpStatus.NO_CONTENT);
            return "httpCodeView";
        }
        logger.error("readClientConfiguration failed, client ID mismatch: " + clientId + " and " + auth.getOAuth2Request().getClientId() + " do not match.");
        m.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
        return "httpCodeView";
    }

    private ClientDetailsEntity validateAuth(ClientDetailsEntity newClient) throws ValidationException {
        if (newClient.getTokenEndpointAuthMethod() == null) {
            newClient.setTokenEndpointAuthMethod(ClientDetailsEntity.AuthMethod.SECRET_BASIC);
        }
        if (newClient.getTokenEndpointAuthMethod() == ClientDetailsEntity.AuthMethod.SECRET_BASIC || newClient.getTokenEndpointAuthMethod() == ClientDetailsEntity.AuthMethod.SECRET_JWT || newClient.getTokenEndpointAuthMethod() == ClientDetailsEntity.AuthMethod.SECRET_POST) {
            if (Strings.isNullOrEmpty((String)newClient.getClientSecret())) {
                newClient = this.clientService.generateClientSecret(newClient);
            }
        } else if (newClient.getTokenEndpointAuthMethod() == ClientDetailsEntity.AuthMethod.PRIVATE_KEY) {
            if (Strings.isNullOrEmpty((String)newClient.getJwksUri()) && newClient.getJwks() == null) {
                throw new ValidationException("invalid_client_metadata", "JWK Set URI required when using private key authentication", HttpStatus.BAD_REQUEST);
            }
            newClient.setClientSecret(null);
        } else if (newClient.getTokenEndpointAuthMethod() == ClientDetailsEntity.AuthMethod.NONE) {
            newClient.setClientSecret(null);
        } else {
            throw new ValidationException("invalid_client_metadata", "Unknown authentication method", HttpStatus.BAD_REQUEST);
        }
        return newClient;
    }

    private OAuth2AccessTokenEntity fetchValidRegistrationToken(OAuth2Authentication auth, ClientDetailsEntity client) {
        OAuth2AuthenticationDetails details = (OAuth2AuthenticationDetails)auth.getDetails();
        OAuth2AccessTokenEntity token = this.tokenService.readAccessToken(details.getTokenValue());
        if (this.config.getRegTokenLifeTime() != null) {
            try {
                Date validToDate = new Date(System.currentTimeMillis() - this.config.getRegTokenLifeTime() * 1000L);
                if (token.getJwt().getJWTClaimsSet().getIssueTime().before(validToDate)) {
                    logger.info("Rotating the registration access token for " + client.getClientId());
                    this.tokenService.revokeAccessToken(token);
                    OAuth2AccessTokenEntity newToken = this.connectTokenService.createResourceAccessToken(client);
                    this.tokenService.saveAccessToken(newToken);
                    return newToken;
                }
                return token;
            }
            catch (ParseException e) {
                logger.error("Couldn't parse a known-valid token?", (Throwable)e);
                return token;
            }
        }
        return token;
    }
}

