/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.repository.impl;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import org.mitre.data.DefaultPageCriteria;
import org.mitre.data.PageCriteria;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.model.OAuth2RefreshTokenEntity;
import org.mitre.oauth2.repository.OAuth2TokenRepository;
import org.mitre.openid.connect.model.ApprovedSite;
import org.mitre.uma.model.ResourceSet;
import org.mitre.util.jpa.JpaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JpaOAuth2TokenRepository
implements OAuth2TokenRepository {
    private static final int MAXEXPIREDRESULTS = 1000;
    private static final Logger logger = LoggerFactory.getLogger(JpaOAuth2TokenRepository.class);
    @PersistenceContext(unitName="defaultPersistenceUnit")
    private EntityManager manager;

    public Set<OAuth2AccessTokenEntity> getAllAccessTokens() {
        TypedQuery query = this.manager.createNamedQuery("OAuth2AccessTokenEntity.getAll", OAuth2AccessTokenEntity.class);
        return new LinkedHashSet<OAuth2AccessTokenEntity>(query.getResultList());
    }

    public Set<OAuth2RefreshTokenEntity> getAllRefreshTokens() {
        TypedQuery query = this.manager.createNamedQuery("OAuth2RefreshTokenEntity.getAll", OAuth2RefreshTokenEntity.class);
        return new LinkedHashSet<OAuth2RefreshTokenEntity>(query.getResultList());
    }

    public OAuth2AccessTokenEntity getAccessTokenByValue(String accessTokenValue) {
        try {
            JWT jwt = JWTParser.parse((String)accessTokenValue);
            TypedQuery query = this.manager.createNamedQuery("OAuth2AccessTokenEntity.getByTokenValue", OAuth2AccessTokenEntity.class);
            query.setParameter("tokenValue", (Object)jwt);
            return (OAuth2AccessTokenEntity)JpaUtil.getSingleResult((List)query.getResultList());
        }
        catch (ParseException e) {
            return null;
        }
    }

    public OAuth2AccessTokenEntity getAccessTokenById(Long id) {
        return (OAuth2AccessTokenEntity)this.manager.find(OAuth2AccessTokenEntity.class, (Object)id);
    }

    @Transactional(value="defaultTransactionManager")
    public OAuth2AccessTokenEntity saveAccessToken(OAuth2AccessTokenEntity token) {
        return (OAuth2AccessTokenEntity)JpaUtil.saveOrUpdate((Object)token.getId(), (EntityManager)this.manager, (Object)token);
    }

    @Transactional(value="defaultTransactionManager")
    public void removeAccessToken(OAuth2AccessTokenEntity accessToken) {
        OAuth2AccessTokenEntity found = this.getAccessTokenById(accessToken.getId());
        if (found == null) {
            throw new IllegalArgumentException("Access token not found: " + accessToken);
        }
        this.manager.remove((Object)found);
    }

    @Transactional(value="defaultTransactionManager")
    public void clearAccessTokensForRefreshToken(OAuth2RefreshTokenEntity refreshToken) {
        TypedQuery query = this.manager.createNamedQuery("OAuth2AccessTokenEntity.getByRefreshToken", OAuth2AccessTokenEntity.class);
        query.setParameter("refreshToken", (Object)refreshToken);
        List accessTokens = query.getResultList();
        for (OAuth2AccessTokenEntity accessToken : accessTokens) {
            this.removeAccessToken(accessToken);
        }
    }

    public OAuth2RefreshTokenEntity getRefreshTokenByValue(String refreshTokenValue) {
        try {
            JWT jwt = JWTParser.parse((String)refreshTokenValue);
            TypedQuery query = this.manager.createNamedQuery("OAuth2RefreshTokenEntity.getByTokenValue", OAuth2RefreshTokenEntity.class);
            query.setParameter("tokenValue", (Object)jwt);
            return (OAuth2RefreshTokenEntity)JpaUtil.getSingleResult((List)query.getResultList());
        }
        catch (ParseException e) {
            return null;
        }
    }

    public OAuth2RefreshTokenEntity getRefreshTokenById(Long id) {
        return (OAuth2RefreshTokenEntity)this.manager.find(OAuth2RefreshTokenEntity.class, (Object)id);
    }

    @Transactional(value="defaultTransactionManager")
    public OAuth2RefreshTokenEntity saveRefreshToken(OAuth2RefreshTokenEntity refreshToken) {
        return (OAuth2RefreshTokenEntity)JpaUtil.saveOrUpdate((Object)refreshToken.getId(), (EntityManager)this.manager, (Object)refreshToken);
    }

    @Transactional(value="defaultTransactionManager")
    public void removeRefreshToken(OAuth2RefreshTokenEntity refreshToken) {
        OAuth2RefreshTokenEntity found = this.getRefreshTokenById(refreshToken.getId());
        if (found == null) {
            throw new IllegalArgumentException("Refresh token not found: " + refreshToken);
        }
        this.manager.remove((Object)found);
    }

    @Transactional(value="defaultTransactionManager")
    public void clearTokensForClient(ClientDetailsEntity client) {
        TypedQuery queryA = this.manager.createNamedQuery("OAuth2AccessTokenEntity.getByClient", OAuth2AccessTokenEntity.class);
        queryA.setParameter("client", (Object)client);
        List accessTokens = queryA.getResultList();
        for (OAuth2AccessTokenEntity accessToken : accessTokens) {
            this.removeAccessToken(accessToken);
        }
        TypedQuery queryR = this.manager.createNamedQuery("OAuth2RefreshTokenEntity.getByClient", OAuth2RefreshTokenEntity.class);
        queryR.setParameter("client", (Object)client);
        List refreshTokens = queryR.getResultList();
        for (OAuth2RefreshTokenEntity refreshToken : refreshTokens) {
            this.removeRefreshToken(refreshToken);
        }
    }

    public List<OAuth2AccessTokenEntity> getAccessTokensForClient(ClientDetailsEntity client) {
        TypedQuery queryA = this.manager.createNamedQuery("OAuth2AccessTokenEntity.getByClient", OAuth2AccessTokenEntity.class);
        queryA.setParameter("client", (Object)client);
        List accessTokens = queryA.getResultList();
        return accessTokens;
    }

    public List<OAuth2RefreshTokenEntity> getRefreshTokensForClient(ClientDetailsEntity client) {
        TypedQuery queryR = this.manager.createNamedQuery("OAuth2RefreshTokenEntity.getByClient", OAuth2RefreshTokenEntity.class);
        queryR.setParameter("client", (Object)client);
        List refreshTokens = queryR.getResultList();
        return refreshTokens;
    }

    public Set<OAuth2AccessTokenEntity> getAllExpiredAccessTokens() {
        DefaultPageCriteria pageCriteria = new DefaultPageCriteria(0, 1000);
        return this.getAllExpiredAccessTokens((PageCriteria)pageCriteria);
    }

    public Set<OAuth2AccessTokenEntity> getAllExpiredAccessTokens(PageCriteria pageCriteria) {
        TypedQuery query = this.manager.createNamedQuery("OAuth2AccessTokenEntity.getAllExpiredByDate", OAuth2AccessTokenEntity.class);
        query.setParameter("date", (Object)new Date());
        return new LinkedHashSet<OAuth2AccessTokenEntity>(JpaUtil.getResultPage((TypedQuery)query, (PageCriteria)pageCriteria));
    }

    public Set<OAuth2RefreshTokenEntity> getAllExpiredRefreshTokens() {
        DefaultPageCriteria pageCriteria = new DefaultPageCriteria(0, 1000);
        return this.getAllExpiredRefreshTokens((PageCriteria)pageCriteria);
    }

    public Set<OAuth2RefreshTokenEntity> getAllExpiredRefreshTokens(PageCriteria pageCriteria) {
        TypedQuery query = this.manager.createNamedQuery("OAuth2RefreshTokenEntity.getAllExpiredByDate", OAuth2RefreshTokenEntity.class);
        query.setParameter("date", (Object)new Date());
        return new LinkedHashSet<OAuth2RefreshTokenEntity>(JpaUtil.getResultPage((TypedQuery)query, (PageCriteria)pageCriteria));
    }

    public Set<OAuth2AccessTokenEntity> getAccessTokensForResourceSet(ResourceSet rs) {
        TypedQuery query = this.manager.createNamedQuery("OAuth2AccessTokenEntity.getByResourceSet", OAuth2AccessTokenEntity.class);
        query.setParameter("rsid", (Object)rs.getId());
        return new LinkedHashSet<OAuth2AccessTokenEntity>(query.getResultList());
    }

    @Transactional(value="defaultTransactionManager")
    public void clearDuplicateAccessTokens() {
        Query query = this.manager.createQuery("select a.jwt, count(1) as c from OAuth2AccessTokenEntity a GROUP BY a.jwt HAVING count(1) > 1");
        List resultList = query.getResultList();
        ArrayList<JWT> values = new ArrayList<JWT>();
        for (Object[] r : resultList) {
            logger.warn("Found duplicate access tokens: {}, {}", (Object)((JWT)r[0]).serialize(), r[1]);
            values.add((JWT)r[0]);
        }
        if (values.size() > 0) {
            CriteriaBuilder cb = this.manager.getCriteriaBuilder();
            CriteriaDelete criteriaDelete = cb.createCriteriaDelete(OAuth2AccessTokenEntity.class);
            Root root = criteriaDelete.from(OAuth2AccessTokenEntity.class);
            criteriaDelete.where((Expression)root.get("jwt").in(values));
            int result = this.manager.createQuery(criteriaDelete).executeUpdate();
            logger.warn("Deleted {} duplicate access tokens", (Object)result);
        }
    }

    @Transactional(value="defaultTransactionManager")
    public void clearDuplicateRefreshTokens() {
        Query query = this.manager.createQuery("select a.jwt, count(1) as c from OAuth2RefreshTokenEntity a GROUP BY a.jwt HAVING count(1) > 1");
        List resultList = query.getResultList();
        ArrayList<JWT> values = new ArrayList<JWT>();
        for (Object[] r : resultList) {
            logger.warn("Found duplicate refresh tokens: {}, {}", (Object)((JWT)r[0]).serialize(), r[1]);
            values.add((JWT)r[0]);
        }
        if (values.size() > 0) {
            CriteriaBuilder cb = this.manager.getCriteriaBuilder();
            CriteriaDelete criteriaDelete = cb.createCriteriaDelete(OAuth2RefreshTokenEntity.class);
            Root root = criteriaDelete.from(OAuth2RefreshTokenEntity.class);
            criteriaDelete.where((Expression)root.get("jwt").in(values));
            int result = this.manager.createQuery(criteriaDelete).executeUpdate();
            logger.warn("Deleted {} duplicate refresh tokens", (Object)result);
        }
    }

    public List<OAuth2AccessTokenEntity> getAccessTokensForApprovedSite(ApprovedSite approvedSite) {
        TypedQuery queryA = this.manager.createNamedQuery("OAuth2AccessTokenEntity.getByApprovedSite", OAuth2AccessTokenEntity.class);
        queryA.setParameter("approvedSite", (Object)approvedSite);
        List accessTokens = queryA.getResultList();
        return accessTokens;
    }
}

