/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.web;

import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.model.OAuth2RefreshTokenEntity;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.oauth2.service.OAuth2TokenEntityService;
import org.mitre.oauth2.web.AuthenticationUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class RevocationEndpoint {
    @Autowired
    private ClientDetailsEntityService clientService;
    @Autowired
    private OAuth2TokenEntityService tokenServices;
    private static final Logger logger = LoggerFactory.getLogger(RevocationEndpoint.class);
    public static final String URL = "revoke";

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasRole('ROLE_CLIENT')")
    @RequestMapping(value={"/revoke"})
    public String revoke(@RequestParam(value="token") String tokenValue, @RequestParam(value="token_type_hint", required=false) String tokenType, Authentication auth, Model model) {
        ClientDetailsEntity authClient = null;
        if (auth instanceof OAuth2Authentication) {
            AuthenticationUtilities.ensureOAuthScope(auth, "uma_protection");
            OAuth2Authentication o2a = (OAuth2Authentication)auth;
            String authClientId = o2a.getOAuth2Request().getClientId();
            authClient = this.clientService.loadClientByClientId(authClientId);
            String string = o2a.getUserAuthentication().getName();
        } else {
            String authClientId = auth.getName();
            authClient = this.clientService.loadClientByClientId(authClientId);
        }
        try {
            OAuth2AccessTokenEntity accessToken = this.tokenServices.readAccessToken(tokenValue);
            if (!accessToken.getClient().getClientId().equals(authClient.getClientId())) {
                logger.info("Client " + authClient.getClientId() + " tried to revoke a token owned by " + accessToken.getClient().getClientId());
                model.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
                return "httpCodeView";
            }
            this.tokenServices.revokeAccessToken(accessToken);
            logger.debug("Client " + authClient.getClientId() + " revoked access token " + tokenValue);
            model.addAttribute("code", (Object)HttpStatus.OK);
            return "httpCodeView";
        }
        catch (InvalidTokenException e) {
            try {
                OAuth2RefreshTokenEntity refreshToken = this.tokenServices.getRefreshToken(tokenValue);
                if (!refreshToken.getClient().getClientId().equals(authClient.getClientId())) {
                    logger.info("Client " + authClient.getClientId() + " tried to revoke a token owned by " + refreshToken.getClient().getClientId());
                    model.addAttribute("code", (Object)HttpStatus.FORBIDDEN);
                    return "httpCodeView";
                }
                this.tokenServices.revokeRefreshToken(refreshToken);
                logger.debug("Client " + authClient.getClientId() + " revoked access token " + tokenValue);
                model.addAttribute("code", (Object)HttpStatus.OK);
                return "httpCodeView";
            }
            catch (InvalidTokenException e1) {
                logger.debug("Failed to revoke token " + tokenValue);
                model.addAttribute("code", (Object)HttpStatus.OK);
                return "httpCodeView";
            }
        }
    }
}

