/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.service.impl;

import com.google.common.base.Strings;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.mitre.data.AbstractPageOperationTemplate;
import org.mitre.data.DefaultPageCriteria;
import org.mitre.data.PageCriteria;
import org.mitre.oauth2.model.AuthenticationHolderEntity;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.OAuth2AccessTokenEntity;
import org.mitre.oauth2.model.OAuth2RefreshTokenEntity;
import org.mitre.oauth2.model.PKCEAlgorithm;
import org.mitre.oauth2.repository.AuthenticationHolderRepository;
import org.mitre.oauth2.repository.OAuth2TokenRepository;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.oauth2.service.OAuth2TokenEntityService;
import org.mitre.oauth2.service.SystemScopeService;
import org.mitre.openid.connect.model.ApprovedSite;
import org.mitre.openid.connect.service.ApprovedSiteService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.common.exceptions.InvalidRequestException;
import org.springframework.security.oauth2.common.exceptions.InvalidScopeException;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.security.oauth2.provider.token.TokenEnhancer;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultOAuth2ProviderTokenService")
public class DefaultOAuth2ProviderTokenService
implements OAuth2TokenEntityService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultOAuth2ProviderTokenService.class);
    @Autowired
    private OAuth2TokenRepository tokenRepository;
    @Autowired
    private AuthenticationHolderRepository authenticationHolderRepository;
    @Autowired
    private ClientDetailsEntityService clientDetailsService;
    @Autowired
    private TokenEnhancer tokenEnhancer;
    @Autowired
    private SystemScopeService scopeService;
    @Autowired
    private ApprovedSiteService approvedSiteService;

    public Set<OAuth2AccessTokenEntity> getAllAccessTokensForUser(String userName) {
        return this.tokenRepository.getAccessTokensByUserName(userName);
    }

    public Set<OAuth2RefreshTokenEntity> getAllRefreshTokensForUser(String userName) {
        return this.tokenRepository.getRefreshTokensByUserName(userName);
    }

    public OAuth2AccessTokenEntity getAccessTokenById(Long id) {
        return this.clearExpiredAccessToken(this.tokenRepository.getAccessTokenById(id));
    }

    public OAuth2RefreshTokenEntity getRefreshTokenById(Long id) {
        return this.clearExpiredRefreshToken(this.tokenRepository.getRefreshTokenById(id));
    }

    private OAuth2AccessTokenEntity clearExpiredAccessToken(OAuth2AccessTokenEntity token) {
        if (token == null) {
            return null;
        }
        if (token.isExpired()) {
            logger.debug("Clearing expired access token: " + token.getValue());
            this.revokeAccessToken(token);
            return null;
        }
        return token;
    }

    private OAuth2RefreshTokenEntity clearExpiredRefreshToken(OAuth2RefreshTokenEntity token) {
        if (token == null) {
            return null;
        }
        if (token.isExpired()) {
            logger.debug("Clearing expired refresh token: " + token.getValue());
            this.revokeRefreshToken(token);
            return null;
        }
        return token;
    }

    @Transactional(value="defaultTransactionManager")
    public OAuth2AccessTokenEntity createAccessToken(OAuth2Authentication authentication) throws AuthenticationException, InvalidClientException {
        if (authentication != null && authentication.getOAuth2Request() != null) {
            OAuth2AccessTokenEntity enhancedToken;
            OAuth2AccessTokenEntity savedToken;
            OAuth2Request originalAuthRequest;
            OAuth2Request request = authentication.getOAuth2Request();
            ClientDetailsEntity client = this.clientDetailsService.loadClientByClientId(request.getClientId());
            if (client == null) {
                throw new InvalidClientException("Client not found: " + request.getClientId());
            }
            if (request.getExtensions().containsKey("code_challenge")) {
                String challenge = (String)request.getExtensions().get("code_challenge");
                PKCEAlgorithm alg = PKCEAlgorithm.parse((String)((String)request.getExtensions().get("code_challenge_method")));
                String verifier = (String)request.getRequestParameters().get("code_verifier");
                if (alg.equals((Object)PKCEAlgorithm.plain)) {
                    if (!challenge.equals(verifier)) {
                        throw new InvalidRequestException("Code challenge and verifier do not match");
                    }
                } else if (alg.equals((Object)PKCEAlgorithm.S256)) {
                    try {
                        MessageDigest digest = MessageDigest.getInstance("SHA-256");
                        String hash = Base64URL.encode((byte[])digest.digest(verifier.getBytes(StandardCharsets.US_ASCII))).toString();
                        if (!challenge.equals(hash)) {
                            throw new InvalidRequestException("Code challenge and verifier do not match");
                        }
                    }
                    catch (NoSuchAlgorithmException e) {
                        logger.error("Unknown algorithm for PKCE digest", (Throwable)e);
                    }
                }
            }
            OAuth2AccessTokenEntity token = new OAuth2AccessTokenEntity();
            token.setClient(client);
            Set scopes = this.scopeService.fromStrings(request.getScope());
            scopes = this.scopeService.removeReservedScopes(scopes);
            token.setScope(this.scopeService.toStrings(scopes));
            if (client.getAccessTokenValiditySeconds() != null && client.getAccessTokenValiditySeconds() > 0) {
                Date expiration = new Date(System.currentTimeMillis() + (long)client.getAccessTokenValiditySeconds().intValue() * 1000L);
                token.setExpiration(expiration);
            }
            AuthenticationHolderEntity authHolder = new AuthenticationHolderEntity();
            authHolder.setAuthentication(authentication);
            authHolder = this.authenticationHolderRepository.save(authHolder);
            token.setAuthenticationHolder(authHolder);
            if (client.isAllowRefresh() && token.getScope().contains("offline_access")) {
                OAuth2RefreshTokenEntity savedRefreshToken = this.createRefreshToken(client, authHolder);
                token.setRefreshToken(savedRefreshToken);
            }
            if ((originalAuthRequest = authHolder.getAuthentication().getOAuth2Request()).getExtensions() != null && originalAuthRequest.getExtensions().containsKey("approved_site")) {
                Long apId = Long.parseLong((String)originalAuthRequest.getExtensions().get("approved_site"));
                ApprovedSite ap = this.approvedSiteService.getById(apId);
                token.setApprovedSite(ap);
            }
            if ((savedToken = this.saveAccessToken(enhancedToken = (OAuth2AccessTokenEntity)this.tokenEnhancer.enhance((OAuth2AccessToken)token, authentication))).getRefreshToken() != null) {
                this.tokenRepository.saveRefreshToken(savedToken.getRefreshToken());
            }
            return savedToken;
        }
        throw new AuthenticationCredentialsNotFoundException("No authentication credentials found");
    }

    private OAuth2RefreshTokenEntity createRefreshToken(ClientDetailsEntity client, AuthenticationHolderEntity authHolder) {
        OAuth2RefreshTokenEntity refreshToken = new OAuth2RefreshTokenEntity();
        JWTClaimsSet.Builder refreshClaims = new JWTClaimsSet.Builder();
        if (client.getRefreshTokenValiditySeconds() != null) {
            Date expiration = new Date(System.currentTimeMillis() + (long)client.getRefreshTokenValiditySeconds().intValue() * 1000L);
            refreshToken.setExpiration(expiration);
            refreshClaims.expirationTime(expiration);
        }
        refreshClaims.jwtID(UUID.randomUUID().toString());
        PlainJWT refreshJwt = new PlainJWT(refreshClaims.build());
        refreshToken.setJwt((JWT)refreshJwt);
        refreshToken.setAuthenticationHolder(authHolder);
        refreshToken.setClient(client);
        OAuth2RefreshTokenEntity savedRefreshToken = this.tokenRepository.saveRefreshToken(refreshToken);
        return savedRefreshToken;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Transactional(value="defaultTransactionManager")
    public OAuth2AccessTokenEntity refreshAccessToken(String refreshTokenValue, TokenRequest authRequest) throws AuthenticationException {
        OAuth2AccessTokenEntity token;
        AuthenticationHolderEntity authHolder;
        ClientDetailsEntity client;
        OAuth2RefreshTokenEntity refreshToken;
        block12: {
            if (Strings.isNullOrEmpty((String)refreshTokenValue)) {
                throw new InvalidTokenException("Invalid refresh token: " + refreshTokenValue);
            }
            refreshToken = this.clearExpiredRefreshToken(this.tokenRepository.getRefreshTokenByValue(refreshTokenValue));
            if (refreshToken == null) {
                throw new InvalidTokenException("Invalid refresh token: " + refreshTokenValue);
            }
            client = refreshToken.getClient();
            authHolder = refreshToken.getAuthenticationHolder();
            ClientDetailsEntity requestingClient = this.clientDetailsService.loadClientByClientId(authRequest.getClientId());
            if (!client.getClientId().equals(requestingClient.getClientId())) {
                this.tokenRepository.removeRefreshToken(refreshToken);
                throw new InvalidClientException("Client does not own the presented refresh token");
            }
            if (!client.isAllowRefresh()) {
                throw new InvalidClientException("Client does not allow refreshing access token!");
            }
            if (client.isClearAccessTokensOnRefresh()) {
                this.tokenRepository.clearAccessTokensForRefreshToken(refreshToken);
            }
            if (refreshToken.isExpired()) {
                this.tokenRepository.removeRefreshToken(refreshToken);
                throw new InvalidTokenException("Expired refresh token: " + refreshTokenValue);
            }
            token = new OAuth2AccessTokenEntity();
            HashSet refreshScopesRequested = new HashSet(refreshToken.getAuthenticationHolder().getAuthentication().getOAuth2Request().getScope());
            Set refreshScopes = this.scopeService.fromStrings(refreshScopesRequested);
            refreshScopes = this.scopeService.removeReservedScopes(refreshScopes);
            HashSet scopeRequested = authRequest.getScope() == null ? new HashSet() : new HashSet(authRequest.getScope());
            Set scope = this.scopeService.fromStrings(scopeRequested);
            if ((scope = this.scopeService.removeReservedScopes(scope)) != null && !scope.isEmpty()) {
                if (refreshScopes != null && refreshScopes.containsAll(scope)) {
                    token.setScope(this.scopeService.toStrings(scope));
                    break block12;
                } else {
                    String errorMsg = "Up-scoping is not allowed.";
                    logger.error(errorMsg);
                    throw new InvalidScopeException(errorMsg);
                }
            }
            token.setScope(this.scopeService.toStrings(refreshScopes));
        }
        token.setClient(client);
        if (client.getAccessTokenValiditySeconds() != null) {
            Date expiration = new Date(System.currentTimeMillis() + (long)client.getAccessTokenValiditySeconds().intValue() * 1000L);
            token.setExpiration(expiration);
        }
        if (client.isReuseRefreshToken()) {
            token.setRefreshToken(refreshToken);
        } else {
            OAuth2RefreshTokenEntity newRefresh = this.createRefreshToken(client, authHolder);
            token.setRefreshToken(newRefresh);
            this.tokenRepository.removeRefreshToken(refreshToken);
        }
        token.setAuthenticationHolder(authHolder);
        this.tokenEnhancer.enhance((OAuth2AccessToken)token, authHolder.getAuthentication());
        this.tokenRepository.saveAccessToken(token);
        return token;
    }

    public OAuth2Authentication loadAuthentication(String accessTokenValue) throws AuthenticationException {
        OAuth2AccessTokenEntity accessToken = this.clearExpiredAccessToken(this.tokenRepository.getAccessTokenByValue(accessTokenValue));
        if (accessToken == null) {
            throw new InvalidTokenException("Invalid access token: " + accessTokenValue);
        }
        return accessToken.getAuthenticationHolder().getAuthentication();
    }

    public OAuth2AccessTokenEntity readAccessToken(String accessTokenValue) throws AuthenticationException {
        OAuth2AccessTokenEntity accessToken = this.clearExpiredAccessToken(this.tokenRepository.getAccessTokenByValue(accessTokenValue));
        if (accessToken == null) {
            throw new InvalidTokenException("Access token for value " + accessTokenValue + " was not found");
        }
        return accessToken;
    }

    public OAuth2AccessTokenEntity getAccessToken(OAuth2Authentication authentication) {
        throw new UnsupportedOperationException("Unable to look up access token from authentication object.");
    }

    public OAuth2RefreshTokenEntity getRefreshToken(String refreshTokenValue) throws AuthenticationException {
        OAuth2RefreshTokenEntity refreshToken = this.tokenRepository.getRefreshTokenByValue(refreshTokenValue);
        if (refreshToken == null) {
            throw new InvalidTokenException("Refresh token for value " + refreshTokenValue + " was not found");
        }
        return refreshToken;
    }

    @Transactional(value="defaultTransactionManager")
    public void revokeRefreshToken(OAuth2RefreshTokenEntity refreshToken) {
        this.tokenRepository.clearAccessTokensForRefreshToken(refreshToken);
        this.tokenRepository.removeRefreshToken(refreshToken);
    }

    @Transactional(value="defaultTransactionManager")
    public void revokeAccessToken(OAuth2AccessTokenEntity accessToken) {
        this.tokenRepository.removeAccessToken(accessToken);
    }

    public List<OAuth2AccessTokenEntity> getAccessTokensForClient(ClientDetailsEntity client) {
        return this.tokenRepository.getAccessTokensForClient(client);
    }

    public List<OAuth2RefreshTokenEntity> getRefreshTokensForClient(ClientDetailsEntity client) {
        return this.tokenRepository.getRefreshTokensForClient(client);
    }

    public void clearExpiredTokens() {
        logger.debug("Cleaning out all expired tokens");
        new AbstractPageOperationTemplate<OAuth2AccessTokenEntity>("clearExpiredAccessTokens"){

            public Collection<OAuth2AccessTokenEntity> fetchPage() {
                return DefaultOAuth2ProviderTokenService.this.tokenRepository.getAllExpiredAccessTokens((PageCriteria)new DefaultPageCriteria());
            }

            public void doOperation(OAuth2AccessTokenEntity item) {
                DefaultOAuth2ProviderTokenService.this.revokeAccessToken(item);
            }
        }.execute();
        new AbstractPageOperationTemplate<OAuth2RefreshTokenEntity>("clearExpiredRefreshTokens"){

            public Collection<OAuth2RefreshTokenEntity> fetchPage() {
                return DefaultOAuth2ProviderTokenService.this.tokenRepository.getAllExpiredRefreshTokens((PageCriteria)new DefaultPageCriteria());
            }

            public void doOperation(OAuth2RefreshTokenEntity item) {
                DefaultOAuth2ProviderTokenService.this.revokeRefreshToken(item);
            }
        }.execute();
        new AbstractPageOperationTemplate<AuthenticationHolderEntity>("clearExpiredAuthenticationHolders"){

            public Collection<AuthenticationHolderEntity> fetchPage() {
                return DefaultOAuth2ProviderTokenService.this.authenticationHolderRepository.getOrphanedAuthenticationHolders((PageCriteria)new DefaultPageCriteria());
            }

            public void doOperation(AuthenticationHolderEntity item) {
                DefaultOAuth2ProviderTokenService.this.authenticationHolderRepository.remove(item);
            }
        }.execute();
    }

    @Transactional(value="defaultTransactionManager")
    public OAuth2AccessTokenEntity saveAccessToken(OAuth2AccessTokenEntity accessToken) {
        OAuth2AccessTokenEntity newToken = this.tokenRepository.saveAccessToken(accessToken);
        if (accessToken.getAdditionalInformation() != null && !accessToken.getAdditionalInformation().isEmpty()) {
            newToken.getAdditionalInformation().putAll(accessToken.getAdditionalInformation());
        }
        return newToken;
    }

    @Transactional(value="defaultTransactionManager")
    public OAuth2RefreshTokenEntity saveRefreshToken(OAuth2RefreshTokenEntity refreshToken) {
        return this.tokenRepository.saveRefreshToken(refreshToken);
    }

    public TokenEnhancer getTokenEnhancer() {
        return this.tokenEnhancer;
    }

    public void setTokenEnhancer(TokenEnhancer tokenEnhancer) {
        this.tokenEnhancer = tokenEnhancer;
    }

    public OAuth2AccessTokenEntity getRegistrationAccessTokenForClient(ClientDetailsEntity client) {
        List<OAuth2AccessTokenEntity> allTokens = this.getAccessTokensForClient(client);
        for (OAuth2AccessTokenEntity token : allTokens) {
            if (!token.getScope().contains("registration-token") && !token.getScope().contains("resource-token") || token.getScope().size() != 1) continue;
            return token;
        }
        return null;
    }
}

