/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.web;

import com.google.gson.Gson;
import java.util.Set;
import org.mitre.oauth2.model.SystemScope;
import org.mitre.oauth2.service.SystemScopeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/api/scopes"})
@PreAuthorize(value="hasRole('ROLE_USER')")
public class ScopeAPI {
    public static final String URL = "api/scopes";
    @Autowired
    private SystemScopeService scopeService;
    private static final Logger logger = LoggerFactory.getLogger(ScopeAPI.class);
    private Gson gson = new Gson();

    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/json"})
    public String getAll(ModelMap m) {
        Set allScopes = this.scopeService.getAll();
        m.put((Object)"entity", (Object)allScopes);
        return "jsonEntityView";
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getScope(@PathVariable(value="id") Long id, ModelMap m) {
        SystemScope scope = this.scopeService.getById(id);
        if (scope != null) {
            m.put((Object)"entity", (Object)scope);
            return "jsonEntityView";
        }
        logger.error("getScope failed; scope not found: " + id);
        m.put((Object)"code", (Object)HttpStatus.NOT_FOUND);
        m.put((Object)"errorMessage", (Object)("The requested scope with id " + id + " could not be found."));
        return "jsonErrorView";
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT}, produces={"application/json"}, consumes={"application/json"})
    public String updateScope(@PathVariable(value="id") Long id, @RequestBody String json, ModelMap m) {
        SystemScope existing = this.scopeService.getById(id);
        SystemScope scope = (SystemScope)this.gson.fromJson(json, SystemScope.class);
        if (existing != null && scope != null) {
            if (existing.getId().equals(scope.getId())) {
                scope = this.scopeService.save(scope);
                m.put((Object)"entity", (Object)scope);
                return "jsonEntityView";
            }
            logger.error("updateScope failed; scope ids to not match: got " + existing.getId() + " and " + scope.getId());
            m.put((Object)"code", (Object)HttpStatus.BAD_REQUEST);
            m.put((Object)"errorMessage", (Object)("Could not update scope. Scope ids to not match: got " + existing.getId() + " and " + scope.getId()));
            return "jsonErrorView";
        }
        logger.error("updateScope failed; scope with id " + id + " not found.");
        m.put((Object)"code", (Object)HttpStatus.NOT_FOUND);
        m.put((Object)"errorMessage", (Object)("Could not update scope. The scope with id " + id + " could not be found."));
        return "jsonErrorView";
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={""}, method={RequestMethod.POST}, produces={"application/json"}, consumes={"application/json"})
    public String createScope(@RequestBody String json, ModelMap m) {
        SystemScope scope = (SystemScope)this.gson.fromJson(json, SystemScope.class);
        SystemScope alreadyExists = this.scopeService.getByValue(scope.getValue());
        if (alreadyExists != null) {
            logger.error("Error: attempting to save a scope with a value that already exists: " + scope.getValue());
            m.put((Object)"code", (Object)HttpStatus.CONFLICT);
            m.put((Object)"errorMessage", (Object)("A scope with value " + scope.getValue() + " already exists, please choose a different value."));
            return "jsonErrorView";
        }
        if ((scope = this.scopeService.save(scope)) != null && scope.getId() != null) {
            m.put((Object)"entity", (Object)scope);
            return "jsonEntityView";
        }
        logger.error("createScope failed; JSON was invalid: " + json);
        m.put((Object)"code", (Object)HttpStatus.BAD_REQUEST);
        m.put((Object)"errorMessage", (Object)("Could not save new scope " + scope + ". The scope service failed to return a saved entity."));
        return "jsonErrorView";
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public String deleteScope(@PathVariable(value="id") Long id, ModelMap m) {
        SystemScope existing = this.scopeService.getById(id);
        if (existing != null) {
            this.scopeService.remove(existing);
            return "httpCodeView";
        }
        logger.error("deleteScope failed; scope with id " + id + " not found.");
        m.put((Object)"code", (Object)HttpStatus.NOT_FOUND);
        m.put((Object)"errorMessage", (Object)("Could not delete scope. The requested scope with id " + id + " could not be found."));
        return "jsonErrorView";
    }
}

