/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client;

import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpMethod;
import org.mockserver.client.ForwardChainExpectation;
import org.mockserver.client.serialization.ExpectationSerializer;
import org.mockserver.matchers.Times;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServerClient {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String mockServerURI;
    private HttpClient httpClient = new HttpClient();
    private ExpectationSerializer expectationSerializer = new ExpectationSerializer();

    public MockServerClient(String host, int port) {
        this.mockServerURI = "http://" + host + ":" + port + "/";
        try {
            this.httpClient.start();
        }
        catch (Exception e) {
            this.logger.error("Exception starting HttpClient in MockServerClient", (Throwable)e);
            throw new RuntimeException("Exception starting HttpClient in MockServerClient", e);
        }
    }

    @VisibleForTesting
    MockServerClient(String host, int port, HttpClient httpClient) {
        this.mockServerURI = "http://" + host + ":" + port + "/";
        this.httpClient = httpClient;
        try {
            this.httpClient.start();
        }
        catch (Exception e) {
            this.logger.error("Exception starting HttpClient in MockServerClient", (Throwable)e);
            throw new RuntimeException("Exception starting HttpClient in MockServerClient", e);
        }
    }

    public ForwardChainExpectation when(HttpRequest httpRequest) {
        return this.when(httpRequest, Times.unlimited());
    }

    public ForwardChainExpectation when(HttpRequest httpRequest, Times times) {
        return new ForwardChainExpectation(this, new Expectation(httpRequest, times));
    }

    public void dumpToLog() {
        try {
            this.sendRequest("", "dumpToLog");
        }
        catch (Exception e) {
            this.logger.error("Exception sending reset request to MockServer", (Throwable)e);
            throw new RuntimeException("Exception sending reset request to MockServer", e);
        }
    }

    public void reset() {
        try {
            this.sendRequest("", "reset");
        }
        catch (Exception e) {
            this.logger.error("Exception sending reset request to MockServer", (Throwable)e);
            throw new RuntimeException("Exception sending reset request to MockServer", e);
        }
    }

    public void clear(HttpRequest httpRequest) {
        this.sendExpectation(new Expectation(httpRequest, Times.unlimited()).respond(new HttpResponse()), "clear");
    }

    protected void sendExpectation(Expectation expectation) {
        this.sendExpectation(expectation, "");
    }

    private void sendExpectation(Expectation expectation, String path) {
        try {
            this.sendRequest(expectation != null ? this.expectationSerializer.serialize(expectation) : "", path);
        }
        catch (Exception e) {
            this.logger.error(String.format("Exception sending expectation to MockServer as %s", expectation), (Throwable)e);
            throw new RuntimeException(String.format("Exception sending expectation to MockServer as %s", expectation), e);
        }
    }

    private void sendRequest(String body, String path) throws Exception {
        this.httpClient.newRequest(this.mockServerURI + path).method(HttpMethod.PUT).header("Content-Type", "application/json; charset=utf-8").content((ContentProvider)new ComparableStringContentProvider(body, "UTF-8")).send();
    }

    static class ComparableStringContentProvider
    extends StringContentProvider {
        public ComparableStringContentProvider(String content, String encoding) {
            super(content, encoding);
        }

        public boolean equals(Object other) {
            return EqualsBuilder.reflectionEquals((Object)((Object)this), (Object)other, (String[])new String[0]);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)((Object)this), (String[])new String[0]);
        }
    }
}

