/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.authentication.mtls;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.google.common.collect.ImmutableMap;
import java.security.cert.X509Certificate;
import org.mockserver.authentication.AuthenticationException;
import org.mockserver.authentication.AuthenticationHandler;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequest;
import org.mockserver.serialization.ObjectMapperFactory;
import org.slf4j.event.Level;

public class MTLSAuthenticationHandler
implements AuthenticationHandler {
    private final MockServerLogger mockServerLogger;
    private final X509Certificate[] controlPlaneTLSMutualAuthenticationCAChain;

    public MTLSAuthenticationHandler(MockServerLogger mockServerLogger, X509Certificate[] controlPlaneTLSMutualAuthenticationCAChain) {
        this.mockServerLogger = mockServerLogger;
        this.controlPlaneTLSMutualAuthenticationCAChain = controlPlaneTLSMutualAuthenticationCAChain;
    }

    @Override
    public boolean controlPlaneRequestAuthenticated(HttpRequest request) {
        if (this.controlPlaneTLSMutualAuthenticationCAChain != null && this.controlPlaneTLSMutualAuthenticationCAChain.length != 0) {
            if (request.getClientCertificateChain() != null) {
                for (org.mockserver.model.X509Certificate clientCertificate : request.getClientCertificateChain()) {
                    for (X509Certificate caCertificate : this.controlPlaneTLSMutualAuthenticationCAChain) {
                        String clientCertificateInformation = this.getClientCertificateInformation(clientCertificate.getSerialNumber(), clientCertificate.getIssuerDistinguishedName(), clientCertificate.getSubjectDistinguishedName());
                        String caCertificateInformation = this.getClientCertificateInformation(caCertificate.getSerialNumber().toString(), caCertificate.getIssuerDN().getName(), caCertificate.getSubjectDN().getName());
                        try {
                            clientCertificate.getCertificate().verify(caCertificate.getPublicKey());
                            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setHttpRequest(request).setMessageFormat("validated client certificate:{}against control plane trust store certificate:{}").setArguments(clientCertificateInformation, caCertificateInformation));
                            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setHttpRequest(request).setMessageFormat("control plane request passed authentication:{}").setArguments(request));
                            return true;
                        }
                        catch (Throwable throwable) {
                            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setHttpRequest(request).setMessageFormat("exception validating client certificate:{}against control plane trust store certificate:{}").setArguments(clientCertificateInformation, caCertificateInformation).setThrowable(throwable));
                        }
                    }
                }
                throw new AuthenticationException("control plane request failed authentication no client certificates can be validated by control plane CA");
            }
            throw new AuthenticationException("control plane request failed authentication no client certificates found");
        }
        throw new AuthenticationException("control plane request failed authentication no control plane CA specified");
    }

    private String getClientCertificateInformation(String serialNumber, String issuerDistinguishedName, String subjectDistinguishedName) {
        try {
            return ObjectMapperFactory.createObjectMapper(true, new JsonSerializer[0]).writeValueAsString((Object)ImmutableMap.of((Object)"serialNumber", (Object)serialNumber, (Object)"issuerDistinguishedName", (Object)issuerDistinguishedName, (Object)"subjectDistinguishedName", (Object)subjectDistinguishedName));
        }
        catch (Throwable throwable) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("exception serialising certificate information").setThrowable(throwable));
            return "";
        }
    }
}

