/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.MatchDifference;
import org.mockserver.model.NottableString;

public class ExactStringMatcher
extends BodyMatcher<NottableString> {
    private static final String[] excludedFields = new String[]{"mockServerLogger"};
    private final MockServerLogger mockServerLogger;
    private final NottableString matcher;

    ExactStringMatcher(MockServerLogger mockServerLogger, NottableString matcher) {
        this.mockServerLogger = mockServerLogger;
        this.matcher = matcher;
    }

    public static boolean matches(String matcher, String matched, boolean ignoreCase) {
        if (StringUtils.isBlank((CharSequence)matcher)) {
            return true;
        }
        if (matched != null) {
            if (matched.equals(matcher)) {
                return true;
            }
            if (ignoreCase) {
                return matched.equalsIgnoreCase(matcher);
            }
        }
        return false;
    }

    @Override
    public boolean matches(MatchDifference context, String matched) {
        return this.matches(context, NottableString.string(matched));
    }

    @Override
    public boolean matches(MatchDifference context, NottableString matched) {
        boolean result = false;
        if (ExactStringMatcher.matches(this.matcher.getValue(), matched.getValue(), false)) {
            result = true;
        }
        if (!result && context != null) {
            context.addDifference(this.mockServerLogger, "exact string match failed expected:{}found:{}", this.matcher, matched);
        }
        return matched.isNot() == (this.matcher.isNot() == (this.not != result));
    }

    @Override
    public boolean isBlank() {
        return this.matcher == null || StringUtils.isBlank((CharSequence)this.matcher.getValue());
    }

    @Override
    @JsonIgnore
    public String[] fieldsExcludedFromEqualsAndHashCode() {
        return excludedFields;
    }
}

