/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.character.Character;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.OpenAPIDefinition;
import org.mockserver.model.RequestDefinition;
import org.mockserver.serialization.JsonArraySerializer;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.Serializer;
import org.mockserver.serialization.model.HttpRequestDTO;
import org.mockserver.serialization.model.HttpRequestPrettyPrintedDTO;
import org.mockserver.serialization.model.OpenAPIDefinitionDTO;
import org.mockserver.serialization.model.RequestDefinitionDTO;
import org.mockserver.validator.jsonschema.JsonSchemaRequestDefinitionValidator;
import org.mockserver.validator.jsonschema.JsonSchemaValidator;
import org.slf4j.event.Level;

public class RequestDefinitionSerializer
implements Serializer<RequestDefinition> {
    private final MockServerLogger mockServerLogger;
    private ObjectWriter objectWriter = ObjectMapperFactory.createObjectMapper(true, new JsonSerializer[0]);
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
    private JsonArraySerializer jsonArraySerializer = new JsonArraySerializer();
    private JsonSchemaRequestDefinitionValidator requestDefinitionValidator;

    public RequestDefinitionSerializer(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
    }

    private JsonSchemaRequestDefinitionValidator getValidator() {
        if (this.requestDefinitionValidator == null) {
            this.requestDefinitionValidator = JsonSchemaRequestDefinitionValidator.jsonSchemaRequestDefinitionValidator(this.mockServerLogger);
        }
        return this.requestDefinitionValidator;
    }

    @Override
    public String serialize(RequestDefinition requestDefinition) {
        return this.serialize(false, requestDefinition);
    }

    public String serialize(boolean prettyPrint, RequestDefinition requestDefinition) {
        try {
            if (requestDefinition instanceof HttpRequest) {
                return this.objectWriter.writeValueAsString((Object)(prettyPrint ? new HttpRequestPrettyPrintedDTO((HttpRequest)requestDefinition) : new HttpRequestDTO((HttpRequest)requestDefinition)));
            }
            if (requestDefinition instanceof OpenAPIDefinition) {
                return this.objectWriter.writeValueAsString((Object)new OpenAPIDefinitionDTO((OpenAPIDefinition)requestDefinition));
            }
            return "";
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while serializing RequestDefinition to JSON with value " + requestDefinition).setThrowable(e));
            throw new RuntimeException("Exception while serializing RequestDefinition to JSON with value " + requestDefinition, e);
        }
    }

    @Override
    public String serialize(List<? extends RequestDefinition> requestDefinitions) {
        return this.serialize(false, requestDefinitions);
    }

    public String serialize(boolean prettyPrint, List<? extends RequestDefinition> requestDefinitions) {
        return this.serialize(prettyPrint, requestDefinitions.toArray(new RequestDefinition[0]));
    }

    @Override
    public String serialize(RequestDefinition ... requestDefinitions) {
        return this.serialize(false, requestDefinitions);
    }

    public String serialize(boolean prettyPrint, RequestDefinition ... requestDefinitions) {
        try {
            if (requestDefinitions != null && requestDefinitions.length > 0) {
                Object[] requestDefinitionDTOs = new Object[requestDefinitions.length];
                for (int i = 0; i < requestDefinitions.length; ++i) {
                    if (requestDefinitions[i] instanceof HttpRequest) {
                        requestDefinitionDTOs[i] = prettyPrint ? new HttpRequestPrettyPrintedDTO((HttpRequest)requestDefinitions[i]) : new HttpRequestDTO((HttpRequest)requestDefinitions[i]);
                        continue;
                    }
                    if (!(requestDefinitions[i] instanceof OpenAPIDefinition)) continue;
                    requestDefinitionDTOs[i] = new OpenAPIDefinitionDTO((OpenAPIDefinition)requestDefinitions[i]);
                }
                return this.objectWriter.writeValueAsString((Object)requestDefinitionDTOs);
            }
            return "[]";
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while serializing RequestDefinition to JSON with value " + Arrays.asList(requestDefinitions)).setThrowable(e));
            throw new RuntimeException("Exception while serializing RequestDefinition to JSON with value " + Arrays.asList(requestDefinitions), e);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public RequestDefinition deserialize(String jsonRequestDefinition) {
        if (StringUtils.isBlank((CharSequence)jsonRequestDefinition)) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a request is required but value was \"" + jsonRequestDefinition + "\"" + Character.NEW_LINE + Character.NEW_LINE + JsonSchemaValidator.OPEN_API_SPECIFICATION_URL);
        }
        if (jsonRequestDefinition.contains("\"httpRequest\"")) {
            try {
                jsonNode = this.objectMapper.readTree(jsonRequestDefinition);
                if (!jsonNode.has("httpRequest")) ** GOTO lbl21
                jsonRequestDefinition = jsonNode.get("httpRequest").toString();
            }
            catch (Throwable throwable) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while parsing{}for RequestDefinition " + throwable.getMessage()).setArguments(new Object[]{jsonRequestDefinition}).setThrowable(throwable));
                throw new IllegalArgumentException("exception while parsing [" + jsonRequestDefinition + "] for RequestDefinition", throwable);
            }
        } else if (jsonRequestDefinition.contains("\"openAPIDefinition\"")) {
            try {
                jsonNode = this.objectMapper.readTree(jsonRequestDefinition);
                if (jsonNode.has("openAPIDefinition")) {
                    jsonRequestDefinition = jsonNode.get("openAPIDefinition").toString();
                }
            }
            catch (Throwable throwable) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while parsing{}for RequestDefinition " + throwable.getMessage()).setArguments(new Object[]{jsonRequestDefinition}).setThrowable(throwable));
                throw new IllegalArgumentException("exception while parsing [" + jsonRequestDefinition + "] for RequestDefinition", throwable);
            }
        }
lbl21:
        // 5 sources

        validationErrors = this.getValidator().isValid(jsonRequestDefinition);
        if (validationErrors.isEmpty()) {
            requestDefinition = null;
            try {
                requestDefinitionDTO = (RequestDefinitionDTO)this.objectMapper.readValue(jsonRequestDefinition, RequestDefinitionDTO.class);
                if (requestDefinitionDTO != null) {
                    requestDefinition = requestDefinitionDTO.buildObject();
                }
            }
            catch (Throwable throwable) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while parsing{}for RequestDefinition " + throwable.getMessage()).setArguments(new Object[]{jsonRequestDefinition}).setThrowable(throwable));
                throw new IllegalArgumentException("exception while parsing [" + jsonRequestDefinition + "] for RequestDefinition", throwable);
            }
            return requestDefinition;
        }
        throw new IllegalArgumentException(StringUtils.removeEndIgnoreCase((String)StringFormatter.formatLogMessage("incorrect request matcher json format for:{}schema validation errors:{}", new Object[]{jsonRequestDefinition, validationErrors}), (String)"\n"));
    }

    @Override
    public Class<RequestDefinition> supportsType() {
        return RequestDefinition.class;
    }

    public RequestDefinition[] deserializeArray(String jsonRequestDefinitions) {
        ArrayList<RequestDefinition> requestDefinitions = new ArrayList<RequestDefinition>();
        if (StringUtils.isBlank((CharSequence)jsonRequestDefinitions)) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a request or request array is required but value was \"" + jsonRequestDefinitions + "\"");
        }
        List<String> jsonRequestList = this.jsonArraySerializer.splitJSONArray(jsonRequestDefinitions);
        if (jsonRequestList.isEmpty()) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a request or array of request is required");
        }
        ArrayList<String> validationErrorsList = new ArrayList<String>();
        for (String jsonRequest : jsonRequestList) {
            try {
                requestDefinitions.add(this.deserialize(jsonRequest));
            }
            catch (IllegalArgumentException iae) {
                validationErrorsList.add(iae.getMessage());
            }
        }
        if (!validationErrorsList.isEmpty()) {
            throw new IllegalArgumentException((validationErrorsList.size() > 1 ? "[" : "") + Joiner.on((String)("," + Character.NEW_LINE)).join(validationErrorsList) + (validationErrorsList.size() > 1 ? "]" : ""));
        }
        return requestDefinitions.toArray(new RequestDefinition[0]);
    }
}

