/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.serializers.certificate;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.model.X509Certificate;

public class X509CertificateSerializer
extends StdSerializer<X509Certificate> {
    public X509CertificateSerializer() {
        super(X509Certificate.class);
    }

    public void serialize(X509Certificate x509Certificate, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        if (StringUtils.isNotBlank((CharSequence)x509Certificate.getSerialNumber())) {
            jgen.writeObjectField("serialNumber", (Object)x509Certificate.getSerialNumber());
        }
        if (StringUtils.isNotBlank((CharSequence)x509Certificate.getIssuerDistinguishedName())) {
            jgen.writeObjectField("issuerDistinguishedName", (Object)x509Certificate.getIssuerDistinguishedName());
        }
        if (StringUtils.isNotBlank((CharSequence)x509Certificate.getSubjectDistinguishedName())) {
            jgen.writeObjectField("subjectDistinguishedName", (Object)x509Certificate.getSubjectDistinguishedName());
        }
        if (StringUtils.isNotBlank((CharSequence)x509Certificate.getSignatureAlgorithmName())) {
            jgen.writeObjectField("signatureAlgorithmName", (Object)x509Certificate.getSignatureAlgorithmName());
        }
        jgen.writeEndObject();
    }
}

