/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.templates.engine.javascript;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Splitter;
import java.util.stream.StreamSupport;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import jdk.nashorn.api.scripting.ClassFilter;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.configuration.Configuration;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequest;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.model.DTO;
import org.mockserver.templates.engine.TemplateEngine;
import org.mockserver.templates.engine.TemplateFunctions;
import org.mockserver.templates.engine.javascript.bindings.ScriptBindings;
import org.mockserver.templates.engine.model.HttpRequestTemplateObject;
import org.mockserver.templates.engine.serializer.HttpTemplateOutputDeserializer;
import org.slf4j.event.Level;

public class JavaScriptTemplateEngine
implements TemplateEngine {
    private ScriptEngine engine;
    private ObjectMapper objectMapper;
    private final MockServerLogger mockServerLogger;
    private HttpTemplateOutputDeserializer httpTemplateOutputDeserializer;
    private final Configuration configuration;

    public JavaScriptTemplateEngine(MockServerLogger mockServerLogger, Configuration configuration) {
        System.setProperty("nashorn.args", "--language=es6");
        this.configuration = configuration == null ? Configuration.configuration() : configuration;
        this.engine = new NashornScriptEngineFactory().getScriptEngine((ClassFilter)new DisallowClassesInTemplates(configuration));
        this.mockServerLogger = mockServerLogger;
        this.httpTemplateOutputDeserializer = new HttpTemplateOutputDeserializer(mockServerLogger);
        this.objectMapper = ObjectMapperFactory.createObjectMapper();
    }

    @Override
    public <T> T executeTemplate(String template, HttpRequest request, Class<? extends DTO<T>> dtoClass) {
        T result;
        block7: {
            result = null;
            String script = JavaScriptTemplateEngine.wrapTemplate(template);
            try {
                this.validateTemplate(template);
                if (this.engine != null) {
                    JsonNode generatedObject;
                    Object stringifiedResponse;
                    block6: {
                        Compilable compilable = (Compilable)((Object)this.engine);
                        CompiledScript compiledScript = compilable.compile(script + " function serialise(request) { return JSON.stringify(handle(JSON.parse(request)), null, 2); }");
                        Bindings serialiseBindings = this.engine.createBindings();
                        this.engine.setBindings(new ScriptBindings(TemplateFunctions.BUILT_IN_FUNCTIONS), 100);
                        compiledScript.eval(serialiseBindings);
                        ScriptObjectMirror scriptObjectMirror = (ScriptObjectMirror)serialiseBindings.get("serialise");
                        stringifiedResponse = scriptObjectMirror.call(null, new Object[]{new HttpRequestTemplateObject(request)});
                        generatedObject = null;
                        try {
                            generatedObject = this.objectMapper.readTree(String.valueOf(stringifiedResponse));
                        }
                        catch (Throwable throwable) {
                            if (!MockServerLogger.isEnabled(Level.INFO)) break block6;
                            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.INFO).setHttpRequest(request).setMessageFormat("exception deserialising generated content:{}into json node for request:{}").setArguments(stringifiedResponse, request));
                        }
                    }
                    if (MockServerLogger.isEnabled(Level.INFO)) {
                        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.TEMPLATE_GENERATED).setLogLevel(Level.INFO).setHttpRequest(request).setMessageFormat("generated output:{}from template:{}for request:{}").setArguments(generatedObject != null ? generatedObject : stringifiedResponse, script, request));
                    }
                    result = this.httpTemplateOutputDeserializer.deserializer(request, (String)stringifiedResponse, dtoClass);
                    break block7;
                }
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setHttpRequest(request).setMessageFormat("JavaScript based templating is only available in a JVM with the \"nashorn\" JavaScript engine, please use a JVM with the \"nashorn\" JavaScript engine, such as Oracle Java 8+").setArguments(new RuntimeException("\"nashorn\" JavaScript engine not available")));
            }
            catch (Exception e) {
                throw new RuntimeException(StringFormatter.formatLogMessage("Exception:{}transforming template:{}for request:{}", StringUtils.isNotBlank((CharSequence)e.getMessage()) ? e.getMessage() : e.getClass().getSimpleName(), template, request), e);
            }
        }
        return result;
    }

    static String wrapTemplate(String template) {
        return "function handle(request) {" + StringFormatter.indentAndToString(template)[0] + "}";
    }

    private void validateTemplate(String template) {
        if (StringUtils.isNotBlank((CharSequence)template) && StringUtils.isNotBlank((CharSequence)this.configuration.javascriptDisallowedText())) {
            Iterable deniedStrings = Splitter.on((String)",").trimResults().split((CharSequence)this.configuration.javascriptDisallowedText());
            for (String deniedString : deniedStrings) {
                if (!template.contains(deniedString)) continue;
                throw new UnsupportedOperationException("Found disallowed string \"" + deniedString + "\" in template: " + template);
            }
        }
    }

    private static class DisallowClassesInTemplates
    implements ClassFilter {
        private Iterable<String> restrictedClassesList = null;
        private final Configuration configuration;

        private DisallowClassesInTemplates(Configuration configuration) {
            this.configuration = configuration;
            this.init();
        }

        void init() {
            this.restrictedClassesList = Splitter.on((String)",").trimResults().split((CharSequence)this.configuration.javascriptDisallowedClasses());
        }

        public boolean exposeToScripts(String className) {
            if (this.restrictedClassesList != null) {
                return StreamSupport.stream(this.restrictedClassesList.spliterator(), false).noneMatch(restrictedClass -> restrictedClass.equalsIgnoreCase(className));
            }
            return true;
        }
    }
}

