/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.logging;

import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.log.model.MessageLogEntry;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.model.HttpRequest;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class MockServerLogger {
    public static final MockServerLogger MOCK_SERVER_LOGGER = new MockServerLogger();
    private final boolean auditEnabled = !ConfigurationProperties.disableRequestAudit();
    private final boolean logEnabled = !ConfigurationProperties.disableSystemOut();
    private final Logger logger;
    private final HttpStateHandler httpStateHandler;

    public static void initialiseLogLevels() {
        try {
            MockServerLogger.setRootLogLevel("io.netty", System.getProperty("root.logLevel", "WARN"));
            MockServerLogger.setRootLogLevel("org.apache.velocity", System.getProperty("root.logLevel", "WARN"));
            MockServerLogger.setRootLogLevel("org.mockserver", System.getProperty("mockserver.logLevel", ConfigurationProperties.logLevel().name()));
        }
        catch (Throwable throwable) {
            LoggerFactory.getLogger(MockServerLogger.class).debug("exception while initialising log levels please include ch.qos.logback:logback-classic dependency to enable log file support", throwable);
        }
    }

    public static void setRootLogLevel(String name, String level) {
        try {
            Logger logger = LoggerFactory.getLogger((String)name);
            Class<?> loggerClass = Class.forName("ch.qos.logback.classic.Logger");
            Class<?> levelClass = Class.forName("ch.qos.logback.classic.Level");
            MethodHandles.publicLookup().findVirtual(loggerClass, "setLevel", MethodType.methodType(Void.TYPE, levelClass)).invoke(logger, MethodHandles.publicLookup().findStatic(levelClass, "valueOf", MethodType.methodType(levelClass, String.class)).invoke(level));
        }
        catch (Throwable throwable) {
            LoggerFactory.getLogger(MockServerLogger.class).debug("exception while setting log level for " + name + " please include ch.qos.logback:logback-classic dependency to enable log file support", throwable);
        }
    }

    private static void setLogbackAppender() {
        try {
            Logger mockServerLogger = LoggerFactory.getLogger((String)"org.mockserver");
            Class<?> loggerClass = Class.forName("ch.qos.logback.classic.Logger");
            if (mockServerLogger.getClass().isAssignableFrom(loggerClass)) {
                ILoggerFactory loggerContext = LoggerFactory.getILoggerFactory();
                Class<?> contextClass = Class.forName("ch.qos.logback.core.Context");
                Class<?> patternLayoutEncoderClass = Class.forName("ch.qos.logback.classic.encoder.PatternLayoutEncoder");
                Object patternLayoutEncoder = MethodHandles.publicLookup().findConstructor(patternLayoutEncoderClass, MethodType.methodType(Void.TYPE)).invoke();
                MethodHandles.publicLookup().findVirtual(patternLayoutEncoderClass, "setPattern", MethodType.methodType(Void.TYPE, String.class)).invoke(patternLayoutEncoder, "%date %level %logger{20} %msg%n");
                MethodHandles.publicLookup().findVirtual(patternLayoutEncoderClass, "setContext", MethodType.methodType(Void.TYPE, contextClass)).invoke(patternLayoutEncoder, contextClass.cast(loggerContext));
                MethodHandles.publicLookup().findVirtual(patternLayoutEncoderClass, "start", MethodType.methodType(Void.TYPE)).invoke(patternLayoutEncoder);
                String logDirectory = StringUtils.isBlank((CharSequence)System.getenv("log.dir")) ? "./" : StringUtils.appendIfMissingIgnoreCase((String)System.getenv("log.dir"), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
                String logFileName = "mockserver";
                String logFileExtension = "log";
                Class<?> sizeAndTimeBasedFNATPClass = Class.forName("ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP");
                Object sizeAndTimeBasedFNATP = MethodHandles.publicLookup().findConstructor(sizeAndTimeBasedFNATPClass, MethodType.methodType(Void.TYPE)).invoke();
                MethodHandles.publicLookup().findVirtual(sizeAndTimeBasedFNATPClass, "setMaxFileSize", MethodType.methodType(Void.TYPE, String.class)).invoke(sizeAndTimeBasedFNATP, "100MB");
                MethodHandles.publicLookup().findVirtual(sizeAndTimeBasedFNATPClass, "setContext", MethodType.methodType(Void.TYPE, contextClass)).invoke(sizeAndTimeBasedFNATP, contextClass.cast(loggerContext));
                Class<?> timeBasedRollingPolicyClass = Class.forName("ch.qos.logback.core.rolling.TimeBasedRollingPolicy");
                Object timeBasedRollingPolicy = MethodHandles.publicLookup().findConstructor(timeBasedRollingPolicyClass, MethodType.methodType(Void.TYPE)).invoke();
                MethodHandles.publicLookup().findVirtual(timeBasedRollingPolicyClass, "setFileNamePattern", MethodType.methodType(Void.TYPE, String.class)).invoke(timeBasedRollingPolicy, logDirectory + logFileName + ".%d{yyyy-MM-dd}.%i." + logFileExtension);
                Class<?> timeBasedFileNamingAndTriggeringPolicyClass = Class.forName("ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy");
                MethodHandles.publicLookup().findVirtual(timeBasedRollingPolicyClass, "setTimeBasedFileNamingAndTriggeringPolicy", MethodType.methodType(Void.TYPE, timeBasedFileNamingAndTriggeringPolicyClass)).invoke(timeBasedRollingPolicy, timeBasedFileNamingAndTriggeringPolicyClass.cast(sizeAndTimeBasedFNATP));
                MethodHandles.publicLookup().findVirtual(timeBasedRollingPolicyClass, "setMaxHistory", MethodType.methodType(Void.TYPE, Integer.TYPE)).invoke(timeBasedRollingPolicy, 1);
                MethodHandles.publicLookup().findVirtual(timeBasedRollingPolicyClass, "setContext", MethodType.methodType(Void.TYPE, contextClass)).invoke(timeBasedRollingPolicy, contextClass.cast(loggerContext));
                Class<?> rollingFileAppenderClass = Class.forName("ch.qos.logback.core.rolling.RollingFileAppender");
                Object rollingFileAppender = MethodHandles.publicLookup().findConstructor(rollingFileAppenderClass, MethodType.methodType(Void.TYPE)).invoke();
                MethodHandles.publicLookup().findVirtual(rollingFileAppenderClass, "setFile", MethodType.methodType(Void.TYPE, String.class)).invoke(rollingFileAppender, logDirectory + logFileName + "." + logFileExtension);
                Class<?> encoderClass = Class.forName("ch.qos.logback.core.encoder.Encoder");
                MethodHandles.publicLookup().findVirtual(rollingFileAppenderClass, "setEncoder", MethodType.methodType(Void.TYPE, encoderClass)).invoke(rollingFileAppender, encoderClass.cast(patternLayoutEncoder));
                MethodHandles.publicLookup().findVirtual(rollingFileAppenderClass, "setContext", MethodType.methodType(Void.TYPE, contextClass)).invoke(rollingFileAppender, contextClass.cast(loggerContext));
                Class<?> fileAppenderClass = Class.forName("ch.qos.logback.core.FileAppender");
                MethodHandles.publicLookup().findVirtual(timeBasedRollingPolicyClass, "setParent", MethodType.methodType(Void.TYPE, fileAppenderClass)).invoke(timeBasedRollingPolicy, fileAppenderClass.cast(rollingFileAppender));
                Class<?> rollingPolicyClass = Class.forName("ch.qos.logback.core.rolling.RollingPolicy");
                MethodHandles.publicLookup().findVirtual(rollingFileAppenderClass, "setRollingPolicy", MethodType.methodType(Void.TYPE, rollingPolicyClass)).invoke(rollingFileAppender, rollingPolicyClass.cast(timeBasedRollingPolicy));
                MethodHandles.publicLookup().findVirtual(timeBasedRollingPolicyClass, "start", MethodType.methodType(Void.TYPE)).invoke(timeBasedRollingPolicy);
                MethodHandles.publicLookup().findVirtual(sizeAndTimeBasedFNATPClass, "start", MethodType.methodType(Void.TYPE)).invoke(sizeAndTimeBasedFNATP);
                MethodHandles.publicLookup().findVirtual(rollingFileAppenderClass, "start", MethodType.methodType(Void.TYPE)).invoke(rollingFileAppender);
                Class<?> asyncAppenderClass = Class.forName("ch.qos.logback.classic.AsyncAppender");
                Object asyncFileAppender = MethodHandles.publicLookup().findConstructor(asyncAppenderClass, MethodType.methodType(Void.TYPE)).invoke();
                MethodHandles.publicLookup().findVirtual(asyncAppenderClass, "setContext", MethodType.methodType(Void.TYPE, contextClass)).invoke(asyncFileAppender, contextClass.cast(loggerContext));
                MethodHandles.publicLookup().findVirtual(asyncAppenderClass, "setQueueSize", MethodType.methodType(Void.TYPE, Integer.TYPE)).invoke(asyncFileAppender, 250);
                MethodHandles.publicLookup().findVirtual(asyncAppenderClass, "setDiscardingThreshold", MethodType.methodType(Void.TYPE, Integer.TYPE)).invoke(asyncFileAppender, 0);
                Class<?> appenderClass = Class.forName("ch.qos.logback.core.Appender");
                MethodHandles.publicLookup().findVirtual(asyncAppenderClass, "addAppender", MethodType.methodType(Void.TYPE, appenderClass)).invoke(asyncFileAppender, appenderClass.cast(rollingFileAppender));
                MethodHandles.publicLookup().findVirtual(asyncAppenderClass, "start", MethodType.methodType(Void.TYPE)).invoke(asyncFileAppender);
                Class<?> consoleAppenderClass = Class.forName("ch.qos.logback.core.ConsoleAppender");
                Object consoleAppender = MethodHandles.publicLookup().findConstructor(consoleAppenderClass, MethodType.methodType(Void.TYPE)).invoke();
                MethodHandles.publicLookup().findVirtual(consoleAppenderClass, "setTarget", MethodType.methodType(Void.TYPE, String.class)).invoke(consoleAppender, "System.out");
                MethodHandles.publicLookup().findVirtual(consoleAppenderClass, "setEncoder", MethodType.methodType(Void.TYPE, encoderClass)).invoke(consoleAppender, encoderClass.cast(patternLayoutEncoder));
                MethodHandles.publicLookup().findVirtual(consoleAppenderClass, "setContext", MethodType.methodType(Void.TYPE, contextClass)).invoke(consoleAppender, contextClass.cast(loggerContext));
                MethodHandles.publicLookup().findVirtual(consoleAppenderClass, "start", MethodType.methodType(Void.TYPE)).invoke(consoleAppender);
                Object asyncConsoleAppender = MethodHandles.publicLookup().findConstructor(asyncAppenderClass, MethodType.methodType(Void.TYPE)).invoke();
                MethodHandles.publicLookup().findVirtual(asyncAppenderClass, "setContext", MethodType.methodType(Void.TYPE, contextClass)).invoke(asyncConsoleAppender, contextClass.cast(loggerContext));
                MethodHandles.publicLookup().findVirtual(asyncAppenderClass, "setQueueSize", MethodType.methodType(Void.TYPE, Integer.TYPE)).invoke(asyncConsoleAppender, 250);
                MethodHandles.publicLookup().findVirtual(asyncAppenderClass, "setDiscardingThreshold", MethodType.methodType(Void.TYPE, Integer.TYPE)).invoke(asyncConsoleAppender, 0);
                MethodHandles.publicLookup().findVirtual(asyncAppenderClass, "addAppender", MethodType.methodType(Void.TYPE, appenderClass)).invoke(asyncConsoleAppender, appenderClass.cast(consoleAppender));
                MethodHandles.publicLookup().findVirtual(asyncAppenderClass, "start", MethodType.methodType(Void.TYPE)).invoke(asyncConsoleAppender);
                Class<?> levelClass = Class.forName("ch.qos.logback.classic.Level");
                Object level = MethodHandles.publicLookup().findStatic(levelClass, "valueOf", MethodType.methodType(levelClass, String.class)).invoke(System.getProperty("mockserver.logLevel", ConfigurationProperties.logLevel().name()));
                MethodHandles.publicLookup().findVirtual(loggerClass, "setLevel", MethodType.methodType(Void.TYPE, levelClass)).invoke(mockServerLogger, level);
                MethodHandles.publicLookup().findVirtual(loggerClass, "addAppender", MethodType.methodType(Void.TYPE, appenderClass)).invoke(mockServerLogger, appenderClass.cast(asyncFileAppender));
                MethodHandles.publicLookup().findVirtual(loggerClass, "addAppender", MethodType.methodType(Void.TYPE, appenderClass)).invoke(mockServerLogger, appenderClass.cast(asyncConsoleAppender));
            }
        }
        catch (Throwable throwable) {
            LoggerFactory.getLogger(MockServerLogger.class).debug("exception while initialising log file please include ch.qos.logback:logback-classic dependency to enable log file support", throwable);
        }
    }

    public MockServerLogger() {
        this(MockServerLogger.class);
    }

    public MockServerLogger(Class loggerClass) {
        this(LoggerFactory.getLogger((Class)loggerClass), null);
    }

    public MockServerLogger(Logger logger, @Nullable HttpStateHandler httpStateHandler) {
        this.logger = logger;
        this.httpStateHandler = httpStateHandler;
    }

    public void trace(String message, Object ... arguments) {
        this.trace(null, message, arguments);
    }

    public void trace(HttpRequest request, String message, Object ... arguments) {
        if (this.isEnabled(Level.TRACE)) {
            this.addLogEvents(MessageLogEntry.LogMessageType.TRACE, Level.TRACE, request, message, arguments);
            String logMessage = StringFormatter.formatLogMessage(message, arguments);
            if (this.logEnabled) {
                this.logger.trace(logMessage);
            }
        }
    }

    public void debug(MessageLogEntry.LogMessageType type, String message, Object ... arguments) {
        this.debug(type, null, message, arguments);
    }

    public void debug(MessageLogEntry.LogMessageType type, HttpRequest request, String message, Object ... arguments) {
        if (this.isEnabled(Level.DEBUG)) {
            this.addLogEvents(type, Level.DEBUG, request, message, arguments);
            String logMessage = StringFormatter.formatLogMessage(message, arguments);
            if (this.logEnabled) {
                this.logger.debug(logMessage);
            }
        }
    }

    public void info(MessageLogEntry.LogMessageType type, String message, Object ... arguments) {
        this.info(type, (HttpRequest)null, message, arguments);
    }

    public void info(MessageLogEntry.LogMessageType type, HttpRequest request, String message, Object ... arguments) {
        this.info(type, (List<HttpRequest>)ImmutableList.of((Object)(request != null ? request : HttpRequest.request())), message, arguments);
    }

    public void info(MessageLogEntry.LogMessageType type, List<HttpRequest> requests, String message, Object ... arguments) {
        if (this.isEnabled(Level.INFO)) {
            this.addLogEvents(type, Level.INFO, requests, message, arguments);
            String logMessage = StringFormatter.formatLogMessage(message, arguments);
            if (this.logEnabled) {
                this.logger.info(logMessage);
            }
        }
    }

    public void warn(String message) {
        this.warn((HttpRequest)null, message, new Object[0]);
    }

    public void warn(String message, Object ... arguments) {
        this.warn(null, message, arguments);
    }

    public void warn(@Nullable HttpRequest request, String message, Object ... arguments) {
        if (this.isEnabled(Level.WARN)) {
            this.addLogEvents(MessageLogEntry.LogMessageType.WARN, Level.WARN, request, message, arguments);
            String logMessage = StringFormatter.formatLogMessage(message, arguments);
            if (this.logEnabled) {
                this.logger.error(logMessage);
            }
        }
    }

    public void error(String message, Throwable throwable) {
        this.error((HttpRequest)null, throwable, message, new Object[0]);
    }

    public void error(String message, Object ... arguments) {
        this.error(null, message, arguments);
    }

    public void error(@Nullable HttpRequest request, String message, Object ... arguments) {
        this.error(request, null, message, arguments);
    }

    public void error(@Nullable HttpRequest request, Throwable throwable, String message, Object ... arguments) {
        this.error((List<HttpRequest>)ImmutableList.of((Object)(request != null ? request : HttpRequest.request())), throwable, message, arguments);
    }

    public void error(List<HttpRequest> requests, Throwable throwable, String message, Object ... arguments) {
        if (this.isEnabled(Level.ERROR)) {
            this.addLogEvents(MessageLogEntry.LogMessageType.EXCEPTION, Level.ERROR, requests, message, arguments);
            String logMessage = StringFormatter.formatLogMessage(message, arguments);
            if (this.logEnabled) {
                this.logger.error(logMessage, throwable);
            }
        }
    }

    private void addLogEvents(MessageLogEntry.LogMessageType type, Level logLeveL, @Nullable HttpRequest request, String message, Object ... arguments) {
        if (this.auditEnabled && this.httpStateHandler != null) {
            this.httpStateHandler.log(new MessageLogEntry(type, logLeveL, request, message, arguments));
        }
    }

    private void addLogEvents(MessageLogEntry.LogMessageType type, Level logLeveL, List<HttpRequest> requests, String message, Object ... arguments) {
        if (this.auditEnabled && this.httpStateHandler != null) {
            this.httpStateHandler.log(new MessageLogEntry(type, logLeveL, requests, message, arguments));
        }
    }

    public boolean isEnabled(Level level) {
        return level.toInt() >= ConfigurationProperties.logLevel().toInt();
    }

    static {
        MockServerLogger.initialiseLogLevels();
        MockServerLogger.setLogbackAppender();
    }
}

