/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import org.mockserver.character.Character;
import org.mockserver.log.model.MessageLogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mappers.ContentTypeMapper;
import org.mockserver.matchers.BinaryMatcher;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.BooleanMatcher;
import org.mockserver.matchers.ExactStringMatcher;
import org.mockserver.matchers.HashMapMatcher;
import org.mockserver.matchers.JsonPathMatcher;
import org.mockserver.matchers.JsonSchemaMatcher;
import org.mockserver.matchers.JsonStringMatcher;
import org.mockserver.matchers.Matcher;
import org.mockserver.matchers.MultiValueMapMatcher;
import org.mockserver.matchers.NotMatcher;
import org.mockserver.matchers.ParameterStringMatcher;
import org.mockserver.matchers.RegexStringMatcher;
import org.mockserver.matchers.SubStringMatcher;
import org.mockserver.matchers.XPathMatcher;
import org.mockserver.matchers.XmlSchemaMatcher;
import org.mockserver.matchers.XmlStringMatcher;
import org.mockserver.mock.Expectation;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Body;
import org.mockserver.model.Cookies;
import org.mockserver.model.Headers;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.JsonBody;
import org.mockserver.model.JsonPathBody;
import org.mockserver.model.JsonSchemaBody;
import org.mockserver.model.NottableString;
import org.mockserver.model.ParameterBody;
import org.mockserver.model.Parameters;
import org.mockserver.model.RegexBody;
import org.mockserver.model.StringBody;
import org.mockserver.model.XPathBody;
import org.mockserver.model.XmlBody;
import org.mockserver.model.XmlSchemaBody;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.model.BinaryBodyDTO;
import org.mockserver.serialization.model.BodyDTO;
import org.mockserver.serialization.model.JsonBodyDTO;
import org.mockserver.serialization.model.JsonPathBodyDTO;
import org.mockserver.serialization.model.JsonSchemaBodyDTO;
import org.mockserver.serialization.model.ParameterBodyDTO;
import org.mockserver.serialization.model.RegexBodyDTO;
import org.mockserver.serialization.model.StringBodyDTO;
import org.mockserver.serialization.model.XPathBodyDTO;
import org.mockserver.serialization.model.XmlBodyDTO;
import org.mockserver.serialization.model.XmlSchemaBodyDTO;

public class HttpRequestMatcher
extends NotMatcher<HttpRequest> {
    private static final String[] excludedFields = new String[]{"mockServerLogger", "objectMapper"};
    private MockServerLogger mockServerLogger;
    private Expectation expectation;
    private HttpRequest httpRequest;
    private RegexStringMatcher methodMatcher = null;
    private RegexStringMatcher pathMatcher = null;
    private MultiValueMapMatcher queryStringParameterMatcher = null;
    private BodyMatcher bodyMatcher = null;
    private MultiValueMapMatcher headerMatcher = null;
    private HashMapMatcher cookieMatcher = null;
    private BooleanMatcher keepAliveMatcher = null;
    private BodyDTO bodyDTOMatcher = null;
    private BooleanMatcher sslMatcher = null;
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();

    public HttpRequestMatcher(HttpRequest httpRequest, MockServerLogger mockServerLogger) {
        this.httpRequest = httpRequest;
        this.mockServerLogger = mockServerLogger;
        if (httpRequest != null) {
            this.withMethod(httpRequest.getMethod());
            this.withPath(httpRequest.getPath());
            this.withQueryStringParameters(httpRequest.getQueryStringParameters());
            this.withBody(httpRequest.getBody());
            this.withHeaders(httpRequest.getHeaders());
            this.withCookies(httpRequest.getCookies());
            this.withKeepAlive(httpRequest.isKeepAlive());
            this.withSsl(httpRequest.isSecure());
        }
    }

    public HttpRequestMatcher(Expectation expectation, MockServerLogger mockServerLogger) {
        this.expectation = expectation;
        this.httpRequest = expectation.getHttpRequest();
        this.mockServerLogger = mockServerLogger;
        if (this.httpRequest != null) {
            this.withMethod(this.httpRequest.getMethod());
            this.withPath(this.httpRequest.getPath());
            this.withQueryStringParameters(this.httpRequest.getQueryStringParameters());
            this.withBody(this.httpRequest.getBody());
            this.withHeaders(this.httpRequest.getHeaders());
            this.withCookies(this.httpRequest.getCookies());
            this.withKeepAlive(this.httpRequest.isKeepAlive());
            this.withSsl(this.httpRequest.isSecure());
        }
    }

    public Expectation getExpectation() {
        return this.expectation;
    }

    private void withMethod(NottableString method) {
        this.methodMatcher = new RegexStringMatcher(this.mockServerLogger, method);
    }

    private void withPath(NottableString path) {
        this.pathMatcher = new RegexStringMatcher(this.mockServerLogger, path);
    }

    private void withQueryStringParameters(Parameters parameters) {
        this.queryStringParameterMatcher = new MultiValueMapMatcher(this.mockServerLogger, parameters);
    }

    private void withBody(Body body) {
        if (body != null) {
            switch (body.getType()) {
                case STRING: {
                    StringBody stringBody = (StringBody)body;
                    this.bodyDTOMatcher = new StringBodyDTO(stringBody);
                    if (stringBody.isSubString()) {
                        this.bodyMatcher = new SubStringMatcher(this.mockServerLogger, NottableString.string(stringBody.getValue(), stringBody.getNot()));
                        break;
                    }
                    this.bodyMatcher = new ExactStringMatcher(this.mockServerLogger, NottableString.string(stringBody.getValue(), stringBody.getNot()));
                    break;
                }
                case REGEX: {
                    RegexBody regexBody = (RegexBody)body;
                    this.bodyDTOMatcher = new RegexBodyDTO(regexBody);
                    this.bodyMatcher = new RegexStringMatcher(this.mockServerLogger, NottableString.string(regexBody.getValue(), regexBody.getNot()));
                    break;
                }
                case PARAMETERS: {
                    ParameterBody parameterBody = (ParameterBody)body;
                    this.bodyDTOMatcher = new ParameterBodyDTO(parameterBody);
                    this.bodyMatcher = new ParameterStringMatcher(this.mockServerLogger, parameterBody.getValue());
                    break;
                }
                case XPATH: {
                    XPathBody xPathBody = (XPathBody)body;
                    this.bodyDTOMatcher = new XPathBodyDTO(xPathBody);
                    this.bodyMatcher = new XPathMatcher(this.mockServerLogger, xPathBody.getValue());
                    break;
                }
                case XML: {
                    XmlBody xmlBody = (XmlBody)body;
                    this.bodyDTOMatcher = new XmlBodyDTO(xmlBody);
                    this.bodyMatcher = new XmlStringMatcher(this.mockServerLogger, xmlBody.getValue());
                    break;
                }
                case JSON: {
                    JsonBody jsonBody = (JsonBody)body;
                    this.bodyDTOMatcher = new JsonBodyDTO(jsonBody);
                    this.bodyMatcher = new JsonStringMatcher(this.mockServerLogger, jsonBody.getValue(), jsonBody.getMatchType());
                    break;
                }
                case JSON_SCHEMA: {
                    JsonSchemaBody jsonSchemaBody = (JsonSchemaBody)body;
                    this.bodyDTOMatcher = new JsonSchemaBodyDTO(jsonSchemaBody);
                    this.bodyMatcher = new JsonSchemaMatcher(this.mockServerLogger, jsonSchemaBody.getValue());
                    break;
                }
                case JSON_PATH: {
                    JsonPathBody jsonPathBody = (JsonPathBody)body;
                    this.bodyDTOMatcher = new JsonPathBodyDTO(jsonPathBody);
                    this.bodyMatcher = new JsonPathMatcher(this.mockServerLogger, jsonPathBody.getValue());
                    break;
                }
                case XML_SCHEMA: {
                    XmlSchemaBody xmlSchemaBody = (XmlSchemaBody)body;
                    this.bodyDTOMatcher = new XmlSchemaBodyDTO(xmlSchemaBody);
                    this.bodyMatcher = new XmlSchemaMatcher(this.mockServerLogger, xmlSchemaBody.getValue());
                    break;
                }
                case BINARY: {
                    BinaryBody binaryBody = (BinaryBody)body;
                    this.bodyDTOMatcher = new BinaryBodyDTO(binaryBody);
                    this.bodyMatcher = new BinaryMatcher(this.mockServerLogger, binaryBody.getValue());
                }
            }
            if (body.isNot()) {
                this.bodyMatcher = HttpRequestMatcher.not(this.bodyMatcher);
            }
        }
    }

    private void withHeaders(Headers headers) {
        this.headerMatcher = new MultiValueMapMatcher(this.mockServerLogger, headers);
    }

    private void withCookies(Cookies cookies) {
        this.cookieMatcher = new HashMapMatcher(this.mockServerLogger, cookies);
    }

    private void withKeepAlive(Boolean keepAlive) {
        this.keepAliveMatcher = new BooleanMatcher(this.mockServerLogger, keepAlive);
    }

    private void withSsl(Boolean isSsl) {
        this.sslMatcher = new BooleanMatcher(this.mockServerLogger, isSsl);
    }

    @Override
    public boolean matches(HttpRequest context, HttpRequest request) {
        return this.matches(context, request, true);
    }

    public boolean matches(HttpRequest request) {
        return this.matches(null, request, false);
    }

    private boolean matches(HttpRequest context, HttpRequest request, boolean logMatchResults) {
        boolean matches = false;
        if (this.isActive()) {
            if (request == this.httpRequest) {
                matches = true;
            } else if (this.httpRequest == null) {
                matches = true;
            } else if (request != null) {
                boolean totalResultAfterNotOperatorApplied;
                boolean methodMatches = Strings.isNullOrEmpty((String)request.getMethod().getValue()) || this.matches(context, this.methodMatcher, request.getMethod());
                boolean pathMatches = Strings.isNullOrEmpty((String)request.getPath().getValue()) || this.matches(context, this.pathMatcher, request.getPath());
                boolean queryStringParametersMatches = this.matches(context, this.queryStringParameterMatcher, request.getQueryStringParameters());
                boolean bodyMatches = this.bodyMatches(context, request);
                boolean headersMatch = this.matches(context, this.headerMatcher, request.getHeaders());
                boolean cookiesMatch = this.matches(context, this.cookieMatcher, request.getCookies());
                boolean keepAliveMatches = this.matches(context, this.keepAliveMatcher, request.isKeepAlive());
                boolean sslMatches = this.matches(context, this.sslMatcher, request.isSecure());
                boolean totalResult = methodMatches && pathMatches && queryStringParametersMatches && bodyMatches && headersMatch && cookiesMatch && keepAliveMatches && sslMatches;
                boolean bl = totalResultAfterNotOperatorApplied = request.isNot() == (this.httpRequest.isNot() == (this.not != totalResult));
                if (logMatchResults) {
                    if (!totalResultAfterNotOperatorApplied) {
                        StringBuilder becauseBuilder = new StringBuilder();
                        becauseBuilder.append("method ").append(methodMatches ? "matched" : "didn't match");
                        becauseBuilder.append(",").append(Character.NEW_LINE).append("path ").append(pathMatches ? "matched" : "didn't match");
                        becauseBuilder.append(",").append(Character.NEW_LINE).append("query ").append(queryStringParametersMatches ? "matched" : "didn't match");
                        becauseBuilder.append(",").append(Character.NEW_LINE).append("body ").append(bodyMatches ? "matched" : "didn't match");
                        becauseBuilder.append(",").append(Character.NEW_LINE).append("headers ").append(headersMatch ? "matched" : "didn't match");
                        becauseBuilder.append(",").append(Character.NEW_LINE).append("cookies ").append(cookiesMatch ? "matched" : "didn't match");
                        becauseBuilder.append(",").append(Character.NEW_LINE).append("keep-alive ").append(keepAliveMatches ? "matched" : "didn't match");
                        becauseBuilder.append(",").append(Character.NEW_LINE).append("ssl ").append(sslMatches ? "matched" : "didn't match");
                        if (request.isNot()) {
                            becauseBuilder.append(",").append(Character.NEW_LINE).append("request 'not' operator is enabled");
                        }
                        if (this.httpRequest.isNot()) {
                            becauseBuilder.append(",").append(Character.NEW_LINE).append("expectation's request 'not' operator is enabled");
                        }
                        if (this.not) {
                            becauseBuilder.append(",").append(Character.NEW_LINE).append("expectation's request matcher 'not' operator is enabled");
                        }
                        this.mockServerLogger.info(MessageLogEntry.LogMessageType.EXPECTATION_NOT_MATCHED, request, "request:{}" + (totalResult ? "matched " : "didn't match ") + (this.expectation == null ? "request" : "expectation") + ":{}because:{}", request, this.expectation == null ? this : this.expectation.clone(), becauseBuilder.toString());
                    } else {
                        this.mockServerLogger.info(MessageLogEntry.LogMessageType.EXPECTATION_MATCHED, request, "request:{}matched " + (this.expectation == null ? "request" : "expectation") + ":{}", request, this.expectation == null ? this : this.expectation.clone());
                    }
                }
                matches = totalResultAfterNotOperatorApplied;
            }
        }
        return matches;
    }

    private boolean bodyMatches(HttpRequest context, HttpRequest request) {
        String bodyAsString;
        boolean bodyMatches = true;
        String string = bodyAsString = request.getBody() != null ? new String(request.getBody().getRawBytes(), request.getBody().getCharset(ContentTypeMapper.DEFAULT_HTTP_CHARACTER_SET)) : "";
        if (!bodyAsString.isEmpty() && !(bodyMatches = this.bodyMatcher instanceof BinaryMatcher ? this.matches(context, this.bodyMatcher, request.getBodyAsRawBytes()) : (this.bodyMatcher instanceof ExactStringMatcher || this.bodyMatcher instanceof SubStringMatcher || this.bodyMatcher instanceof RegexStringMatcher || this.bodyMatcher instanceof XmlStringMatcher ? this.matches(context, this.bodyMatcher, NottableString.string(bodyAsString)) : this.matches(context, this.bodyMatcher, bodyAsString)))) {
            try {
                bodyMatches = this.bodyDTOMatcher.equals(this.objectMapper.readValue(bodyAsString, BodyDTO.class));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return bodyMatches;
    }

    private <T> boolean matches(HttpRequest context, Matcher<T> matcher, T t) {
        boolean result = false;
        if (matcher == null) {
            result = true;
        } else if (matcher.matches(context, t)) {
            result = true;
        }
        return result;
    }

    public boolean isActive() {
        return this.expectation == null || this.expectation.isActive();
    }

    public Expectation decrementRemainingMatches() {
        return this.expectation.decrementRemainingMatches();
    }

    @Override
    public String toString() {
        try {
            return ObjectMapperFactory.createObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.httpRequest);
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    @JsonIgnore
    public String[] fieldsExcludedFromEqualsAndHashCode() {
        return excludedFields;
    }
}

