/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Strings;
import java.util.regex.PatternSyntaxException;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.NottableString;

public class RegexStringMatcher
extends BodyMatcher<NottableString> {
    private static final String[] excludedFields = new String[]{"mockServerLogger"};
    private final MockServerLogger mockServerLogger;
    private final NottableString matcher;

    public RegexStringMatcher(MockServerLogger mockServerLogger, String matcher) {
        this.mockServerLogger = mockServerLogger;
        this.matcher = NottableString.string(matcher);
    }

    public RegexStringMatcher(MockServerLogger mockServerLogger, NottableString matcher) {
        this.mockServerLogger = mockServerLogger;
        this.matcher = matcher;
    }

    public static boolean matches(NottableString matcher, NottableString matched, boolean ignoreCase) {
        if (matcher.isNot() && matched.isNot()) {
            return RegexStringMatcher.matches(matcher.getValue(), matched.getValue(), ignoreCase);
        }
        return (matcher.isNot() || matched.isNot()) ^ RegexStringMatcher.matches(matcher.getValue(), matched.getValue(), ignoreCase);
    }

    public static boolean matches(String matcher, String matched, boolean ignoreCase) {
        boolean result = false;
        if (Strings.isNullOrEmpty((String)matcher)) {
            result = true;
        } else if (matched != null) {
            if (matched.equals(matcher)) {
                result = true;
            }
            if (!result) {
                try {
                    if (matched.matches(matcher)) {
                        result = true;
                    }
                }
                catch (PatternSyntaxException pse) {
                    MockServerLogger.MOCK_SERVER_LOGGER.trace("Error while matching regex [" + matcher + "] for string [" + matched + "] " + pse.getMessage(), new Object[0]);
                }
                try {
                    if (matcher.matches(matched)) {
                        result = true;
                    }
                }
                catch (PatternSyntaxException pse) {
                    MockServerLogger.MOCK_SERVER_LOGGER.trace("Error while matching regex [" + matched + "] for string [" + matcher + "] " + pse.getMessage(), new Object[0]);
                }
                if (!result && ignoreCase) {
                    if (matched.equalsIgnoreCase(matcher)) {
                        result = true;
                    }
                    try {
                        if (matched.toLowerCase().matches(matcher.toLowerCase())) {
                            result = true;
                        }
                    }
                    catch (PatternSyntaxException pse) {
                        MockServerLogger.MOCK_SERVER_LOGGER.trace("Error while matching regex [" + matcher.toLowerCase() + "] for string [" + matched.toLowerCase() + "] " + pse.getMessage(), new Object[0]);
                    }
                    try {
                        if (matcher.toLowerCase().matches(matched.toLowerCase())) {
                            result = true;
                        }
                    }
                    catch (PatternSyntaxException pse) {
                        MockServerLogger.MOCK_SERVER_LOGGER.trace("Error while matching regex [" + matched.toLowerCase() + "] for string [" + matcher.toLowerCase() + "] " + pse.getMessage(), new Object[0]);
                    }
                }
            }
        }
        return result;
    }

    public boolean matches(String matched) {
        return this.matches((HttpRequest)null, NottableString.string(matched));
    }

    @Override
    public boolean matches(HttpRequest context, NottableString matched) {
        boolean result = false;
        if (RegexStringMatcher.matches(this.matcher.getValue(), matched.getValue(), false)) {
            result = true;
        }
        if (!result) {
            this.mockServerLogger.trace(context, "Failed to match [{}] with [{}]", matched, this.matcher);
        }
        return matched.isNot() != (this.matcher.isNot() != (this.not != result));
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return excludedFields;
    }
}

