/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock.action;

import java.util.UUID;
import org.mockserver.callback.WebSocketClientRegistry;
import org.mockserver.callback.WebSocketResponseCallback;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.mock.action.ActionHandler;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.responsewriter.ResponseWriter;

public class HttpResponseObjectCallbackActionHandler {
    private WebSocketClientRegistry webSocketClientRegistry;

    public HttpResponseObjectCallbackActionHandler(HttpStateHandler httpStateHandler) {
        this.webSocketClientRegistry = httpStateHandler.getWebSocketClientRegistry();
    }

    public void handle(final ActionHandler actionHandler, final HttpObjectCallback httpObjectCallback, final HttpRequest request, final ResponseWriter responseWriter, final boolean synchronous) {
        String clientId = httpObjectCallback.getClientId();
        final String webSocketCorrelationId = UUID.randomUUID().toString();
        this.webSocketClientRegistry.registerResponseCallbackHandler(webSocketCorrelationId, new WebSocketResponseCallback(){

            @Override
            public void handle(HttpResponse response) {
                HttpResponseObjectCallbackActionHandler.this.webSocketClientRegistry.unregisterResponseCallbackHandler(webSocketCorrelationId);
                actionHandler.writeResponseActionResponse(response.removeHeader("WebSocketCorrelationId"), responseWriter, request, httpObjectCallback, synchronous);
            }
        });
        this.webSocketClientRegistry.sendClientMessage(clientId, request.clone().withHeader("WebSocketCorrelationId", webSocketCorrelationId));
    }
}

