/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.net.MediaType;
import java.nio.charset.Charset;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mappers.ContentTypeMapper;
import org.mockserver.matchers.MatchType;
import org.mockserver.model.Body;
import org.mockserver.model.BodyWithContentType;
import org.mockserver.serialization.ObjectMapperFactory;

public class JsonBody
extends BodyWithContentType {
    public static final MatchType DEFAULT_MATCH_TYPE = MatchType.ONLY_MATCHING_FIELDS;
    public static final MediaType DEFAULT_CONTENT_TYPE = MediaType.create((String)"application", (String)"json");
    private final String json;
    private final byte[] rawBinaryData;
    private final MatchType matchType;

    public JsonBody(String json) {
        this(json, DEFAULT_CONTENT_TYPE, DEFAULT_MATCH_TYPE);
    }

    public JsonBody(String json, MatchType matchType) {
        this(json, MediaType.create((String)"application", (String)"json"), matchType);
    }

    public JsonBody(String json, Charset charset, MatchType matchType) {
        this(json, charset != null ? MediaType.create((String)"application", (String)"json").withCharset(charset) : null, matchType);
    }

    public JsonBody(String json, MediaType contentType, MatchType matchType) {
        super(Body.Type.JSON, contentType);
        this.json = json;
        this.matchType = matchType;
        this.rawBinaryData = json != null ? json.getBytes(this.determineCharacterSet(contentType, ContentTypeMapper.DEFAULT_HTTP_CHARACTER_SET)) : new byte[0];
    }

    public static JsonBody json(String json) {
        return new JsonBody(json);
    }

    public static JsonBody json(String json, MatchType matchType) {
        return new JsonBody(json, matchType);
    }

    public static JsonBody json(String json, Charset charset) {
        return new JsonBody(json, charset, DEFAULT_MATCH_TYPE);
    }

    public static JsonBody json(String json, Charset charset, MatchType matchType) {
        return new JsonBody(json, charset, matchType);
    }

    public static JsonBody json(String json, MediaType contentType) {
        return new JsonBody(json, contentType, DEFAULT_MATCH_TYPE);
    }

    public static JsonBody json(String json, MediaType contentType, MatchType matchType) {
        return new JsonBody(json, contentType, matchType);
    }

    private static String toJson(Object object) {
        String json = "";
        try {
            json = ObjectMapperFactory.createObjectMapper().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            new MockServerLogger(JsonBody.class).error("error mapping object for json body to JSON", e);
        }
        return json;
    }

    public static JsonBody json(Object object) {
        return new JsonBody(JsonBody.toJson(object));
    }

    public static JsonBody json(Object object, MatchType matchType) {
        return new JsonBody(JsonBody.toJson(object), matchType);
    }

    public static JsonBody json(Object object, Charset charset) {
        return new JsonBody(JsonBody.toJson(object), charset, DEFAULT_MATCH_TYPE);
    }

    public static JsonBody json(Object object, Charset charset, MatchType matchType) {
        return new JsonBody(JsonBody.toJson(object), charset, matchType);
    }

    public static JsonBody json(Object object, MediaType contentType) {
        return new JsonBody(JsonBody.toJson(object), contentType, DEFAULT_MATCH_TYPE);
    }

    public static JsonBody json(Object object, MediaType contentType, MatchType matchType) {
        return new JsonBody(JsonBody.toJson(object), contentType, matchType);
    }

    public String getValue() {
        return this.json;
    }

    @Override
    public byte[] getRawBytes() {
        return this.rawBinaryData;
    }

    public MatchType getMatchType() {
        return this.matchType;
    }

    @Override
    public String toString() {
        return this.json;
    }
}

