/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization;

import java.nio.charset.StandardCharsets;
import javax.xml.bind.DatatypeConverter;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;

public class Base64Converter
extends ObjectWithReflectiveEqualsHashCodeToString {
    private static final String BASE64_PATTERN = "^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$";

    public byte[] base64StringToBytes(String data) {
        if (data == null) {
            return new byte[0];
        }
        if (!data.matches(BASE64_PATTERN)) {
            return data.getBytes(StandardCharsets.UTF_8);
        }
        return DatatypeConverter.parseBase64Binary((String)data);
    }

    public String bytesToBase64String(byte[] data) {
        return DatatypeConverter.printBase64Binary((byte[])data);
    }
}

