/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.curl;

import com.google.common.base.Strings;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.codec.mappers.MockServerHttpRequestToFullHttpRequest;
import org.mockserver.model.Cookie;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.NottableString;

public class HttpRequestToCurlSerializer {
    public String toCurl(HttpRequest request) {
        return this.toCurl(request, null);
    }

    public String toCurl(HttpRequest request, @Nullable InetSocketAddress remoteAddress) {
        StringBuilder curlString = new StringBuilder();
        if (request != null) {
            if (!Strings.isNullOrEmpty((String)request.getFirstHeader(HttpHeaderNames.HOST.toString())) || remoteAddress != null) {
                boolean isSsl = request.isSecure() != null && request.isSecure() != false;
                curlString.append("curl -v");
                curlString.append(" ");
                curlString.append("'");
                curlString.append(isSsl ? "https" : "http");
                curlString.append("://");
                curlString.append(this.getHostAndPort(request, remoteAddress));
                curlString.append(this.getUri(request));
                curlString.append("'");
                if (!this.hasDefaultMethod(request)) {
                    curlString.append(" -X ").append(request.getMethod().getValue());
                }
                for (Header header : request.getHeaderList()) {
                    for (NottableString headerValue : header.getValues()) {
                        curlString.append(" -H '").append(header.getName().getValue()).append(": ").append(headerValue.getValue()).append("'");
                        if (!header.getName().getValue().toLowerCase().contains("Accept-Encoding".toLowerCase()) || !headerValue.getValue().toLowerCase().contains("gzip") && !headerValue.getValue().toLowerCase().contains("deflate") && !headerValue.getValue().toLowerCase().contains("sdch")) continue;
                        curlString.append(" ");
                        curlString.append("--compress");
                    }
                }
                curlString.append(this.getCookieHeader(request));
                if (!Strings.isNullOrEmpty((String)request.getBodyAsString())) {
                    curlString.append(" --data '").append(request.getBodyAsString().replace("'", "\\'")).append("'");
                }
            } else {
                curlString.append("no host header or remote address specified");
            }
        } else {
            curlString.append("null HttpRequest");
        }
        return curlString.toString();
    }

    private boolean hasDefaultMethod(HttpRequest request) {
        return Strings.isNullOrEmpty((String)request.getMethod().getValue()) || request.getMethod().getValue().equalsIgnoreCase("GET");
    }

    private String getUri(HttpRequest request) {
        String uri = new MockServerHttpRequestToFullHttpRequest().getURI(request);
        if (Strings.isNullOrEmpty((String)uri)) {
            uri = "/";
        } else if (!StringUtils.startsWith((CharSequence)uri, (CharSequence)"/")) {
            uri = "/" + uri;
        }
        return uri;
    }

    private String getHostAndPort(HttpRequest request, InetSocketAddress remoteAddress) {
        String host = request.getFirstHeader("Host");
        if (Strings.isNullOrEmpty((String)host)) {
            host = remoteAddress.getHostName() + ":" + remoteAddress.getPort();
        }
        return host;
    }

    private String getCookieHeader(HttpRequest request) {
        ArrayList<DefaultCookie> cookies = new ArrayList<DefaultCookie>();
        for (Cookie cookie : request.getCookieList()) {
            cookies.add(new DefaultCookie(cookie.getName().getValue(), cookie.getValue().getValue()));
        }
        if (cookies.size() > 0) {
            return " -H '" + HttpHeaderNames.COOKIE + ": " + ClientCookieEncoder.LAX.encode(cookies) + "'";
        }
        return "";
    }
}

