/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.java;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.List;
import org.mockserver.character.Character;
import org.mockserver.model.Cookie;
import org.mockserver.serialization.java.MultiValueToJavaSerializer;
import org.mockserver.serialization.java.NottableStringToJavaSerializer;

public class CookieToJavaSerializer
implements MultiValueToJavaSerializer<Cookie> {
    @Override
    public String serialize(int numberOfSpacesToIndent, Cookie cookie) {
        return Character.NEW_LINE + Strings.padStart((String)"", (int)(numberOfSpacesToIndent * 8), (char)' ') + "new Cookie(" + NottableStringToJavaSerializer.serializeNottableString(cookie.getName()) + ", " + NottableStringToJavaSerializer.serializeNottableString(cookie.getValue()) + ")";
    }

    @Override
    public String serializeAsJava(int numberOfSpacesToIndent, List<Cookie> cookies) {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < cookies.size(); ++i) {
            output.append(this.serialize(numberOfSpacesToIndent, cookies.get(i)));
            if (i >= cookies.size() - 1) continue;
            output.append(",");
        }
        return output.toString();
    }

    public String serializeAsJava(int numberOfSpacesToIndent, Cookie ... object) {
        return this.serializeAsJava(numberOfSpacesToIndent, Arrays.asList(object));
    }
}

