/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.java;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.List;
import org.mockserver.character.Character;
import org.mockserver.model.NottableString;
import org.mockserver.model.Parameter;
import org.mockserver.serialization.java.MultiValueToJavaSerializer;
import org.mockserver.serialization.java.NottableStringToJavaSerializer;

public class ParameterToJavaSerializer
implements MultiValueToJavaSerializer<Parameter> {
    @Override
    public String serialize(int numberOfSpacesToIndent, Parameter parameter) {
        StringBuilder output = new StringBuilder();
        output.append(Character.NEW_LINE).append(Strings.padStart((String)"", (int)(numberOfSpacesToIndent * 8), (char)' '));
        output.append("new Parameter(").append(NottableStringToJavaSerializer.serializeNottableString(parameter.getName()));
        for (NottableString value : parameter.getValues()) {
            output.append(", ").append(NottableStringToJavaSerializer.serializeNottableString(value));
        }
        output.append(")");
        return output.toString();
    }

    @Override
    public String serializeAsJava(int numberOfSpacesToIndent, List<Parameter> parameters) {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < parameters.size(); ++i) {
            output.append(this.serialize(numberOfSpacesToIndent, parameters.get(i)));
            if (i >= parameters.size() - 1) continue;
            output.append(",");
        }
        return output.toString();
    }

    public String serializeAsJava(int numberOfSpacesToIndent, Parameter ... object) {
        return this.serializeAsJava(numberOfSpacesToIndent, Arrays.asList(object));
    }
}

