/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.socket.tls;

import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.log.model.MessageLogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.socket.tls.KeyAndCertificateFactory;

public class KeyStoreFactory {
    public static final String KEY_STORE_PASSWORD = "changeit";
    public static final String CERTIFICATE_DOMAIN = "localhost";
    public static final String KEY_STORE_CERT_ALIAS = "mockserver-client-cert";
    private static final MockServerLogger MOCK_SERVER_LOGGER = new MockServerLogger(KeyStoreFactory.class);
    private static final String KEY_STORE_CA_ALIAS = "mockserver-ca-cert";
    private static final String SSL_CONTEXT_PROTOCOL = "TLSv1.2";
    private static final String SSL_CONTEXT_FALLBACK_PROTOCOL = "TLSv1";
    private static final KeyStoreFactory SSL_FACTORY = new KeyStoreFactory();
    private static SSLContext sslContext;

    private KeyStoreFactory() {
    }

    public static KeyStoreFactory keyStoreFactory() {
        return SSL_FACTORY;
    }

    public static String defaultKeyStoreFileName() {
        if ("jks".equalsIgnoreCase(ConfigurationProperties.javaKeyStoreType())) {
            return "mockserver_keystore.jks";
        }
        if ("pkcs12".equalsIgnoreCase(ConfigurationProperties.javaKeyStoreType())) {
            return "mockserver_keystore.p12";
        }
        if ("jceks".equalsIgnoreCase(ConfigurationProperties.javaKeyStoreType())) {
            return "mockserver_keystore.jceks";
        }
        throw new IllegalArgumentException(ConfigurationProperties.javaKeyStoreType() + " is not a supported keystore type");
    }

    private static KeyStore saveCertificateAsKeyStore(KeyStore existingKeyStore, boolean deleteOnExit, String keyStoreFileName, String certificationAlias, Key privateKey, char[] keyStorePassword, Certificate[] chain, X509Certificate caCert) {
        try {
            KeyStore keyStore = existingKeyStore;
            if (keyStore == null) {
                keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(null, keyStorePassword);
            }
            try {
                keyStore.deleteEntry(certificationAlias);
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
            keyStore.setKeyEntry(certificationAlias, privateKey, keyStorePassword, chain);
            try {
                keyStore.deleteEntry(KEY_STORE_CA_ALIAS);
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
            keyStore.setCertificateEntry(KEY_STORE_CA_ALIAS, caCert);
            String keyStoreFileAbsolutePath = new File(keyStoreFileName).getAbsolutePath();
            try (FileOutputStream fileOutputStream = new FileOutputStream(keyStoreFileAbsolutePath);){
                keyStore.store(fileOutputStream, keyStorePassword);
                MOCK_SERVER_LOGGER.trace("Saving key store to file [" + keyStoreFileAbsolutePath + "]", new Object[0]);
            }
            if (deleteOnExit) {
                new File(keyStoreFileAbsolutePath).deleteOnExit();
            }
            return keyStore;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while saving KeyStore", e);
        }
    }

    public synchronized SSLContext sslContext() {
        if (sslContext == null || ConfigurationProperties.rebuildKeyStore()) {
            try {
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(this.loadOrCreateKeyStore(), ConfigurationProperties.javaKeyStorePassword().toCharArray());
                sslContext = this.getSSLContextInstance();
                sslContext.init(keyManagerFactory.getKeyManagers(), InsecureTrustManagerFactory.INSTANCE.getTrustManagers(), null);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize the SSLContext", e);
            }
        }
        return sslContext;
    }

    private SSLContext getSSLContextInstance() throws NoSuchAlgorithmException {
        try {
            MOCK_SERVER_LOGGER.debug(MessageLogEntry.LogMessageType.SERVER_CONFIGURATION, "Using protocol {}", SSL_CONTEXT_PROTOCOL);
            return SSLContext.getInstance(SSL_CONTEXT_PROTOCOL);
        }
        catch (NoSuchAlgorithmException e) {
            MOCK_SERVER_LOGGER.warn("Protocol {} not available, falling back to {}", SSL_CONTEXT_PROTOCOL, SSL_CONTEXT_FALLBACK_PROTOCOL);
            return SSLContext.getInstance(SSL_CONTEXT_FALLBACK_PROTOCOL);
        }
    }

    public KeyStore loadOrCreateKeyStore() {
        KeyStore keystore = null;
        File keyStoreFile = new File(ConfigurationProperties.javaKeyStoreFilePath());
        if (keyStoreFile.exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(keyStoreFile);){
                keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                keystore.load(fileInputStream, ConfigurationProperties.javaKeyStorePassword().toCharArray());
            }
            catch (Exception e) {
                throw new RuntimeException("Exception while loading KeyStore from " + keyStoreFile.getAbsolutePath(), e);
            }
        }
        System.setProperty("javax.net.ssl.trustStore", keyStoreFile.getAbsolutePath());
        ConfigurationProperties.rebuildKeyStore(false);
        return this.populateKeyStore(keystore);
    }

    private KeyStore populateKeyStore(KeyStore keyStore) {
        KeyAndCertificateFactory.keyAndCertificateFactory().buildAndSaveCertificates();
        return KeyStoreFactory.saveCertificateAsKeyStore(keyStore, ConfigurationProperties.deleteGeneratedKeyStoreOnExit(), ConfigurationProperties.javaKeyStoreFilePath(), KEY_STORE_CERT_ALIAS, KeyAndCertificateFactory.keyAndCertificateFactory().mockServerPrivateKey(), ConfigurationProperties.javaKeyStorePassword().toCharArray(), new X509Certificate[]{KeyAndCertificateFactory.keyAndCertificateFactory().mockServerX509Certificate(), KeyAndCertificateFactory.keyAndCertificateFactory().mockServerCertificateAuthorityX509Certificate()}, KeyAndCertificateFactory.keyAndCertificateFactory().mockServerCertificateAuthorityX509Certificate());
    }
}

