/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.maven;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.slf4j.event.Level;

public class MockServerPort {
    private static final MockServerLogger MOCK_SERVER_LOGGER = new MockServerLogger();

    public static List<Integer> mockServerPort() {
        String mockServerPort = System.getProperty("mockserver.mockServerPort");
        try {
            return MockServerPort.toList(mockServerPort);
        }
        catch (NumberFormatException nfe) {
            MOCK_SERVER_LOGGER.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("NumberFormatException converting mockserver.mockServerPort with value [" + mockServerPort + "]").setThrowable((Throwable)nfe));
            return Collections.emptyList();
        }
    }

    private static List<Integer> toList(String integers) {
        ArrayList<Integer> integerList = new ArrayList<Integer>();
        for (String integer : Splitter.on((String)",").split((CharSequence)integers)) {
            try {
                integerList.add(Integer.parseInt(integer.trim()));
            }
            catch (NumberFormatException throwable) {
                MOCK_SERVER_LOGGER.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("NumberFormatException converting " + integer + " to integer").setThrowable((Throwable)throwable));
            }
        }
        return integerList;
    }
}

