/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.netty;

import com.google.common.collect.ImmutableList;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.authentication.AuthenticationHandler;
import org.mockserver.authentication.ChainedAuthenticationHandler;
import org.mockserver.authentication.jwt.JWTAuthenticationHandler;
import org.mockserver.authentication.mtls.MTLSAuthenticationHandler;
import org.mockserver.configuration.Configuration;
import org.mockserver.lifecycle.ExpectationsListener;
import org.mockserver.lifecycle.LifeCycle;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.action.http.HttpActionHandler;
import org.mockserver.netty.HttpRequestHandler;
import org.mockserver.netty.MockServerUnificationInitializer;
import org.mockserver.proxyconfiguration.ProxyConfiguration;
import org.mockserver.socket.tls.NettySslContextFactory;
import org.slf4j.event.Level;

public class MockServer
extends LifeCycle {
    private InetSocketAddress remoteSocket;

    public MockServer(Integer ... localPorts) {
        this(null, (List<ProxyConfiguration>)ProxyConfiguration.proxyConfiguration((Configuration)Configuration.configuration()), localPorts);
    }

    public MockServer(Configuration configuration, Integer ... localPorts) {
        this(configuration, (List<ProxyConfiguration>)ProxyConfiguration.proxyConfiguration((Configuration)configuration), localPorts);
    }

    public MockServer(ProxyConfiguration proxyConfiguration, Integer ... localPorts) {
        this(null, (List<ProxyConfiguration>)ImmutableList.of((Object)proxyConfiguration), localPorts);
    }

    public MockServer(Configuration configuration, List<ProxyConfiguration> proxyConfigurations, Integer ... localPorts) {
        super(configuration);
        this.createServerBootstrap(configuration, proxyConfigurations, localPorts);
        this.getLocalPort();
    }

    public MockServer(Integer remotePort, @Nullable String remoteHost, Integer ... localPorts) {
        this(null, (List<ProxyConfiguration>)ProxyConfiguration.proxyConfiguration((Configuration)Configuration.configuration()), remoteHost, remotePort, localPorts);
    }

    public MockServer(Configuration configuration, Integer remotePort, @Nullable String remoteHost, Integer ... localPorts) {
        this(configuration, (List<ProxyConfiguration>)ProxyConfiguration.proxyConfiguration((Configuration)configuration), remoteHost, remotePort, localPorts);
    }

    public MockServer(Configuration configuration, ProxyConfiguration proxyConfiguration, @Nullable String remoteHost, Integer remotePort, Integer ... localPorts) {
        this(configuration, (List<ProxyConfiguration>)ImmutableList.of((Object)proxyConfiguration), remoteHost, remotePort, localPorts);
    }

    public MockServer(Configuration configuration, List<ProxyConfiguration> proxyConfigurations, @Nullable String remoteHost, Integer remotePort, Integer ... localPorts) {
        super(configuration);
        if (remotePort == null) {
            throw new IllegalArgumentException("You must specify a remote hostname");
        }
        if (StringUtils.isBlank((CharSequence)remoteHost)) {
            remoteHost = "localhost";
        }
        this.remoteSocket = new InetSocketAddress(remoteHost, (int)remotePort);
        if (proxyConfigurations != null && MockServerLogger.isEnabled((Level)Level.INFO)) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.SERVER_CONFIGURATION).setLogLevel(Level.INFO).setMessageFormat("using proxy configuration for forwarded requests:{}").setArguments(new Object[]{proxyConfigurations}));
        }
        this.createServerBootstrap(configuration, proxyConfigurations, localPorts);
        this.getLocalPort();
    }

    private void createServerBootstrap(Configuration configuration, List<ProxyConfiguration> proxyConfigurations, Integer ... localPorts) {
        if (configuration == null) {
            configuration = Configuration.configuration();
        }
        List<Integer> portBindings = Collections.singletonList(0);
        if (localPorts != null && localPorts.length > 0) {
            portBindings = Arrays.asList(localPorts);
        }
        NettySslContextFactory nettySslContextFactory = new NettySslContextFactory(configuration, this.mockServerLogger);
        if (configuration.controlPlaneTLSMutualAuthenticationRequired().booleanValue() && configuration.controlPlaneJWTAuthenticationRequired().booleanValue()) {
            this.httpState.setControlPlaneAuthenticationHandler((AuthenticationHandler)new ChainedAuthenticationHandler(new AuthenticationHandler[]{new MTLSAuthenticationHandler(this.mockServerLogger, nettySslContextFactory.trustCertificateChain(configuration.controlPlaneTLSMutualAuthenticationCAChain())), new JWTAuthenticationHandler(this.mockServerLogger, configuration.controlPlaneJWTAuthenticationJWKSource()).withExpectedAudience(configuration.controlPlaneJWTAuthenticationExpectedAudience()).withMatchingClaims(configuration.controlPlaneJWTAuthenticationMatchingClaims()).withRequiredClaims(configuration.controlPlaneJWTAuthenticationRequiredClaims())}));
        } else if (configuration.controlPlaneTLSMutualAuthenticationRequired().booleanValue()) {
            this.httpState.setControlPlaneAuthenticationHandler((AuthenticationHandler)new MTLSAuthenticationHandler(this.mockServerLogger, nettySslContextFactory.trustCertificateChain(configuration.controlPlaneTLSMutualAuthenticationCAChain())));
        } else if (configuration.controlPlaneJWTAuthenticationRequired().booleanValue()) {
            this.httpState.setControlPlaneAuthenticationHandler((AuthenticationHandler)new JWTAuthenticationHandler(this.mockServerLogger, configuration.controlPlaneJWTAuthenticationJWKSource()).withExpectedAudience(configuration.controlPlaneJWTAuthenticationExpectedAudience()).withMatchingClaims(configuration.controlPlaneJWTAuthenticationMatchingClaims()).withRequiredClaims(configuration.controlPlaneJWTAuthenticationRequiredClaims()));
        }
        this.serverServerBootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).option(ChannelOption.SO_BACKLOG, (Object)1024)).channel(NioServerSocketChannel.class)).childOption(ChannelOption.AUTO_READ, (Object)true).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(8192, 32768))).childHandler((ChannelHandler)new MockServerUnificationInitializer(configuration, this, this.httpState, new HttpActionHandler(configuration, this.getEventLoopGroup(), this.httpState, proxyConfigurations, nettySslContextFactory), nettySslContextFactory)).childAttr(HttpActionHandler.REMOTE_SOCKET, (Object)this.remoteSocket).childAttr(HttpRequestHandler.PROXYING, (Object)(this.remoteSocket != null ? 1 : 0));
        try {
            this.bindServerPorts(portBindings);
        }
        catch (Throwable throwable) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.SERVER_CONFIGURATION).setLogLevel(Level.ERROR).setMessageFormat("exception binding to port(s) " + portBindings).setThrowable(throwable));
            this.stop();
            throw throwable;
        }
        this.startedServer(this.getLocalPorts());
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteSocket;
    }

    @Override
    public MockServer registerListener(ExpectationsListener expectationsListener) {
        super.registerListener(expectationsListener);
        return this;
    }
}

