/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.bytebuddy;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.mockito.internal.creation.bytebuddy.StackTraceChecker;

class StackWalkerChecker
implements Predicate<Class<?>> {
    private final Method stackWalkerGetInstance;
    private final Method stackWalkerWalk;
    private final Method stackWalkerStackFrameGetDeclaringClass;
    private final Enum<?> stackWalkerOptionRetainClassReference;

    StackWalkerChecker() throws Exception {
        Class<?> stackWalker = Class.forName("java.lang.StackWalker");
        Class<?> stackWalkerOption = Class.forName("java.lang.StackWalker$Option");
        this.stackWalkerGetInstance = stackWalker.getMethod("getInstance", stackWalkerOption);
        this.stackWalkerWalk = stackWalker.getMethod("walk", Function.class);
        Class<?> stackWalkerStackFrame = Class.forName("java.lang.StackWalker$StackFrame");
        this.stackWalkerStackFrameGetDeclaringClass = stackWalkerStackFrame.getMethod("getDeclaringClass", new Class[0]);
        Object stackWalkerOptionRetainClassReference = Enum.valueOf(stackWalkerOption, "RETAIN_CLASS_REFERENCE");
        this.stackWalkerOptionRetainClassReference = stackWalkerOptionRetainClassReference;
    }

    static Predicate<Class<?>> orFallback() {
        try {
            return new StackWalkerChecker();
        }
        catch (Exception e) {
            return new StackTraceChecker();
        }
    }

    @Override
    public boolean test(Class<?> type) {
        try {
            Object walker = this.stackWalkerGetInstance.invoke(null, this.stackWalkerOptionRetainClassReference);
            return (Boolean)this.stackWalkerWalk.invoke(walker, stream -> {
                Iterator iterator = ((Stream)stream).iterator();
                while (iterator.hasNext()) {
                    try {
                        Object next;
                        Class declaringClass;
                        Object frame = iterator.next();
                        if (((Class)this.stackWalkerStackFrameGetDeclaringClass.invoke(frame, new Object[0])).getName().startsWith("org.mockito.internal.")) continue;
                        if (iterator.hasNext() && type != (declaringClass = (Class)this.stackWalkerStackFrameGetDeclaringClass.invoke(next = iterator.next(), new Object[0])) && type.isAssignableFrom(declaringClass)) {
                            return true;
                        }
                        break;
                    }
                    catch (Exception ignored) {
                        return false;
                    }
                }
                return false;
            });
        }
        catch (Exception ignored) {
            return false;
        }
    }
}

