/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification.checkers;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.invocation.InvocationsFinder;
import org.mockito.internal.reporting.SmartPrinter;
import org.mockito.internal.verification.api.InOrderContext;
import org.mockito.internal.verification.argumentmatching.ArgumentMatchingTool;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.Location;
import org.mockito.invocation.MatchableInvocation;

public class MissingInvocationChecker {
    private MissingInvocationChecker() {
    }

    public static void checkMissingInvocation(List<Invocation> invocations, MatchableInvocation wanted) {
        List<Invocation> actualInvocations = InvocationsFinder.findInvocations(invocations, wanted);
        if (!actualInvocations.isEmpty()) {
            return;
        }
        Invocation similar = InvocationsFinder.findSimilarInvocation(invocations, wanted);
        if (similar == null) {
            throw Reporter.wantedButNotInvoked(wanted, invocations);
        }
        Integer[] indexesOfSuspiciousArgs = ArgumentMatchingTool.getSuspiciouslyNotMatchingArgsIndexes(wanted.getMatchers(), similar.getArguments());
        Set<String> classesWithSameSimpleName = ArgumentMatchingTool.getNotMatchingArgsWithSameName(wanted.getMatchers(), similar.getArguments());
        SmartPrinter smartPrinter = new SmartPrinter(wanted, invocations, indexesOfSuspiciousArgs, classesWithSameSimpleName);
        List<Location> actualLocations = invocations.stream().map(Invocation::getLocation).collect(Collectors.toList());
        throw Reporter.argumentsAreDifferent(similar, wanted, smartPrinter.getWanted(), smartPrinter.getActuals(), actualLocations);
    }

    public static void checkMissingInvocation(List<Invocation> invocations, MatchableInvocation wanted, InOrderContext context) {
        List<Invocation> chunk = InvocationsFinder.findAllMatchingUnverifiedChunks(invocations, wanted, context);
        if (!chunk.isEmpty()) {
            return;
        }
        Invocation previousInOrder = InvocationsFinder.findPreviousVerifiedInOrder(invocations, context);
        if (previousInOrder != null) {
            throw Reporter.wantedButNotInvokedInOrder(wanted, previousInOrder);
        }
        MissingInvocationChecker.checkMissingInvocation(invocations, wanted);
    }
}

