/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.util;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.modeshape.common.annotation.Category;
import org.modeshape.common.annotation.Description;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.Label;
import org.modeshape.common.annotation.ReadOnly;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.text.Inflector;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.common.util.ObjectUtil;

@Immutable
public class Reflection {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final String[] BRACKETS_PAIR = new String[]{"", "[]", "[][]", "[][][]", "[][][][]", "[][][][][]"};
    private final Class<?> targetClass;
    private Map<String, LinkedList<Method>> methodMap = null;
    protected static final Inflector INFLECTOR = Inflector.getInstance();

    public static Class<?>[] buildArgumentClasses(Object ... arguments) {
        if (arguments == null || arguments.length == 0) {
            return EMPTY_CLASS_ARRAY;
        }
        Class[] result = new Class[arguments.length];
        int i = 0;
        for (Object argument : arguments) {
            result[i] = argument != null ? argument.getClass() : null;
        }
        return result;
    }

    public static List<Class<?>> buildArgumentClassList(Object ... arguments) {
        if (arguments == null || arguments.length == 0) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList(arguments.length);
        for (Object argument : arguments) {
            if (argument != null) {
                result.add(argument.getClass());
                continue;
            }
            result.add(null);
        }
        return result;
    }

    public static List<Class<?>> convertArgumentClassesToPrimitives(Class<?> ... arguments) {
        if (arguments == null || arguments.length == 0) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList(arguments.length);
        for (Class<Object> clazz : arguments) {
            if (clazz == Boolean.class) {
                clazz = Boolean.TYPE;
            } else if (clazz == Character.class) {
                clazz = Character.TYPE;
            } else if (clazz == Byte.class) {
                clazz = Byte.TYPE;
            } else if (clazz == Short.class) {
                clazz = Short.TYPE;
            } else if (clazz == Integer.class) {
                clazz = Integer.TYPE;
            } else if (clazz == Long.class) {
                clazz = Long.TYPE;
            } else if (clazz == Float.class) {
                clazz = Float.TYPE;
            } else if (clazz == Double.class) {
                clazz = Double.TYPE;
            } else if (clazz == Void.class) {
                clazz = Void.TYPE;
            }
            result.add(clazz);
        }
        return result;
    }

    public static String getClassName(Class<?> clazz) {
        String fullName = clazz.getName();
        int fullNameLength = fullName.length();
        for (int numArrayDimensions = 0; numArrayDimensions < fullNameLength; ++numArrayDimensions) {
            char c = fullName.charAt(numArrayDimensions);
            if (c == '[') continue;
            String name = null;
            switch (c) {
                case 'L': {
                    name = fullName.subSequence(numArrayDimensions + 1, fullNameLength).toString();
                    break;
                }
                case 'B': {
                    name = "byte";
                    break;
                }
                case 'C': {
                    name = "char";
                    break;
                }
                case 'D': {
                    name = "double";
                    break;
                }
                case 'F': {
                    name = "float";
                    break;
                }
                case 'I': {
                    name = "int";
                    break;
                }
                case 'J': {
                    name = "long";
                    break;
                }
                case 'S': {
                    name = "short";
                    break;
                }
                case 'Z': {
                    name = "boolean";
                    break;
                }
                case 'V': {
                    name = "void";
                    break;
                }
                default: {
                    name = fullName.subSequence(numArrayDimensions, fullNameLength).toString();
                }
            }
            if (numArrayDimensions == 0) {
                return name;
            }
            if (numArrayDimensions < BRACKETS_PAIR.length) {
                name = name + BRACKETS_PAIR[numArrayDimensions];
            } else {
                for (int i = 0; i < numArrayDimensions; ++i) {
                    name = name + BRACKETS_PAIR[1];
                }
            }
            return name;
        }
        return fullName;
    }

    public Reflection(Class<?> targetClass) {
        CheckArg.isNotNull(targetClass, "targetClass");
        this.targetClass = targetClass;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public Method[] findMethods(String methodName, boolean caseSensitive) {
        Pattern pattern = caseSensitive ? Pattern.compile(methodName) : Pattern.compile(methodName, 2);
        return this.findMethods(pattern);
    }

    public Method[] findMethods(Pattern methodNamePattern) {
        Method[] allMethods = this.targetClass.getMethods();
        ArrayList<Method> result = new ArrayList<Method>();
        for (int i = 0; i < allMethods.length; ++i) {
            Method m = allMethods[i];
            if (!methodNamePattern.matcher(m.getName()).matches()) continue;
            result.add(m);
        }
        return result.toArray(new Method[result.size()]);
    }

    public Method[] findGetterMethods() {
        Method[] allMethods = this.targetClass.getMethods();
        ArrayList<Method> result = new ArrayList<Method>();
        for (int i = 0; i < allMethods.length; ++i) {
            String name;
            Method m = allMethods[i];
            int numParams = m.getParameterTypes().length;
            if (numParams != 0 || (name = m.getName()).equals("getClass") || m.getReturnType() == Void.TYPE || !name.startsWith("get") && !name.startsWith("is") && !name.startsWith("are")) continue;
            result.add(m);
        }
        return result.toArray(new Method[result.size()]);
    }

    public String[] findGetterPropertyNames() {
        Method[] getters = this.findGetterMethods();
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < getters.length; ++i) {
            Method m = getters[i];
            String name = m.getName();
            String propertyName = null;
            if (name.startsWith("get") && name.length() > 3) {
                propertyName = name.substring(3);
            } else if (name.startsWith("is") && name.length() > 2) {
                propertyName = name.substring(2);
            } else if (name.startsWith("are") && name.length() > 3) {
                propertyName = name.substring(3);
            }
            if (propertyName == null) continue;
            propertyName = INFLECTOR.camelCase(INFLECTOR.underscore(propertyName, new char[0]), false, new char[0]);
            result.add(propertyName);
        }
        return result.toArray(new String[result.size()]);
    }

    public Method findFirstMethod(String methodName, boolean caseSensitive) {
        Pattern pattern = caseSensitive ? Pattern.compile(methodName) : Pattern.compile(methodName, 2);
        return this.findFirstMethod(pattern);
    }

    public Method findFirstMethod(Pattern methodNamePattern) {
        Method[] allMethods = this.targetClass.getMethods();
        for (int i = 0; i < allMethods.length; ++i) {
            Method m = allMethods[i];
            if (!methodNamePattern.matcher(m.getName()).matches()) continue;
            return m;
        }
        return null;
    }

    public Iterable<Method> findAllMethods(String methodName, boolean caseSensitive) {
        Pattern pattern = caseSensitive ? Pattern.compile(methodName) : Pattern.compile(methodName, 2);
        return this.findAllMethods(pattern);
    }

    public Iterable<Method> findAllMethods(Pattern methodNamePattern) {
        LinkedList<Method> methods = new LinkedList<Method>();
        Method[] allMethods = this.targetClass.getMethods();
        for (int i = 0; i < allMethods.length; ++i) {
            Method m = allMethods[i];
            if (!methodNamePattern.matcher(m.getName()).matches()) continue;
            methods.add(m);
        }
        return methods;
    }

    public Object invokeBestMethodOnTarget(String[] methodNames, final Object target, final Object ... arguments) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?>[] argumentClasses = Reflection.buildArgumentClasses(arguments);
        int remaining = methodNames.length;
        Object result = null;
        for (String methodName : methodNames) {
            --remaining;
            try {
                final Method method = this.findBestMethodWithSignature(methodName, argumentClasses);
                result = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        return method.invoke(target, arguments);
                    }
                });
                break;
            }
            catch (PrivilegedActionException pae) {
                if (pae.getException() instanceof IllegalAccessException) {
                    throw (IllegalAccessException)pae.getException();
                }
                if (pae.getException() instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)pae.getException();
                }
                if (!(pae.getException() instanceof InvocationTargetException)) continue;
                throw (InvocationTargetException)pae.getException();
            }
            catch (NoSuchMethodException e) {
                if (remaining != 0) continue;
                throw e;
            }
        }
        return result;
    }

    public Object invokeSetterMethodOnTarget(String javaPropertyName, Object target, Object argument) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String[] methodNamesArray = this.findMethodNames("set" + javaPropertyName);
        try {
            return this.invokeBestMethodOnTarget(methodNamesArray, target, argument);
        }
        catch (NoSuchMethodException e) {
            if (argument instanceof Object[]) {
                Object[] arrayArg;
                for (Object arrayValue : arrayArg = (Object[])argument) {
                    if (arrayValue == null) continue;
                    Class<?> arrayValueType = arrayValue.getClass();
                    Object typedArray = Array.newInstance(arrayValueType, arrayArg.length);
                    Object[] newArray = (Object[])typedArray;
                    for (int i = 0; i != arrayArg.length; ++i) {
                        newArray[i] = arrayArg[i];
                    }
                    try {
                        return this.invokeBestMethodOnTarget(methodNamesArray, target, typedArray);
                    }
                    catch (NoSuchMethodException e2) {
                        throw e;
                    }
                }
            }
            throw e;
        }
    }

    public Object invokeGetterMethodOnTarget(String javaPropertyName, Object target) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String[] methodNamesArray = this.findMethodNames("get" + javaPropertyName);
        if (methodNamesArray.length <= 0) {
            methodNamesArray = this.findMethodNames("is" + javaPropertyName);
        }
        if (methodNamesArray.length <= 0) {
            methodNamesArray = this.findMethodNames("are" + javaPropertyName);
        }
        return this.invokeBestMethodOnTarget(methodNamesArray, target, new Object[0]);
    }

    protected String[] findMethodNames(String methodName) {
        Method[] methods = this.findMethods(methodName, false);
        HashSet<String> methodNames = new HashSet<String>();
        for (Method method : methods) {
            String actualMethodName = method.getName();
            methodNames.add(actualMethodName);
        }
        return methodNames.toArray(new String[methodNames.size()]);
    }

    public Method findBestMethodOnTarget(String methodName, Object ... arguments) throws NoSuchMethodException, SecurityException {
        Class<?>[] argumentClasses = Reflection.buildArgumentClasses(arguments);
        return this.findBestMethodWithSignature(methodName, argumentClasses);
    }

    public Method findBestMethodWithSignature(String methodName, Class<?> ... argumentsClasses) throws NoSuchMethodException, SecurityException {
        return this.findBestMethodWithSignature(methodName, true, argumentsClasses);
    }

    public Method findBestMethodWithSignature(String methodName, boolean caseSensitive, Class<?> ... argumentsClasses) throws NoSuchMethodException, SecurityException {
        Class<?>[] classArgs = null;
        try {
            classArgs = argumentsClasses != null ? argumentsClasses : new Class[]{};
            Method result = this.targetClass.getMethod(methodName, classArgs);
            return result;
        }
        catch (NoSuchMethodException e) {
            List<Class<?>> argumentsClassList = Reflection.convertArgumentClassesToPrimitives(argumentsClasses);
            try {
                classArgs = argumentsClassList.toArray(new Class[argumentsClassList.size()]);
                Method result = this.targetClass.getMethod(methodName, classArgs);
                return result;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                LinkedList<Object> methodsWithSameName;
                if (this.methodMap == null) {
                    this.methodMap = new HashMap<String, LinkedList<Method>>();
                    Method[] methods = this.targetClass.getMethods();
                    for (int i = 0; i != methods.length; ++i) {
                        Method method = methods[i];
                        methodsWithSameName = this.methodMap.get(method.getName());
                        if (methodsWithSameName == null) {
                            methodsWithSameName = new LinkedList();
                            this.methodMap.put(method.getName(), methodsWithSameName);
                        }
                        methodsWithSameName.addFirst(method);
                    }
                }
                for (int j = 0; j != 2; ++j) {
                    if (caseSensitive) {
                        methodsWithSameName = this.methodMap.get(methodName);
                    } else {
                        methodsWithSameName = new LinkedList();
                        Pattern pattern = Pattern.compile(methodName, 2);
                        for (Map.Entry<String, LinkedList<Method>> entry : this.methodMap.entrySet()) {
                            if (!pattern.matcher(entry.getKey()).matches()) continue;
                            methodsWithSameName.addAll((Collection)entry.getValue());
                        }
                    }
                    if (methodsWithSameName == null) {
                        throw new NoSuchMethodException(methodName);
                    }
                    for (Method method : methodsWithSameName) {
                        Class<?>[] args = method.getParameterTypes();
                        if (args.length != argumentsClassList.size()) continue;
                        boolean allMatch = true;
                        for (int i = 0; i < args.length; ++i) {
                            Class<?> clazz = argumentsClassList.get(i);
                            if (clazz != null) {
                                Class<?> argClass = args[i];
                                if (argClass.isAssignableFrom(clazz) || argClass.isArray() && clazz.isArray() && argClass.getComponentType().isAssignableFrom(clazz.getComponentType())) continue;
                                allMatch = false;
                                i = args.length;
                                continue;
                            }
                            if (!args[i].isPrimitive()) continue;
                            allMatch = false;
                            i = args.length;
                        }
                        if (!allMatch) continue;
                        return method;
                    }
                }
                throw new NoSuchMethodException(methodName);
            }
        }
    }

    public Property getProperty(Object target, String propertyName, String label, String category, String description, Object ... allowedValues) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ReadOnly readOnlyAnnotation;
        Category cat;
        Label labelAnnotation;
        Description desc;
        CheckArg.isNotNull(target, "target");
        CheckArg.isNotEmpty(propertyName, "propertyName");
        Method[] setters = this.findMethods("set" + propertyName, false);
        boolean readOnly = setters.length < 1;
        Class type = Object.class;
        Method[] getters = this.findMethods("get" + propertyName, false);
        if (getters.length == 0) {
            getters = this.findMethods("is" + propertyName, false);
        }
        if (getters.length == 0) {
            getters = this.findMethods("are" + propertyName, false);
        }
        if (getters.length > 0) {
            type = getters[0].getReturnType();
        }
        boolean inferred = true;
        Field field = null;
        try {
            field = this.getField(this.targetClass, propertyName);
        }
        catch (NoSuchFieldException e) {
            // empty catch block
        }
        if (description == null && (desc = Reflection.getAnnotation(Description.class, field, getters, setters)) != null) {
            description = Reflection.localizedString(desc.i18n(), desc.value());
            inferred = false;
        }
        if (label == null && (labelAnnotation = Reflection.getAnnotation(Label.class, field, getters, setters)) != null) {
            label = Reflection.localizedString(labelAnnotation.i18n(), labelAnnotation.value());
            inferred = false;
        }
        if (category == null && (cat = Reflection.getAnnotation(Category.class, field, getters, setters)) != null) {
            category = Reflection.localizedString(cat.i18n(), cat.value());
            inferred = false;
        }
        if (!readOnly && (readOnlyAnnotation = Reflection.getAnnotation(ReadOnly.class, field, getters, setters)) != null) {
            readOnly = true;
            inferred = false;
        }
        Property property = new Property(propertyName, label, description, category, readOnly, type, allowedValues);
        property.setInferred(inferred);
        return property;
    }

    protected Field getField(Class<?> targetClass, String propertyName) throws NoSuchFieldException {
        Field field = null;
        try {
            field = targetClass.getDeclaredField(Inflector.getInstance().lowerCamelCase(propertyName, new char[0]));
        }
        catch (NoSuchFieldException e) {
            Class<?> clazz = targetClass.getSuperclass();
            if (clazz != null) {
                field = this.getField(clazz, propertyName);
            }
            throw e;
        }
        return field;
    }

    protected static <AnnotationType extends Annotation> AnnotationType getAnnotation(Class<AnnotationType> annotationType, Field field, Method[] getters, Method[] setters) {
        int i$;
        int len$;
        Method[] arr$;
        AnnotationType annotation = null;
        if (field != null) {
            annotation = field.getAnnotation(annotationType);
        }
        if (annotation == null && getters != null) {
            Method getter;
            arr$ = getters;
            len$ = arr$.length;
            for (i$ = 0; i$ < len$ && (annotation = (AnnotationType)(getter = arr$[i$]).getAnnotation(annotationType)) == null; ++i$) {
            }
        }
        if (annotation == null && setters != null) {
            Method setter;
            arr$ = setters;
            len$ = arr$.length;
            for (i$ = 0; i$ < len$ && (annotation = (AnnotationType)(setter = arr$[i$]).getAnnotation(annotationType)) == null; ++i$) {
            }
        }
        return annotation;
    }

    protected static String localizedString(Class<?> i18nClass, String id) {
        if (i18nClass != null && !Object.class.equals(i18nClass) && id != null) {
            try {
                Field i18nMsg = i18nClass.getDeclaredField(id);
                I18n msg = (I18n)i18nMsg.get(null);
                if (msg != null) {
                    return msg.text(new Object[0]);
                }
            }
            catch (SecurityException err) {
            }
            catch (NoSuchFieldException err) {
            }
            catch (IllegalArgumentException err) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return id;
    }

    public Property getProperty(Object target, String propertyName, String description) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        CheckArg.isNotNull(target, "target");
        CheckArg.isNotEmpty(propertyName, "propertyName");
        return this.getProperty(target, propertyName, null, null, description, new Object[0]);
    }

    public Property getProperty(Object target, String propertyName) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        CheckArg.isNotNull(target, "target");
        CheckArg.isNotEmpty(propertyName, "propertyName");
        return this.getProperty(target, propertyName, null, null, null, new Object[0]);
    }

    public List<Property> getAllPropertiesOn(Object target) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String[] propertyNames = this.findGetterPropertyNames();
        ArrayList<Property> results = new ArrayList<Property>(propertyNames.length);
        for (String propertyName : propertyNames) {
            Property prop = this.getProperty(target, propertyName);
            results.add(prop);
        }
        Collections.sort(results);
        return results;
    }

    public Map<String, Property> getAllPropertiesByNameOn(Object target) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String[] propertyNames = this.findGetterPropertyNames();
        HashMap<String, Property> results = new HashMap<String, Property>();
        for (String propertyName : propertyNames) {
            Property prop = this.getProperty(target, propertyName);
            results.put(prop.getName(), prop);
        }
        return results;
    }

    public void setProperty(Object target, Property property, Object value) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        CheckArg.isNotNull(target, "target");
        CheckArg.isNotNull(property, "property");
        CheckArg.isNotNull(property.getName(), "property.getName()");
        this.invokeSetterMethodOnTarget(property.getName(), target, value);
    }

    public Object getProperty(Object target, Property property) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        CheckArg.isNotNull(target, "target");
        CheckArg.isNotNull(property, "property");
        CheckArg.isNotNull(property.getName(), "property.getName()");
        return this.invokeGetterMethodOnTarget(property.getName(), target);
    }

    public String getPropertyAsString(Object target, Property property) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object value = this.getProperty(target, property);
        StringBuilder sb = new StringBuilder();
        this.writeObjectAsString(value, sb, false);
        return sb.toString();
    }

    protected void writeObjectAsString(Object obj, StringBuilder sb, boolean wrapWithBrackets) {
        if (obj == null) {
            sb.append("null");
            return;
        }
        if (obj.getClass().isArray()) {
            Object[] array = (Object[])obj;
            boolean first = true;
            if (wrapWithBrackets) {
                sb.append("[");
            }
            for (Object value : array) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                this.writeObjectAsString(value, sb, true);
            }
            if (wrapWithBrackets) {
                sb.append("]");
            }
            return;
        }
        sb.append(obj);
    }

    public static class Property
    implements Comparable<Property>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String name;
        private String label;
        private String description;
        private Object value;
        private Collection<?> allowedValues;
        private Class<?> type;
        private boolean readOnly;
        private String category;
        private boolean inferred;

        public Property() {
        }

        public Property(String name, String label, String description, boolean readOnly) {
            this(name, label, description, null, readOnly, null, new Object[0]);
        }

        public Property(String name, String label, String description, String category, boolean readOnly, Class<?> type, Object ... allowedValues) {
            this.setName(name);
            if (label != null) {
                this.setLabel(label);
            }
            if (description != null) {
                this.setDescription(description);
            }
            this.setCategory(category);
            this.setReadOnly(readOnly);
            this.setType(type);
            this.setAllowedValues(allowedValues);
        }

        public String getName() {
            return this.name != null ? this.name : "";
        }

        public void setName(String name) {
            this.name = name;
            if (this.label == null) {
                this.setLabel(null);
            }
        }

        public String getLabel() {
            return this.label != null ? this.label : "";
        }

        public void setLabel(String label) {
            if (label == null && this.name != null) {
                label = INFLECTOR.titleCase(INFLECTOR.humanize(INFLECTOR.underscore(this.name, new char[0]), new String[0]), new String[0]);
            }
            this.label = label;
        }

        public String getDescription() {
            return this.description != null ? this.description : "";
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public void setReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
        }

        public String getCategory() {
            return this.category != null ? this.category : "";
        }

        public void setCategory(String category) {
            this.category = category;
        }

        public Class<?> getType() {
            return this.type;
        }

        public void setType(Class<?> type) {
            this.type = type != null ? type : Object.class;
        }

        public boolean isBooleanType() {
            return Boolean.class.equals(this.type) || Boolean.TYPE.equals(this.type);
        }

        public boolean isPrimitive() {
            return this.type.isPrimitive();
        }

        public boolean isArrayType() {
            return this.type.isArray();
        }

        public Collection<?> getAllowedValues() {
            return this.allowedValues != null ? this.allowedValues : Collections.emptySet();
        }

        public void setAllowedValues(Collection<?> allowedValues) {
            this.allowedValues = allowedValues;
        }

        public void setAllowedValues(Object ... allowedValues) {
            this.allowedValues = allowedValues != null && allowedValues.length != 0 ? new ArrayList<Object>(Arrays.asList(allowedValues)) : null;
        }

        public boolean isInferred() {
            return this.inferred;
        }

        public void setInferred(boolean inferred) {
            this.inferred = inferred;
        }

        @Override
        public int compareTo(Property that) {
            if (this == that) {
                return 0;
            }
            if (that == null) {
                return 1;
            }
            int diff = ObjectUtil.compareWithNulls((Comparable)((Object)this.category), (Comparable)((Object)that.category));
            if (diff != 0) {
                return diff;
            }
            diff = ObjectUtil.compareWithNulls((Comparable)((Object)this.label), (Comparable)((Object)that.label));
            if (diff != 0) {
                return diff;
            }
            diff = ObjectUtil.compareWithNulls((Comparable)((Object)this.name), (Comparable)((Object)that.name));
            if (diff != 0) {
                return diff;
            }
            return 0;
        }

        public int hashCode() {
            return HashCode.compute(this.category, this.name, this.label);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Property) {
                Property that = (Property)obj;
                if (!ObjectUtil.isEqualWithNulls(this.category, that.category)) {
                    return false;
                }
                if (!ObjectUtil.isEqualWithNulls(this.label, that.label)) {
                    return false;
                }
                if (!ObjectUtil.isEqualWithNulls(this.name, that.name)) {
                    return false;
                }
                if (!ObjectUtil.isEqualWithNulls(this.value, that.value)) {
                    return false;
                }
                return ObjectUtil.isEqualWithNulls(this.readOnly, that.readOnly);
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.name != null) {
                sb.append(this.name).append(" = ");
            }
            sb.append(this.value);
            sb.append(" ( ");
            sb.append(this.readOnly ? "readonly " : "writable ");
            if (this.category != null) {
                sb.append("category=\"").append(this.category).append("\" ");
            }
            if (this.label != null) {
                sb.append("label=\"").append(this.label).append("\" ");
            }
            if (this.description != null) {
                sb.append("description=\"").append(this.description).append("\" ");
            }
            sb.append(")");
            return sb.toString();
        }
    }
}

