/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.excel;

import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.excel.ExcelUtils;
import org.molgenis.data.processor.CellProcessor;
import org.molgenis.data.support.AbstractMetaDataEntity;
import org.springframework.util.LinkedCaseInsensitiveMap;

public class ExcelEntity
extends AbstractMetaDataEntity {
    private static final long serialVersionUID = 8928375571009145452L;
    private final transient Row row;
    private final Map<String, Integer> colNamesMap;
    private final List<CellProcessor> cellProcessors;
    private transient Map<String, Object> cachedValueMap;

    public ExcelEntity(Row row, Map<String, Integer> colNamesMap, List<CellProcessor> cellProcessors, EntityMetaData entityMetaData) {
        super(entityMetaData);
        if (row == null) {
            throw new IllegalArgumentException("row is null");
        }
        if (colNamesMap == null) {
            throw new IllegalArgumentException("column names map is null");
        }
        this.row = row;
        this.colNamesMap = colNamesMap;
        this.cellProcessors = cellProcessors;
    }

    public Object get(String attributeName) {
        Object value;
        if (this.cachedValueMap == null) {
            this.cachedValueMap = new LinkedCaseInsensitiveMap();
        }
        if (this.cachedValueMap.containsKey(attributeName)) {
            value = this.cachedValueMap.get(attributeName);
        } else {
            Cell cell;
            Integer col = this.colNamesMap.get(attributeName);
            value = col != null ? ((cell = this.row.getCell(col.intValue())) != null ? ExcelUtils.toValue(cell, this.cellProcessors) : null) : null;
            this.cachedValueMap.put(attributeName, value);
        }
        return value;
    }

    public void set(String attributeName, Object value) {
        if (this.cachedValueMap == null) {
            this.cachedValueMap = new LinkedCaseInsensitiveMap();
        }
        this.cachedValueMap.put(attributeName, value);
    }

    public void set(Entity values) {
        this.colNamesMap.keySet().forEach(attr -> this.set((String)attr, values.get(attr)));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        for (String attr : this.colNamesMap.keySet()) {
            if (!first) {
                sb.append(",");
            }
            sb.append(attr).append("=").append(this.get(attr));
            first = false;
        }
        sb.append("]");
        return sb.toString();
    }

    public Iterable<String> getAttributeNames() {
        return this.colNamesMap.keySet();
    }
}

