/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.excel;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellReference;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.excel.ExcelEntity;
import org.molgenis.data.excel.ExcelUtils;
import org.molgenis.data.processor.AbstractCellProcessor;
import org.molgenis.data.processor.CellProcessor;
import org.molgenis.data.support.AbstractRepository;
import org.molgenis.data.support.DefaultAttributeMetaData;
import org.molgenis.data.support.DefaultEntityMetaData;
import org.springframework.util.LinkedCaseInsensitiveMap;

public class ExcelRepository
extends AbstractRepository {
    private final Sheet sheet;
    private List<CellProcessor> cellProcessors;
    private Map<String, Integer> colNamesMap;
    private EntityMetaData entityMetaData;

    public ExcelRepository(String fileName, Sheet sheet) {
        this(fileName, sheet, null);
    }

    public ExcelRepository(String fileName, Sheet sheet, List<CellProcessor> cellProcessors) {
        this.sheet = Objects.requireNonNull(sheet);
        if (sheet.getNumMergedRegions() > 0) {
            throw new MolgenisDataException(String.format("Sheet [%s] contains merged regions which is not supported", sheet.getSheetName()));
        }
        this.cellProcessors = cellProcessors;
    }

    public int getNrRows() {
        return this.sheet.getLastRowNum() + 1;
    }

    public Iterator<Entity> iterator() {
        final Iterator it = this.sheet.iterator();
        if (!it.hasNext()) {
            return Collections.emptyList().iterator();
        }
        Row headerRow = (Row)it.next();
        if (this.colNamesMap == null) {
            this.colNamesMap = this.toColNamesMap(headerRow);
        }
        if (!it.hasNext()) {
            return Collections.emptyList().iterator();
        }
        return new Iterator<Entity>(){
            ExcelEntity next = null;

            @Override
            public boolean hasNext() {
                if (it.hasNext() && this.next == null) {
                    ExcelEntity entity = new ExcelEntity((Row)it.next(), ExcelRepository.this.colNamesMap, ExcelRepository.this.cellProcessors, ExcelRepository.this.getEntityMetaData());
                    for (String name : entity.getAttributeNames()) {
                        if (!StringUtils.isNotEmpty((CharSequence)entity.getString(name))) continue;
                        this.next = entity;
                        break;
                    }
                    if (this.next == null) {
                        this.hasNext();
                    }
                }
                return this.next != null;
            }

            @Override
            public ExcelEntity next() {
                this.hasNext();
                ExcelEntity result = this.next;
                this.next = null;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void addCellProcessor(CellProcessor cellProcessor) {
        if (this.cellProcessors == null) {
            this.cellProcessors = new ArrayList<CellProcessor>();
        }
        this.cellProcessors.add(cellProcessor);
    }

    public EntityMetaData getEntityMetaData() {
        if (this.entityMetaData == null) {
            Iterator it;
            DefaultEntityMetaData editableEntityMetaData = new DefaultEntityMetaData(this.sheet.getSheetName(), ExcelEntity.class);
            if (this.colNamesMap == null && (it = this.sheet.iterator()).hasNext()) {
                this.colNamesMap = this.toColNamesMap((Row)it.next());
            }
            if (this.colNamesMap != null) {
                for (String colName : this.colNamesMap.keySet()) {
                    editableEntityMetaData.addAttributeMetaData((AttributeMetaData)new DefaultAttributeMetaData(colName, MolgenisFieldTypes.FieldTypeEnum.STRING), new EntityMetaData.AttributeRole[0]);
                }
            }
            this.entityMetaData = editableEntityMetaData;
        }
        return this.entityMetaData;
    }

    private Map<String, Integer> toColNamesMap(Row headerRow) {
        if (headerRow == null) {
            return null;
        }
        LinkedCaseInsensitiveMap columnIdx = new LinkedCaseInsensitiveMap();
        int i = 0;
        Iterator it = headerRow.cellIterator();
        while (it.hasNext()) {
            try {
                String header = AbstractCellProcessor.processCell((String)ExcelUtils.toValue((Cell)it.next()), (boolean)true, this.cellProcessors);
                if (null == header) continue;
                columnIdx.put(header, i++);
            }
            catch (IllegalStateException ex) {
                int row = headerRow.getRowNum();
                String column = CellReference.convertNumToColString((int)i);
                throw new IllegalStateException("Invalid value at [" + this.sheet.getSheetName() + "] " + column + row + 1, ex);
            }
        }
        return columnIdx;
    }

    public Set<RepositoryCapability> getCapabilities() {
        return Collections.emptySet();
    }

    public long count() {
        return Iterables.size((Iterable)((Object)this));
    }
}

