/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.excel;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.MolgenisInvalidFormatException;
import org.molgenis.data.Repository;
import org.molgenis.data.excel.ExcelRepository;
import org.molgenis.data.excel.ExcelSheetWriter;
import org.molgenis.data.processor.CellProcessor;
import org.molgenis.data.processor.TrimProcessor;
import org.molgenis.data.support.AbstractWritable;
import org.molgenis.data.support.DefaultAttributeMetaData;
import org.molgenis.data.support.FileRepositoryCollection;
import org.molgenis.data.support.GenericImporterExtensions;

public class ExcelRepositoryCollection
extends FileRepositoryCollection {
    public static final String NAME = "EXCEL";
    private final String name;
    private final Workbook workbook;

    public ExcelRepositoryCollection(File file) throws IOException, MolgenisInvalidFormatException {
        this(file, new CellProcessor[]{new TrimProcessor()});
    }

    public ExcelRepositoryCollection(File file, CellProcessor ... cellProcessors) throws IOException, MolgenisInvalidFormatException {
        this(file.getName(), new FileInputStream(file), cellProcessors);
    }

    public ExcelRepositoryCollection(String name, InputStream in, CellProcessor ... cellProcessors) throws IOException, MolgenisInvalidFormatException {
        super(GenericImporterExtensions.getExcel(), cellProcessors);
        this.name = name;
        try {
            this.workbook = WorkbookFactory.create((InputStream)in);
        }
        catch (InvalidFormatException e) {
            throw new MolgenisInvalidFormatException(e.getMessage());
        }
    }

    public Iterable<String> getEntityNames() {
        int count = this.getNumberOfSheets();
        ArrayList sheetNames = Lists.newArrayListWithCapacity((int)count);
        for (int i = 0; i < count; ++i) {
            sheetNames.add(this.getSheetName(i));
        }
        return sheetNames;
    }

    public Repository getRepository(String name) {
        Sheet poiSheet = this.workbook.getSheet(name);
        if (poiSheet == null) {
            return null;
        }
        return new ExcelRepository(name, poiSheet, this.cellProcessors);
    }

    public int getNumberOfSheets() {
        return this.workbook.getNumberOfSheets();
    }

    public String getSheetName(int i) {
        return this.workbook.getSheetName(i);
    }

    public ExcelRepository getSheet(int i) {
        Sheet poiSheet = this.workbook.getSheetAt(i);
        if (poiSheet == null) {
            return null;
        }
        return new ExcelRepository(this.name, poiSheet, this.cellProcessors);
    }

    public ExcelSheetWriter createWritable(String entityName, List<AttributeMetaData> attributes, AbstractWritable.AttributeWriteMode attributeWriteMode) {
        Sheet sheet = this.workbook.createSheet(entityName);
        return new ExcelSheetWriter(sheet, attributes, attributeWriteMode, this.cellProcessors);
    }

    public ExcelSheetWriter createWritable(String entityName, List<String> attributeNames) {
        List<AttributeMetaData> attributes = attributeNames != null ? attributeNames.stream().map(attr -> new DefaultAttributeMetaData(attr)).collect(Collectors.toList()) : null;
        return this.createWritable(entityName, attributes, AbstractWritable.AttributeWriteMode.ATTRIBUTE_NAMES);
    }

    public void save(OutputStream out) throws IOException {
        this.workbook.write(out);
    }

    public String getName() {
        return NAME;
    }

    public Repository addEntityMeta(EntityMetaData entityMeta) {
        return this.getRepository(entityMeta.getName());
    }

    public Iterator<Repository> iterator() {
        return new Iterator<Repository>(){
            Iterator<String> it;
            {
                this.it = ExcelRepositoryCollection.this.getEntityNames().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public Repository next() {
                return ExcelRepositoryCollection.this.getRepository(this.it.next());
            }
        };
    }

    public boolean hasRepository(String name) {
        if (null == name) {
            return false;
        }
        Iterator<String> entityNames = this.getEntityNames().iterator();
        while (entityNames.hasNext()) {
            if (!entityNames.next().equals(name)) continue;
            return true;
        }
        return false;
    }
}

