/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.excel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.convert.DateToStringConverter;
import org.molgenis.data.processor.AbstractCellProcessor;
import org.molgenis.data.processor.CellProcessor;
import org.molgenis.data.support.AbstractWritable;

public class ExcelSheetWriter
extends AbstractWritable {
    private final Sheet sheet;
    private int row;
    private List<CellProcessor> cellProcessors;
    private Iterable<AttributeMetaData> cachedAttributes;

    ExcelSheetWriter(Sheet sheet, Iterable<AttributeMetaData> attributes, AbstractWritable.AttributeWriteMode attributeWriteMode, List<CellProcessor> cellProcessors) {
        if (sheet == null) {
            throw new IllegalArgumentException("sheet is null");
        }
        this.sheet = sheet;
        this.cellProcessors = cellProcessors;
        this.row = 0;
        if (attributes != null) {
            this.writeAttributeHeaders(attributes, attributeWriteMode);
        }
    }

    public void add(Entity entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity cannot be null");
        }
        if (this.cachedAttributes == null) {
            throw new MolgenisDataException("The attribute names are not defined, call writeAttributeNames first");
        }
        int i = 0;
        Row poiRow = this.sheet.createRow(this.row++);
        for (AttributeMetaData attribute : this.cachedAttributes) {
            Cell cell = poiRow.createCell(i++, 1);
            cell.setCellValue(this.toValue(entity.get(attribute.getName())));
        }
        entity.getIdValue();
    }

    public void writeAttributeHeaders(Iterable<AttributeMetaData> attributes, AbstractWritable.AttributeWriteMode attributeWriteMode) {
        if (attributes == null) {
            throw new IllegalArgumentException("Attributes cannot be null");
        }
        if (attributeWriteMode == null) {
            throw new IllegalArgumentException("AttributeWriteMode cannot be null");
        }
        if (this.cachedAttributes == null) {
            Row poiRow = this.sheet.createRow(this.row++);
            int i = 0;
            for (AttributeMetaData attribute : attributes) {
                Cell cell = poiRow.createCell(i++, 1);
                switch (attributeWriteMode) {
                    case ATTRIBUTE_LABELS: {
                        cell.setCellValue(AbstractCellProcessor.processCell((String)attribute.getLabel(), (boolean)true, this.cellProcessors));
                        break;
                    }
                    case ATTRIBUTE_NAMES: {
                        cell.setCellValue(AbstractCellProcessor.processCell((String)attribute.getName(), (boolean)true, this.cellProcessors));
                    }
                }
            }
            this.cachedAttributes = attributes;
        }
    }

    public void addCellProcessor(CellProcessor cellProcessor) {
        if (this.cellProcessors == null) {
            this.cellProcessors = new ArrayList<CellProcessor>();
        }
        this.cellProcessors.add(cellProcessor);
    }

    private String toValue(Object obj) {
        String value;
        block9: {
            block11: {
                block12: {
                    block10: {
                        block8: {
                            if (obj != null) break block8;
                            value = null;
                            break block9;
                        }
                        if (!(obj instanceof Date)) break block10;
                        value = new DateToStringConverter().convert((Date)obj);
                        break block9;
                    }
                    if (!(obj instanceof Entity)) break block11;
                    if (this.getEntityWriteMode() == null) break block12;
                    switch (this.getEntityWriteMode()) {
                        case ENTITY_IDS: {
                            value = ((Entity)obj).getIdValue().toString();
                            break block9;
                        }
                        case ENTITY_LABELS: {
                            value = ((Entity)obj).getLabelValue();
                            break block9;
                        }
                        default: {
                            throw new RuntimeException("Unknown write mode [" + this.getEntityWriteMode() + "]");
                        }
                    }
                }
                value = ((Entity)obj).getLabelValue();
                break block9;
            }
            if (obj instanceof Iterable) {
                StringBuilder strBuilder = new StringBuilder();
                for (Object listItem : (Iterable)obj) {
                    if (strBuilder.length() > 0) {
                        strBuilder.append(',');
                    }
                    strBuilder.append(this.toValue(listItem));
                }
                value = strBuilder.toString();
            } else {
                value = obj.toString();
            }
        }
        return AbstractCellProcessor.processCell(value, (boolean)false, this.cellProcessors);
    }

    public void close() throws IOException {
    }

    public void flush() {
    }

    public void clearCache() {
    }
}

