/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.excel;

import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.molgenis.data.DataConverter;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.processor.AbstractCellProcessor;
import org.molgenis.data.processor.CellProcessor;

public class ExcelUtils {
    public static String toValue(Cell cell) {
        return ExcelUtils.toValue(cell, null);
    }

    public static String toValue(Cell cell, List<CellProcessor> cellProcessors) {
        String value;
        block0 : switch (cell.getCellType()) {
            case 3: {
                value = null;
                break;
            }
            case 1: {
                value = cell.getStringCellValue();
                break;
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    value = DataConverter.toString((Object)cell.getDateCellValue());
                    break;
                }
                double x = cell.getNumericCellValue();
                if (x == Math.rint(x) && !Double.isNaN(x) && !Double.isInfinite(x)) {
                    value = String.valueOf((int)x);
                    break;
                }
                value = String.valueOf(x);
                break;
            }
            case 4: {
                value = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case 2: {
                FormulaEvaluator evaluator = cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
                CellValue cellValue = evaluator.evaluate(cell);
                switch (cellValue.getCellType()) {
                    case 4: {
                        value = String.valueOf(cellValue.getBooleanValue());
                        break block0;
                    }
                    case 0: {
                        if (DateUtil.isCellDateFormatted((Cell)cell)) {
                            value = DataConverter.toString((Object)DateUtil.getJavaDate((double)cellValue.getNumberValue(), (boolean)false));
                            break block0;
                        }
                        double x = cellValue.getNumberValue();
                        if (x == Math.rint(x) && !Double.isNaN(x) && !Double.isInfinite(x)) {
                            value = String.valueOf((int)x);
                            break block0;
                        }
                        value = String.valueOf(x);
                        break block0;
                    }
                    case 1: {
                        value = cellValue.getStringValue();
                        break block0;
                    }
                    case 3: {
                        value = null;
                        break block0;
                    }
                }
                throw new MolgenisDataException("unsupported cell type: " + cellValue.getCellType());
            }
            default: {
                throw new MolgenisDataException("unsupported cell type: " + cell.getCellType());
            }
        }
        return AbstractCellProcessor.processCell((String)value, (boolean)false, cellProcessors);
    }
}

