/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.annotations.Immutable;
import com.mongodb.annotations.NotThreadSafe;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;

@Immutable
public final class ClientSessionOptions {
    private final Boolean causallyConsistent;
    private final BsonDocument initialClusterTime;
    private final BsonTimestamp initialOperationTime;

    public Boolean isCausallyConsistent() {
        return this.causallyConsistent;
    }

    public BsonDocument getInitialClusterTime() {
        return this.initialClusterTime;
    }

    public BsonTimestamp getInitialOperationTime() {
        return this.initialOperationTime;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ClientSessionOptions(Builder builder) {
        this.causallyConsistent = builder.causallyConsistent;
        this.initialClusterTime = builder.initialClusterTime;
        this.initialOperationTime = builder.initialOperationTime;
    }

    @NotThreadSafe
    public static final class Builder {
        private Boolean causallyConsistent;
        private BsonDocument initialClusterTime;
        private BsonTimestamp initialOperationTime;

        public Builder causallyConsistent(boolean causallyConsistent) {
            this.causallyConsistent = causallyConsistent;
            return this;
        }

        public Builder initialClusterTime(BsonDocument initialClusterTime) {
            this.initialClusterTime = initialClusterTime;
            return this;
        }

        public Builder initialOperationTime(BsonTimestamp initialOperationTime) {
            this.initialOperationTime = initialOperationTime;
            return this;
        }

        public ClientSessionOptions build() {
            return new ClientSessionOptions(this);
        }

        private Builder() {
        }
    }
}

