/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.connection.MessageSettings;
import com.mongodb.connection.OpCode;
import com.mongodb.connection.RequestMessage;
import com.mongodb.connection.ServerVersion;
import com.mongodb.connection.SessionContext;
import org.bson.io.BsonOutput;

abstract class CommandMessage
extends RequestMessage {
    CommandMessage(String collectionName, OpCode opCode, MessageSettings settings) {
        super(collectionName, opCode, settings);
    }

    abstract boolean isResponseExpected();

    abstract RequestMessage.EncodingMetadata encodeMessageBodyWithMetadata(BsonOutput var1, SessionContext var2);

    @Override
    protected RequestMessage.EncodingMetadata encodeMessageBodyWithMetadata(BsonOutput bsonOutput, int messageStartPosition, SessionContext sessionContext) {
        return this.encodeMessageBodyWithMetadata(bsonOutput, sessionContext);
    }

    protected static OpCode getOpCode(MessageSettings settings) {
        return CommandMessage.useOpMsg(settings) ? OpCode.OP_MSG : OpCode.OP_QUERY;
    }

    protected static boolean useOpMsg(MessageSettings settings) {
        return CommandMessage.isServerVersionAtLeastThreeDotSix(settings);
    }

    private static boolean isServerVersionAtLeastThreeDotSix(MessageSettings settings) {
        return settings.getServerVersion().compareTo(new ServerVersion(3, 5)) >= 0;
    }

    protected boolean useOpMsg() {
        return CommandMessage.useOpMsg(this.getSettings());
    }
}

