/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.ConnectionString;
import com.mongodb.MongoDriverInformation;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.client.MongoClient;
import com.mongodb.async.client.MongoClientImpl;
import com.mongodb.async.client.MongoClientSettings;
import com.mongodb.async.client.NettyMongoClients;
import com.mongodb.connection.AsynchronousSocketChannelStreamFactory;
import com.mongodb.connection.Cluster;
import com.mongodb.connection.DefaultClusterFactory;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.StreamFactory;
import com.mongodb.connection.StreamFactoryFactory;
import com.mongodb.internal.event.EventListenerHelper;
import com.mongodb.lang.Nullable;
import java.io.Closeable;
import org.bson.codecs.configuration.CodecRegistry;

public final class MongoClients {
    public static MongoClient create() {
        return MongoClients.create(new ConnectionString("mongodb://localhost"));
    }

    @Deprecated
    public static MongoClient create(MongoClientSettings settings) {
        return MongoClients.create(settings, null);
    }

    public static MongoClient create(String connectionString) {
        return MongoClients.create(new ConnectionString(connectionString));
    }

    public static MongoClient create(ConnectionString connectionString) {
        return MongoClients.create(connectionString, null);
    }

    @Deprecated
    public static MongoClient create(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation) {
        return MongoClients.create(settings, mongoDriverInformation, null);
    }

    public static MongoClient create(ConnectionString connectionString, @Nullable MongoDriverInformation mongoDriverInformation) {
        return MongoClients.create(MongoClientSettings.builder().applyConnectionString(connectionString).build(), mongoDriverInformation, connectionString.getStreamType());
    }

    public static MongoClient create(com.mongodb.MongoClientSettings settings) {
        return MongoClients.create(settings, null);
    }

    public static MongoClient create(com.mongodb.MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation) {
        return MongoClients.create(MongoClientSettings.createFromClientSettings(settings), mongoDriverInformation, null);
    }

    private static MongoClient create(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation, @Nullable String requestedStreamType) {
        String streamType = MongoClients.getStreamType(requestedStreamType);
        if (MongoClients.isNetty(streamType) && settings.getStreamFactoryFactory() == null) {
            return NettyMongoClients.create(settings, mongoDriverInformation);
        }
        return new MongoClientImpl(settings, MongoClients.createCluster(settings, mongoDriverInformation, MongoClients.getStreamFactory(settings, streamType, false), MongoClients.getStreamFactory(settings, streamType, true)), (Closeable)null);
    }

    static MongoClient createMongoClient(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation, StreamFactory streamFactory, StreamFactory heartbeatStreamFactory, @Nullable Closeable externalResourceCloser) {
        return new MongoClientImpl(settings, MongoClients.createCluster(settings, mongoDriverInformation, streamFactory, heartbeatStreamFactory), externalResourceCloser);
    }

    private static Cluster createCluster(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation, StreamFactory streamFactory, StreamFactory heartbeatStreamFactory) {
        Assertions.notNull((String)"settings", (Object)settings);
        return new DefaultClusterFactory().createCluster(settings.getClusterSettings(), settings.getServerSettings(), settings.getConnectionPoolSettings(), streamFactory, heartbeatStreamFactory, settings.getCredentialList(), EventListenerHelper.getCommandListener(settings.getCommandListeners()), settings.getApplicationName(), mongoDriverInformation, settings.getCompressorList());
    }

    public static CodecRegistry getDefaultCodecRegistry() {
        return com.mongodb.MongoClientSettings.getDefaultCodecRegistry();
    }

    private static StreamFactory getStreamFactory(MongoClientSettings settings, String streamType, boolean isHeartbeat) {
        SocketSettings socketSettings;
        StreamFactoryFactory streamFactoryFactory = settings.getStreamFactoryFactory();
        SocketSettings socketSettings2 = socketSettings = isHeartbeat ? settings.getHeartbeatSocketSettings() : settings.getSocketSettings();
        if (streamFactoryFactory != null) {
            return streamFactoryFactory.create(socketSettings, settings.getSslSettings());
        }
        if (MongoClients.isNio2(streamType)) {
            return new AsynchronousSocketChannelStreamFactory(socketSettings, settings.getSslSettings());
        }
        throw new IllegalArgumentException("Unsupported stream type: " + streamType);
    }

    private static boolean isNetty(String streamType) {
        return streamType.toLowerCase().equals("netty");
    }

    private static boolean isNio2(String streamType) {
        return streamType.toLowerCase().equals("nio2");
    }

    private static String getStreamType(@Nullable String requestedStreamType) {
        if (requestedStreamType != null) {
            return requestedStreamType;
        }
        return System.getProperty("org.mongodb.async.type", "nio2");
    }

    private MongoClients() {
    }
}

