/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.Block;
import com.mongodb.ConnectionString;
import com.mongodb.ContextProvider;
import com.mongodb.DBObjectCodecProvider;
import com.mongodb.DBRefCodecProvider;
import com.mongodb.DocumentToDBRefTransformer;
import com.mongodb.Jep395RecordCodecProvider;
import com.mongodb.KotlinCodecProvider;
import com.mongodb.LoggerSettings;
import com.mongodb.MongoCompressor;
import com.mongodb.MongoCredential;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.ServerApi;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.Immutable;
import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.gridfs.codecs.GridFSFileCodecProvider;
import com.mongodb.client.model.geojson.codecs.GeoJsonCodecProvider;
import com.mongodb.client.model.mql.ExpressionCodecProvider;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.connection.StreamFactoryFactory;
import com.mongodb.event.CommandListener;
import com.mongodb.lang.Nullable;
import com.mongodb.spi.dns.DnsClient;
import com.mongodb.spi.dns.InetAddressResolver;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.bson.Transformer;
import org.bson.UuidRepresentation;
import org.bson.codecs.BsonCodecProvider;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.CollectionCodecProvider;
import org.bson.codecs.DocumentCodecProvider;
import org.bson.codecs.EnumCodecProvider;
import org.bson.codecs.IterableCodecProvider;
import org.bson.codecs.JsonObjectCodecProvider;
import org.bson.codecs.MapCodecProvider;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.jsr310.Jsr310CodecProvider;

@Immutable
public final class MongoClientSettings {
    private static final CodecRegistry DEFAULT_CODEC_REGISTRY = CodecRegistries.fromProviders(Arrays.asList(new ValueCodecProvider(), new BsonValueCodecProvider(), new DBRefCodecProvider(), new DBObjectCodecProvider(), new DocumentCodecProvider((Transformer)new DocumentToDBRefTransformer()), new CollectionCodecProvider((Transformer)new DocumentToDBRefTransformer()), new IterableCodecProvider((Transformer)new DocumentToDBRefTransformer()), new MapCodecProvider((Transformer)new DocumentToDBRefTransformer()), new GeoJsonCodecProvider(), new GridFSFileCodecProvider(), new Jsr310CodecProvider(), new JsonObjectCodecProvider(), new BsonCodecProvider(), new EnumCodecProvider(), new ExpressionCodecProvider(), new Jep395RecordCodecProvider(), new KotlinCodecProvider()));
    private final ReadPreference readPreference;
    private final WriteConcern writeConcern;
    private final boolean retryWrites;
    private final boolean retryReads;
    private final ReadConcern readConcern;
    private final MongoCredential credential;
    private final StreamFactoryFactory streamFactoryFactory;
    private final List<CommandListener> commandListeners;
    private final CodecRegistry codecRegistry;
    private final LoggerSettings loggerSettings;
    private final ClusterSettings clusterSettings;
    private final SocketSettings socketSettings;
    private final SocketSettings heartbeatSocketSettings;
    private final ConnectionPoolSettings connectionPoolSettings;
    private final ServerSettings serverSettings;
    private final SslSettings sslSettings;
    private final String applicationName;
    private final List<MongoCompressor> compressorList;
    private final UuidRepresentation uuidRepresentation;
    private final ServerApi serverApi;
    private final AutoEncryptionSettings autoEncryptionSettings;
    private final boolean heartbeatSocketTimeoutSetExplicitly;
    private final boolean heartbeatConnectTimeoutSetExplicitly;
    private final ContextProvider contextProvider;
    private final DnsClient dnsClient;
    private final InetAddressResolver inetAddressResolver;

    public static CodecRegistry getDefaultCodecRegistry() {
        return DEFAULT_CODEC_REGISTRY;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MongoClientSettings settings) {
        return new Builder(settings);
    }

    @Nullable
    public DnsClient getDnsClient() {
        return this.dnsClient;
    }

    @Nullable
    public InetAddressResolver getInetAddressResolver() {
        return this.inetAddressResolver;
    }

    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Nullable
    public MongoCredential getCredential() {
        return this.credential;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public boolean getRetryWrites() {
        return this.retryWrites;
    }

    public boolean getRetryReads() {
        return this.retryReads;
    }

    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @Nullable
    public StreamFactoryFactory getStreamFactoryFactory() {
        return this.streamFactoryFactory;
    }

    public List<CommandListener> getCommandListeners() {
        return Collections.unmodifiableList(this.commandListeners);
    }

    @Nullable
    public String getApplicationName() {
        return this.applicationName;
    }

    public List<MongoCompressor> getCompressorList() {
        return Collections.unmodifiableList(this.compressorList);
    }

    public UuidRepresentation getUuidRepresentation() {
        return this.uuidRepresentation;
    }

    @Nullable
    public ServerApi getServerApi() {
        return this.serverApi;
    }

    @Nullable
    public AutoEncryptionSettings getAutoEncryptionSettings() {
        return this.autoEncryptionSettings;
    }

    public LoggerSettings getLoggerSettings() {
        return this.loggerSettings;
    }

    public ClusterSettings getClusterSettings() {
        return this.clusterSettings;
    }

    public SslSettings getSslSettings() {
        return this.sslSettings;
    }

    public SocketSettings getSocketSettings() {
        return this.socketSettings;
    }

    public SocketSettings getHeartbeatSocketSettings() {
        return this.heartbeatSocketSettings;
    }

    public ConnectionPoolSettings getConnectionPoolSettings() {
        return this.connectionPoolSettings;
    }

    public ServerSettings getServerSettings() {
        return this.serverSettings;
    }

    @Nullable
    public ContextProvider getContextProvider() {
        return this.contextProvider;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoClientSettings that = (MongoClientSettings)o;
        return this.retryWrites == that.retryWrites && this.retryReads == that.retryReads && this.heartbeatSocketTimeoutSetExplicitly == that.heartbeatSocketTimeoutSetExplicitly && this.heartbeatConnectTimeoutSetExplicitly == that.heartbeatConnectTimeoutSetExplicitly && Objects.equals(this.readPreference, that.readPreference) && Objects.equals(this.writeConcern, that.writeConcern) && Objects.equals(this.readConcern, that.readConcern) && Objects.equals(this.credential, that.credential) && Objects.equals(this.streamFactoryFactory, that.streamFactoryFactory) && Objects.equals(this.commandListeners, that.commandListeners) && Objects.equals(this.codecRegistry, that.codecRegistry) && Objects.equals(this.loggerSettings, that.loggerSettings) && Objects.equals(this.clusterSettings, that.clusterSettings) && Objects.equals(this.socketSettings, that.socketSettings) && Objects.equals(this.heartbeatSocketSettings, that.heartbeatSocketSettings) && Objects.equals(this.connectionPoolSettings, that.connectionPoolSettings) && Objects.equals(this.serverSettings, that.serverSettings) && Objects.equals(this.sslSettings, that.sslSettings) && Objects.equals(this.applicationName, that.applicationName) && Objects.equals(this.compressorList, that.compressorList) && this.uuidRepresentation == that.uuidRepresentation && Objects.equals(this.serverApi, that.serverApi) && Objects.equals(this.autoEncryptionSettings, that.autoEncryptionSettings) && Objects.equals(this.dnsClient, that.dnsClient) && Objects.equals(this.inetAddressResolver, that.inetAddressResolver) && Objects.equals(this.contextProvider, that.contextProvider);
    }

    public int hashCode() {
        return Objects.hash(this.readPreference, this.writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.credential, this.streamFactoryFactory, this.commandListeners, this.codecRegistry, this.loggerSettings, this.clusterSettings, this.socketSettings, this.heartbeatSocketSettings, this.connectionPoolSettings, this.serverSettings, this.sslSettings, this.applicationName, this.compressorList, this.uuidRepresentation, this.serverApi, this.autoEncryptionSettings, this.heartbeatSocketTimeoutSetExplicitly, this.heartbeatConnectTimeoutSetExplicitly, this.dnsClient, this.inetAddressResolver, this.contextProvider);
    }

    public String toString() {
        return "MongoClientSettings{readPreference=" + this.readPreference + ", writeConcern=" + this.writeConcern + ", retryWrites=" + this.retryWrites + ", retryReads=" + this.retryReads + ", readConcern=" + this.readConcern + ", credential=" + this.credential + ", streamFactoryFactory=" + this.streamFactoryFactory + ", commandListeners=" + this.commandListeners + ", codecRegistry=" + this.codecRegistry + ", loggerSettings=" + this.loggerSettings + ", clusterSettings=" + this.clusterSettings + ", socketSettings=" + this.socketSettings + ", heartbeatSocketSettings=" + this.heartbeatSocketSettings + ", connectionPoolSettings=" + this.connectionPoolSettings + ", serverSettings=" + this.serverSettings + ", sslSettings=" + this.sslSettings + ", applicationName='" + this.applicationName + '\'' + ", compressorList=" + this.compressorList + ", uuidRepresentation=" + this.uuidRepresentation + ", serverApi=" + this.serverApi + ", autoEncryptionSettings=" + this.autoEncryptionSettings + ", dnsClient=" + this.dnsClient + ", inetAddressResolver=" + this.inetAddressResolver + ", contextProvider=" + this.contextProvider + '}';
    }

    private MongoClientSettings(Builder builder) {
        this.readPreference = builder.readPreference;
        this.writeConcern = builder.writeConcern;
        this.retryWrites = builder.retryWrites;
        this.retryReads = builder.retryReads;
        this.readConcern = builder.readConcern;
        this.credential = builder.credential;
        this.streamFactoryFactory = builder.streamFactoryFactory;
        this.codecRegistry = builder.codecRegistry;
        this.commandListeners = builder.commandListeners;
        this.applicationName = builder.applicationName;
        this.loggerSettings = builder.loggerSettingsBuilder.build();
        this.clusterSettings = builder.clusterSettingsBuilder.build();
        this.serverSettings = builder.serverSettingsBuilder.build();
        this.socketSettings = builder.socketSettingsBuilder.build();
        this.connectionPoolSettings = builder.connectionPoolSettingsBuilder.build();
        this.sslSettings = builder.sslSettingsBuilder.build();
        this.compressorList = builder.compressorList;
        this.uuidRepresentation = builder.uuidRepresentation;
        this.serverApi = builder.serverApi;
        this.dnsClient = builder.dnsClient;
        this.inetAddressResolver = builder.inetAddressResolver;
        this.autoEncryptionSettings = builder.autoEncryptionSettings;
        this.heartbeatSocketSettings = SocketSettings.builder().readTimeout(builder.heartbeatSocketTimeoutMS == 0 ? this.socketSettings.getConnectTimeout(TimeUnit.MILLISECONDS) : builder.heartbeatSocketTimeoutMS, TimeUnit.MILLISECONDS).connectTimeout(builder.heartbeatConnectTimeoutMS == 0 ? this.socketSettings.getConnectTimeout(TimeUnit.MILLISECONDS) : builder.heartbeatConnectTimeoutMS, TimeUnit.MILLISECONDS).build();
        this.heartbeatSocketTimeoutSetExplicitly = builder.heartbeatSocketTimeoutMS != 0;
        this.heartbeatConnectTimeoutSetExplicitly = builder.heartbeatConnectTimeoutMS != 0;
        this.contextProvider = builder.contextProvider;
    }

    @NotThreadSafe
    public static final class Builder {
        private ReadPreference readPreference = ReadPreference.primary();
        private WriteConcern writeConcern = WriteConcern.ACKNOWLEDGED;
        private boolean retryWrites = true;
        private boolean retryReads = true;
        private ReadConcern readConcern = ReadConcern.DEFAULT;
        private CodecRegistry codecRegistry = MongoClientSettings.getDefaultCodecRegistry();
        private StreamFactoryFactory streamFactoryFactory;
        private List<CommandListener> commandListeners = new ArrayList<CommandListener>();
        private final LoggerSettings.Builder loggerSettingsBuilder = LoggerSettings.builder();
        private final ClusterSettings.Builder clusterSettingsBuilder = ClusterSettings.builder();
        private final SocketSettings.Builder socketSettingsBuilder = SocketSettings.builder();
        private final ConnectionPoolSettings.Builder connectionPoolSettingsBuilder = ConnectionPoolSettings.builder();
        private final ServerSettings.Builder serverSettingsBuilder = ServerSettings.builder();
        private final SslSettings.Builder sslSettingsBuilder = SslSettings.builder();
        private MongoCredential credential;
        private String applicationName;
        private List<MongoCompressor> compressorList = Collections.emptyList();
        private UuidRepresentation uuidRepresentation = UuidRepresentation.UNSPECIFIED;
        private ServerApi serverApi;
        private AutoEncryptionSettings autoEncryptionSettings;
        private int heartbeatConnectTimeoutMS;
        private int heartbeatSocketTimeoutMS;
        private ContextProvider contextProvider;
        private DnsClient dnsClient;
        private InetAddressResolver inetAddressResolver;

        private Builder() {
        }

        private Builder(MongoClientSettings settings) {
            Assertions.notNull("settings", settings);
            this.applicationName = settings.getApplicationName();
            this.commandListeners = new ArrayList<CommandListener>(settings.getCommandListeners());
            this.compressorList = new ArrayList<MongoCompressor>(settings.getCompressorList());
            this.codecRegistry = settings.getCodecRegistry();
            this.readPreference = settings.getReadPreference();
            this.writeConcern = settings.getWriteConcern();
            this.retryWrites = settings.getRetryWrites();
            this.retryReads = settings.getRetryReads();
            this.readConcern = settings.getReadConcern();
            this.credential = settings.getCredential();
            this.uuidRepresentation = settings.getUuidRepresentation();
            this.serverApi = settings.getServerApi();
            this.dnsClient = settings.getDnsClient();
            this.inetAddressResolver = settings.getInetAddressResolver();
            this.streamFactoryFactory = settings.getStreamFactoryFactory();
            this.autoEncryptionSettings = settings.getAutoEncryptionSettings();
            this.contextProvider = settings.getContextProvider();
            this.loggerSettingsBuilder.applySettings(settings.getLoggerSettings());
            this.clusterSettingsBuilder.applySettings(settings.getClusterSettings());
            this.serverSettingsBuilder.applySettings(settings.getServerSettings());
            this.socketSettingsBuilder.applySettings(settings.getSocketSettings());
            this.connectionPoolSettingsBuilder.applySettings(settings.getConnectionPoolSettings());
            this.sslSettingsBuilder.applySettings(settings.getSslSettings());
            if (settings.heartbeatConnectTimeoutSetExplicitly) {
                this.heartbeatConnectTimeoutMS = settings.heartbeatSocketSettings.getConnectTimeout(TimeUnit.MILLISECONDS);
            }
            if (settings.heartbeatSocketTimeoutSetExplicitly) {
                this.heartbeatSocketTimeoutMS = settings.heartbeatSocketSettings.getReadTimeout(TimeUnit.MILLISECONDS);
            }
        }

        public Builder applyConnectionString(ConnectionString connectionString) {
            Boolean retryWritesValue;
            if (connectionString.getApplicationName() != null) {
                this.applicationName = connectionString.getApplicationName();
            }
            this.clusterSettingsBuilder.applyConnectionString(connectionString);
            if (!connectionString.getCompressorList().isEmpty()) {
                this.compressorList = connectionString.getCompressorList();
            }
            this.connectionPoolSettingsBuilder.applyConnectionString(connectionString);
            if (connectionString.getCredential() != null) {
                this.credential = connectionString.getCredential();
            }
            if (connectionString.getReadConcern() != null) {
                this.readConcern = connectionString.getReadConcern();
            }
            if (connectionString.getReadPreference() != null) {
                this.readPreference = connectionString.getReadPreference();
            }
            if ((retryWritesValue = connectionString.getRetryWritesValue()) != null) {
                this.retryWrites = retryWritesValue;
            }
            if (connectionString.getUuidRepresentation() != null) {
                this.uuidRepresentation = connectionString.getUuidRepresentation();
            }
            this.serverSettingsBuilder.applyConnectionString(connectionString);
            this.socketSettingsBuilder.applyConnectionString(connectionString);
            this.sslSettingsBuilder.applyConnectionString(connectionString);
            if (connectionString.getWriteConcern() != null) {
                this.writeConcern = connectionString.getWriteConcern();
            }
            return this;
        }

        public Builder applyToLoggerSettings(Block<LoggerSettings.Builder> block) {
            Assertions.notNull("block", block).apply(this.loggerSettingsBuilder);
            return this;
        }

        public Builder applyToClusterSettings(Block<ClusterSettings.Builder> block) {
            Assertions.notNull("block", block).apply(this.clusterSettingsBuilder);
            return this;
        }

        public Builder applyToSocketSettings(Block<SocketSettings.Builder> block) {
            Assertions.notNull("block", block).apply(this.socketSettingsBuilder);
            return this;
        }

        public Builder applyToConnectionPoolSettings(Block<ConnectionPoolSettings.Builder> block) {
            Assertions.notNull("block", block).apply(this.connectionPoolSettingsBuilder);
            return this;
        }

        public Builder applyToServerSettings(Block<ServerSettings.Builder> block) {
            Assertions.notNull("block", block).apply(this.serverSettingsBuilder);
            return this;
        }

        public Builder applyToSslSettings(Block<SslSettings.Builder> block) {
            Assertions.notNull("block", block).apply(this.sslSettingsBuilder);
            return this;
        }

        public Builder readPreference(ReadPreference readPreference) {
            this.readPreference = Assertions.notNull("readPreference", readPreference);
            return this;
        }

        public Builder writeConcern(WriteConcern writeConcern) {
            this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
            return this;
        }

        public Builder retryWrites(boolean retryWrites) {
            this.retryWrites = retryWrites;
            return this;
        }

        public Builder retryReads(boolean retryReads) {
            this.retryReads = retryReads;
            return this;
        }

        public Builder readConcern(ReadConcern readConcern) {
            this.readConcern = Assertions.notNull("readConcern", readConcern);
            return this;
        }

        public Builder credential(MongoCredential credential) {
            this.credential = Assertions.notNull("credential", credential);
            return this;
        }

        public Builder codecRegistry(CodecRegistry codecRegistry) {
            this.codecRegistry = Assertions.notNull("codecRegistry", codecRegistry);
            return this;
        }

        public Builder streamFactoryFactory(StreamFactoryFactory streamFactoryFactory) {
            this.streamFactoryFactory = Assertions.notNull("streamFactoryFactory", streamFactoryFactory);
            return this;
        }

        public Builder addCommandListener(CommandListener commandListener) {
            Assertions.notNull("commandListener", commandListener);
            this.commandListeners.add(commandListener);
            return this;
        }

        public Builder commandListenerList(List<CommandListener> commandListeners) {
            Assertions.notNull("commandListeners", commandListeners);
            this.commandListeners = new ArrayList<CommandListener>(commandListeners);
            return this;
        }

        public Builder applicationName(@Nullable String applicationName) {
            if (applicationName != null) {
                Assertions.isTrueArgument("applicationName UTF-8 encoding length <= 128", applicationName.getBytes(StandardCharsets.UTF_8).length <= 128);
            }
            this.applicationName = applicationName;
            return this;
        }

        public Builder compressorList(List<MongoCompressor> compressorList) {
            Assertions.notNull("compressorList", compressorList);
            this.compressorList = new ArrayList<MongoCompressor>(compressorList);
            return this;
        }

        public Builder uuidRepresentation(UuidRepresentation uuidRepresentation) {
            this.uuidRepresentation = Assertions.notNull("uuidRepresentation", uuidRepresentation);
            return this;
        }

        public Builder serverApi(ServerApi serverApi) {
            this.serverApi = Assertions.notNull("serverApi", serverApi);
            return this;
        }

        public Builder autoEncryptionSettings(@Nullable AutoEncryptionSettings autoEncryptionSettings) {
            this.autoEncryptionSettings = autoEncryptionSettings;
            return this;
        }

        public Builder contextProvider(@Nullable ContextProvider contextProvider) {
            this.contextProvider = contextProvider;
            return this;
        }

        public Builder dnsClient(@Nullable DnsClient dnsClient) {
            this.dnsClient = dnsClient;
            return this;
        }

        public Builder inetAddressResolver(@Nullable InetAddressResolver inetAddressResolver) {
            this.inetAddressResolver = inetAddressResolver;
            return this;
        }

        Builder heartbeatConnectTimeoutMS(int heartbeatConnectTimeoutMS) {
            this.heartbeatConnectTimeoutMS = heartbeatConnectTimeoutMS;
            return this;
        }

        Builder heartbeatSocketTimeoutMS(int heartbeatSocketTimeoutMS) {
            this.heartbeatSocketTimeoutMS = heartbeatSocketTimeoutMS;
            return this;
        }

        public MongoClientSettings build() {
            return new MongoClientSettings(this);
        }
    }
}

