/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterId;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ClusterType;
import com.mongodb.internal.connection.AbstractMultiServerCluster;
import com.mongodb.internal.connection.ClusterableServerFactory;
import com.mongodb.internal.connection.DnsSrvRecordInitializer;
import com.mongodb.internal.connection.DnsSrvRecordMonitor;
import com.mongodb.internal.connection.DnsSrvRecordMonitorFactory;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;

public final class DnsMultiServerCluster
extends AbstractMultiServerCluster {
    private final DnsSrvRecordMonitor dnsSrvRecordMonitor;
    private volatile MongoException srvResolutionException;

    public DnsMultiServerCluster(ClusterId clusterId, ClusterSettings settings, ClusterableServerFactory serverFactory, DnsSrvRecordMonitorFactory dnsSrvRecordMonitorFactory) {
        super(clusterId, settings, serverFactory);
        this.dnsSrvRecordMonitor = dnsSrvRecordMonitorFactory.create(Assertions.assertNotNull(settings.getSrvHost()), settings.getSrvServiceName(), new DnsSrvRecordInitializer(){
            private volatile boolean initialized;

            @Override
            public void initialize(Collection<ServerAddress> hosts) {
                DnsMultiServerCluster.this.srvResolutionException = null;
                if (!this.initialized) {
                    this.initialized = true;
                    DnsMultiServerCluster.this.initialize(this.applySrvMaxHosts(hosts));
                } else {
                    DnsMultiServerCluster.this.onChange(this.applySrvMaxHosts(hosts));
                }
            }

            private Collection<ServerAddress> applySrvMaxHosts(Collection<ServerAddress> hosts) {
                Collection<ServerAddress> newHosts = hosts;
                Integer srvMaxHosts = DnsMultiServerCluster.this.getSettings().getSrvMaxHosts();
                if (srvMaxHosts != null && srvMaxHosts > 0 && srvMaxHosts < hosts.size()) {
                    ArrayList<ServerAddress> newHostsList = new ArrayList<ServerAddress>(hosts);
                    Collections.shuffle(newHostsList, ThreadLocalRandom.current());
                    newHosts = newHostsList.subList(0, srvMaxHosts);
                }
                return newHosts;
            }

            @Override
            public void initialize(MongoException initializationException) {
                if (!this.initialized) {
                    DnsMultiServerCluster.this.srvResolutionException = initializationException;
                    DnsMultiServerCluster.this.initialize(Collections.emptyList());
                }
            }

            @Override
            public ClusterType getClusterType() {
                return DnsMultiServerCluster.this.getClusterType();
            }
        });
        this.dnsSrvRecordMonitor.start();
    }

    @Override
    @Nullable
    protected MongoException getSrvResolutionException() {
        return this.srvResolutionException;
    }

    @Override
    public void close() {
        if (this.dnsSrvRecordMonitor != null) {
            this.dnsSrvRecordMonitor.close();
        }
        super.close();
    }
}

