/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.alpn.agent;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import org.mortbay.jetty.alpn.agent.ReplacingClassFileTransformer;
import org.mortbay.jetty.alpn.agent.Util;
import org.mortbay.jetty.alpn.agent.VersionMapping;

public final class Premain {
    private static final VersionMapping[] ALPN_MAPPINGS = new VersionMapping[]{new VersionMapping("8.1.11.v20170118", 1, 8, 0, 121), new VersionMapping("8.1.10.v20161026", 1, 8, 0, 112), new VersionMapping("8.1.9.v20160720", 1, 8, 0, 101), new VersionMapping("8.1.8.v20160420", 1, 8, 0, 92), new VersionMapping("8.1.7.v20160121", 1, 8, 0, 71), new VersionMapping("8.1.6.v20151105", 1, 8, 0, 65), new VersionMapping("8.1.5.v20150921", 1, 8, 0, 60), new VersionMapping("8.1.4.v20150727", 1, 8, 0, 51), new VersionMapping("8.1.3.v20150130", 1, 8, 0, 31), new VersionMapping("8.1.2.v20141202", 1, 8, 0, 25), new VersionMapping("8.1.0.v20141016", 1, 8, 0, 0), new VersionMapping("7.1.3.v20150130", 1, 7, 0, 75), new VersionMapping("7.1.2.v20141202", 1, 7, 0, 71), new VersionMapping("7.1.0.v20141016", 1, 7, 0, 0)};
    private static final VersionMapping[] NPN_MAPPINGS = new VersionMapping[]{new VersionMapping("1.1.11.v20150415", 1, 7, 0, 80), new VersionMapping("1.1.10.v20150130", 1, 7, 0, 75), new VersionMapping("1.1.9.v20141016", 1, 7, 0, 71), new VersionMapping("1.1.8.v20141013", 1, 7, 0, 55), new VersionMapping("1.1.6.v20130911", 1, 7, 0, 40), new VersionMapping("1.1.5.v20130313", 1, 7, 0, 15), new VersionMapping("1.1.4.v20130313", 1, 7, 0, 13), new VersionMapping("1.1.3.v20130313", 1, 7, 0, 9), new VersionMapping("1.1.1.v20121030", 1, 7, 0, 6), new VersionMapping("1.1.0.v20120525", 1, 7, 0, 4), new VersionMapping("1.0.0.v20120402", 1, 7, 0, 0)};

    public static void premain(String args, Instrumentation inst) throws Exception {
        VersionMapping[] mappings;
        String artifactName;
        if ("forceNpn=true".equals(args)) {
            artifactName = "npn-boot";
            mappings = NPN_MAPPINGS;
        } else {
            artifactName = "alpn-boot";
            mappings = ALPN_MAPPINGS;
        }
        String javaVersion = System.getProperty("java.version", "");
        String artifactVersion = Premain.findArtifactVersion(mappings);
        if (artifactVersion == null) {
            Util.log("Could not find a matching " + artifactName + " JAR for Java version: " + javaVersion);
            return;
        }
        String artifactFileName = artifactName + '-' + artifactVersion + ".jar";
        URL artifactUrl = Premain.class.getResource(artifactFileName);
        if (artifactUrl == null) {
            Util.log("Could not find a JAR file: " + artifactFileName);
            return;
        }
        Util.log("Using: " + artifactFileName);
        Premain.configureBootstrapClassLoaderSearch(inst, artifactUrl, artifactName, artifactVersion);
        Premain.configureClassFileTransformer(inst, artifactUrl);
    }

    private static String findArtifactVersion(VersionMapping[] mappings) {
        for (VersionMapping m : mappings) {
            if (!m.matches()) continue;
            return m.artifactVersion();
        }
        return null;
    }

    private static void configureBootstrapClassLoaderSearch(Instrumentation inst, URL artifactUrl, String artifactName, String artifactVersion) throws IOException {
        File tmpFile = File.createTempFile(artifactName + '-' + artifactVersion + '.', ".jar");
        tmpFile.deleteOnExit();
        try (FileOutputStream out = new FileOutputStream(tmpFile);
             InputStream in = artifactUrl.openStream();){
            int readBytes;
            byte[] buf = new byte[8192];
            while ((readBytes = in.read(buf)) >= 0) {
                ((OutputStream)out).write(buf, 0, readBytes);
            }
        }
        inst.appendToBootstrapClassLoaderSearch(new JarFile(tmpFile));
    }

    private static void configureClassFileTransformer(Instrumentation inst, URL artifactUrl) throws IOException {
        HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
        try (JarInputStream jarIn = new JarInputStream(artifactUrl.openStream());){
            JarEntry e;
            byte[] buf = new byte[8192];
            while ((e = jarIn.getNextJarEntry()) != null) {
                int readBytes;
                String entryName = e.getName();
                if (!entryName.endsWith(".class")) continue;
                ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
                while ((readBytes = jarIn.read(buf)) >= 0) {
                    out.write(buf, 0, readBytes);
                }
                String className = entryName.substring(0, entryName.length() - 6);
                classes.put(className, out.toByteArray());
            }
        }
        inst.addTransformer(new ReplacingClassFileTransformer(classes));
    }

    private Premain() {
    }
}

