/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.api;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.multiverse.api.BackoffPolicy;

public final class ExponentialBackoffPolicy
implements BackoffPolicy {
    public static final BackoffPolicy MAX_100_MS = new ExponentialBackoffPolicy();
    private final long maxDelayNs;
    private final long minDelayNs;
    private final long[] slotTimes;

    public ExponentialBackoffPolicy() {
        this(1000L, TimeUnit.MILLISECONDS.toNanos(100L), TimeUnit.NANOSECONDS);
    }

    public ExponentialBackoffPolicy(long minDelayNs, long maxDelay, TimeUnit unit) {
        this.maxDelayNs = unit.toNanos(maxDelay);
        this.minDelayNs = minDelayNs;
        if (minDelayNs > this.maxDelayNs) {
            throw new IllegalArgumentException("minimum delay can't be larger than maximum delay");
        }
        Random random = new Random();
        this.slotTimes = new long[1000];
        double a = 100.0;
        double b = -4963.0;
        for (int k = 0; k < this.slotTimes.length; ++k) {
            this.slotTimes[k] = Math.round(random.nextDouble() * (double)this.f(k, a, b));
        }
    }

    private int f(int x, double a, double b) {
        int result = (int)Math.round(a * (double)x * (double)x + b * (double)x);
        return result < 0 ? 0 : result;
    }

    @Override
    public void delay(int attempt) throws InterruptedException {
        this.delayedUninterruptible(attempt);
    }

    @Override
    public void delayedUninterruptible(int attempt) {
        long delayNs = this.calcDelayNs(attempt);
        if (delayNs >= this.minDelayNs) {
            LockSupport.parkNanos(delayNs);
        } else if (attempt % 20 == 0) {
            Thread.yield();
        }
    }

    protected long calcDelayNs(int attempt) {
        int slotIndex = attempt >= this.slotTimes.length ? this.slotTimes.length - 1 : attempt;
        return this.slotTimes[slotIndex];
    }
}

